/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum OperatingSystem {
    Unknown(1),
    Windows(2),
    Android(3),
    MacOS(4),
    IOS(5),
    Linux(6),
    TvOS(7),
    WatchOS(8);

    private final int value;
    private static final Map<Integer, OperatingSystem> lookup;

    private OperatingSystem(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static OperatingSystem getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, OperatingSystem>();
        for (OperatingSystem s : EnumSet.allOf(OperatingSystem.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

