/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum BundlePolicy {
    Balanced(1),
    MaxCompatibility(2),
    MaxBundle(3);

    private final int value;
    private static final Map<Integer, BundlePolicy> lookup;

    private BundlePolicy(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static BundlePolicy getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, BundlePolicy>();
        for (BundlePolicy s : EnumSet.allOf(BundlePolicy.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

