/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate1;
import fm.icelink.ManagedStopwatch;
import fm.icelink.ManagedThread;

public class AudioClock {
    private IAction2<Integer, Integer> __raiseCallback;
    private ManagedThread __thread;
    private int _blockAlign;
    private int _channelCount;
    private int _clockRate;
    private boolean _running;
    private int _strictDuration;

    public AudioClock(int clockRate, int channelCount, int blockAlign, IAction2<Integer, Integer> raiseCallback) {
        this.setClockRate(clockRate);
        this.setChannelCount(channelCount);
        this.setBlockAlign(blockAlign);
        this.setStrictDuration(0);
        this.__raiseCallback = raiseCallback;
    }

    public int getBlockAlign() {
        return this._blockAlign;
    }

    public int getChannelCount() {
        return this._channelCount;
    }

    public int getClockRate() {
        return this._clockRate;
    }

    public boolean getRunning() {
        return this._running;
    }

    public int getStrictDuration() {
        return this._strictDuration;
    }

    private void innerLoop(ManagedThread thread) {
        boolean flag = this.getStrictDuration() > 0;
        int num = 2;
        ManagedStopwatch stopwatch = new ManagedStopwatch();
        long num2 = ManagedStopwatch.getFrequency() / 1000L;
        long num3 = 0L;
        stopwatch.start();
        while (this.getRunning()) {
            int num7;
            long num4 = stopwatch.getElapsedTicks() - num3;
            int num5 = (int)(num4 / num2);
            if (num5 <= 0) continue;
            if (flag && num5 >= this.getStrictDuration()) {
                int num6 = num5 / this.getStrictDuration();
                num7 = (this.getClockRate() * this.getChannelCount() * num * this.getStrictDuration() / 1000 + this.getBlockAlign() - 1) / this.getBlockAlign() * this.getBlockAlign();
                for (int i = 0; i < num6; ++i) {
                    this.__raiseCallback.invoke(num7, this.getStrictDuration());
                    num3 += (long)this.getStrictDuration() * num2;
                }
            } else {
                num7 = (this.getClockRate() * this.getChannelCount() * num * num5 / 1000 + this.getBlockAlign() - 1) / this.getBlockAlign() * this.getBlockAlign();
                this.__raiseCallback.invoke(num7, num5);
                num3 += num4;
            }
            ManagedThread.sleep(flag ? this.getStrictDuration() : 20);
        }
    }

    private void setBlockAlign(int value) {
        this._blockAlign = value;
    }

    private void setChannelCount(int value) {
        this._channelCount = value;
    }

    private void setClockRate(int value) {
        this._clockRate = value;
    }

    private void setRunning(boolean value) {
        this._running = value;
    }

    public void setStrictDuration(int value) {
        this._strictDuration = value;
    }

    public void start() {
        if (this.getRunning()) {
            throw new RuntimeException(new Exception("Already running."));
        }
        this.setRunning(true);
        this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

            @Override
            public String getId() {
                return "fm.icelink.AudioClock.innerLoop";
            }

            @Override
            public void invoke(ManagedThread thread) {
                AudioClock.this.innerLoop(thread);
            }
        });
        this.__thread.start();
    }

    public void stop() {
        this.setRunning(false);
        this.__thread = null;
    }
}

