/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DateExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.ILog;
import fm.icelink.LogConfiguration;
import fm.icelink.LogLevel;
import fm.icelink.LogProvider;
import fm.icelink.LogQueueItem;
import fm.icelink.ManagedAutoResetEvent;
import fm.icelink.ManagedConcurrentQueue;
import fm.icelink.ManagedThread;

class AsyncLogger
implements ILog {
    private static ManagedAutoResetEvent __event;
    private static ManagedConcurrentQueue<LogQueueItem> _logQueue;
    private static ManagedThread _loopThread;
    private String _tag;

    public AsyncLogger(String tag) {
        this.setTag(tag);
    }

    @Override
    public void debug(String message, Exception ex) {
        this.doLog(LogLevel.Debug, message, ex);
    }

    @Override
    public void debug(String message) {
        this.doLog(LogLevel.Debug, message, null);
    }

    private void doLog(LogLevel level, String msg, Exception ex) {
        _logQueue.enqueue(new LogQueueItem(DateExtensions.getNow(), this.getTag(), level, msg, ex));
        __event.set();
    }

    @Override
    public void error(String message, Exception ex) {
        this.doLog(LogLevel.Error, message, ex);
    }

    @Override
    public void error(String message) {
        this.doLog(LogLevel.Error, message, null);
    }

    @Override
    public void fatal(String message) {
        this.doLog(LogLevel.Fatal, message, null);
    }

    @Override
    public void fatal(String message, Exception ex) {
        this.doLog(LogLevel.Fatal, message, ex);
    }

    @Override
    public boolean getIsDebugEnabled() {
        return this.isLogEnabled(LogLevel.Debug);
    }

    @Override
    public String getTag() {
        return this._tag;
    }

    @Override
    public void info(String message, Exception ex) {
        this.doLog(LogLevel.Info, message, ex);
    }

    @Override
    public void info(String message) {
        this.doLog(LogLevel.Info, message, null);
    }

    @Override
    public boolean isLogEnabled(LogLevel level) {
        return LogConfiguration.getTagLogLevel(this.getTag()).getAssignedValue() <= level.getAssignedValue();
    }

    @Override
    public void log(String message) {
        this.doLog(LogLevel.Info, message, null);
    }

    private static void logLoop(ManagedThread thread) {
        block0: while (true) {
            if (!_logQueue.getIsEmpty()) {
                LogQueueItem item = null;
                Holder<Object> _var0 = new Holder<Object>(item);
                boolean _var1 = _logQueue.tryDequeue(_var0);
                item = _var0.getValue();
                if (LogConfiguration.getTagLogLevel(item.getTag()).getAssignedValue() > item.getLogLevel().getAssignedValue()) continue;
                LogProvider[] logProviderArray = LogConfiguration.getLogProviders();
                int n = logProviderArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    LogProvider provider = logProviderArray[n2];
                    provider.log(item.getTimeStamp(), item.getLogLevel(), item.getTag(), item.getMessage(), item.getException());
                    ++n2;
                }
            }
            __event.waitOne();
        }
    }

    private void setTag(String value) {
        this._tag = value;
    }

    @Override
    public void warn(String message) {
        this.doLog(LogLevel.Warn, message, null);
    }

    @Override
    public void warn(String message, Exception ex) {
        this.doLog(LogLevel.Warn, message, ex);
    }

    static {
        _logQueue = new ManagedConcurrentQueue();
        __event = new ManagedAutoResetEvent();
        _loopThread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

            @Override
            public String getId() {
                return "fm.icelink.AsyncLogger.logLoop";
            }

            @Override
            public void invoke(ManagedThread thread) {
                AsyncLogger.logLoop(thread);
            }
        });
        _loopThread.start();
    }
}

