/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun.turn;

import fm.icelink.DataBuffer;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.StringExtensions;
import fm.icelink.stun.Attribute;

public class ChannelNumberAttribute
extends Attribute {
    private int _channelNumber;

    private ChannelNumberAttribute() {
    }

    public ChannelNumberAttribute(int channelNumber) {
        this.setChannelNumber(channelNumber);
    }

    public int getChannelNumber() {
        return this._channelNumber;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getChannelNumberType();
    }

    @Override
    protected int getValueLength() {
        return 4;
    }

    public static ChannelNumberAttribute readValueFrom(DataBuffer buffer, int offset) {
        ChannelNumberAttribute attribute = new ChannelNumberAttribute();
        attribute.setChannelNumber(buffer.read16(offset));
        return attribute;
    }

    public void setChannelNumber(int value) {
        this._channelNumber = value;
    }

    public String toString() {
        return StringExtensions.format("CHANNEL-NUMBER {0}", IntegerExtensions.toString(this.getChannelNumber()));
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        IntegerHolder _var0 = new IntegerHolder(offset);
        boolean _var1 = buffer.write16(this.getChannelNumber(), offset, _var0);
        offset = _var0.getValue();
        buffer.write16(0, offset);
    }
}

