/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.IntegerHolder;
import fm.icelink.SctpCookieReceivedWhileShuttingDown;
import fm.icelink.SctpInvalidMandatoryParameter;
import fm.icelink.SctpInvalidStreamIdentifier;
import fm.icelink.SctpMissingMandatoryParameter;
import fm.icelink.SctpNoUserData;
import fm.icelink.SctpOutOfResource;
import fm.icelink.SctpProtocolViolation;
import fm.icelink.SctpRestartOfAnAssociationWithNewAddresses;
import fm.icelink.SctpStaleCookieError;
import fm.icelink.SctpUnrecognizedChunkType;
import fm.icelink.SctpUnrecognizedParameters;
import fm.icelink.SctpUnresolvableAddress;
import fm.icelink.SctpUserInitiatedAbort;

abstract class SctpErrorCause {
    private int _causeCode;

    public abstract byte[] getBytes();

    public int getCauseCode() {
        return this._causeCode;
    }

    public static SctpErrorCause parseBytes(byte[] value, int startIndex, IntegerHolder offsetPlus) {
        int num;
        byte[] buffer;
        try {
            buffer = new byte[ArrayExtensions.getLength(value) - startIndex];
            BitAssistant.copy(value, startIndex, buffer, 0, ArrayExtensions.getLength(buffer));
            num = Binary.fromBytes16(buffer, 0, false);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
        int _var0 = num;
        if (_var0 == 1) {
            SctpInvalidStreamIdentifier _var1 = SctpInvalidStreamIdentifier.parseBytes(buffer, offsetPlus);
            return _var1;
        }
        if (_var0 == 2) {
            SctpMissingMandatoryParameter _var2 = SctpMissingMandatoryParameter.parseBytes(buffer, offsetPlus);
            return _var2;
        }
        if (_var0 == 3) {
            SctpStaleCookieError _var3 = SctpStaleCookieError.parseBytes(buffer, offsetPlus);
            return _var3;
        }
        if (_var0 == 4) {
            SctpOutOfResource _var4 = SctpOutOfResource.parseBytes(buffer, offsetPlus);
            return _var4;
        }
        if (_var0 == 5) {
            SctpUnresolvableAddress _var5 = SctpUnresolvableAddress.parseBytes(buffer, offsetPlus);
            return _var5;
        }
        if (_var0 == 6) {
            SctpUnrecognizedChunkType _var6 = SctpUnrecognizedChunkType.parseBytes(buffer, offsetPlus);
            return _var6;
        }
        if (_var0 == 7) {
            SctpInvalidMandatoryParameter _var7 = SctpInvalidMandatoryParameter.parseBytes(buffer, offsetPlus);
            return _var7;
        }
        if (_var0 == 8) {
            SctpUnrecognizedParameters _var8 = SctpUnrecognizedParameters.parseBytes(buffer, offsetPlus);
            return _var8;
        }
        if (_var0 == 9) {
            SctpNoUserData _var9 = SctpNoUserData.parseBytes(buffer, offsetPlus);
            return _var9;
        }
        if (_var0 == 10) {
            SctpCookieReceivedWhileShuttingDown _var10 = SctpCookieReceivedWhileShuttingDown.parseBytes(buffer, offsetPlus);
            return _var10;
        }
        if (_var0 == 11) {
            SctpRestartOfAnAssociationWithNewAddresses _var11 = SctpRestartOfAnAssociationWithNewAddresses.parseBytes(buffer, offsetPlus);
            return _var11;
        }
        if (_var0 == 12) {
            SctpUserInitiatedAbort _var12 = SctpUserInitiatedAbort.parseBytes(buffer, offsetPlus);
            return _var12;
        }
        if (_var0 == 13) {
            SctpProtocolViolation _var13 = SctpProtocolViolation.parseBytes(buffer, offsetPlus);
            return _var13;
        }
        offsetPlus.setValue(0);
        return null;
    }

    protected SctpErrorCause() {
    }

    protected void setCauseCode(int value) {
        this._causeCode = value;
    }
}

