/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.ArrayExtensions;
import fm.Delegate;
import fm.DoubleAction;
import fm.Global;
import fm.Guid;
import fm.HashMapExtensions;
import fm.Holder;
import fm.HttpRequestCreatedArgs;
import fm.HttpResponseReceivedArgs;
import fm.HttpTransfer;
import fm.HttpWebRequestTransfer;
import fm.NullableBoolean;
import fm.SingleAction;
import fm.StringExtensions;
import fm.websync.BaseClient;
import fm.websync.BasePublisherEventArgs;
import fm.websync.BasePublisherRequestEventArgs;
import fm.websync.BasePublisherResponseEventArgs;
import fm.websync.ConcurrencyMode;
import fm.websync.Message;
import fm.websync.MessageRequestArgs;
import fm.websync.MessageRequestCreatedArgs;
import fm.websync.MessageResponseArgs;
import fm.websync.MessageResponseReceivedArgs;
import fm.websync.MessageTransfer;
import fm.websync.MessageTransferFactory;
import fm.websync.MetaChannels;
import fm.websync.Notification;
import fm.websync.Publication;
import fm.websync.PublisherNotifyRequestArgs;
import fm.websync.PublisherNotifyResponseArgs;
import fm.websync.PublisherPublishRequestArgs;
import fm.websync.PublisherPublishResponseArgs;
import fm.websync.PublisherResponseArgs;
import fm.websync.PublisherServiceRequestArgs;
import fm.websync.PublisherServiceResponseArgs;
import java.util.HashMap;

public class Publisher
extends BaseClient {
    private static DoubleAction<Publisher, PublisherNotifyRequestArgs> _onNotifyRequest;
    private static DoubleAction<Publisher, PublisherNotifyResponseArgs> _onNotifyResponse;
    private static DoubleAction<Publisher, PublisherPublishRequestArgs> _onPublishRequest;
    private static DoubleAction<Publisher, PublisherPublishResponseArgs> _onPublishResponse;
    private static DoubleAction<Publisher, PublisherServiceRequestArgs> _onServiceRequest;
    private static DoubleAction<Publisher, PublisherServiceResponseArgs> _onServiceResponse;
    private static HashMap<String, String> _requestUrlCache;
    private static Object _requestUrlCacheLock;

    public static DoubleAction<Publisher, PublisherNotifyRequestArgs> addOnNotifyRequest(DoubleAction<Publisher, PublisherNotifyRequestArgs> value) {
        _onNotifyRequest = (DoubleAction)Delegate.combine(_onNotifyRequest, value);
        return value;
    }

    public static DoubleAction<Publisher, PublisherNotifyResponseArgs> addOnNotifyResponse(DoubleAction<Publisher, PublisherNotifyResponseArgs> value) {
        _onNotifyResponse = (DoubleAction)Delegate.combine(_onNotifyResponse, value);
        return value;
    }

    public static DoubleAction<Publisher, PublisherPublishRequestArgs> addOnPublishRequest(DoubleAction<Publisher, PublisherPublishRequestArgs> value) {
        _onPublishRequest = (DoubleAction)Delegate.combine(_onPublishRequest, value);
        return value;
    }

    public static DoubleAction<Publisher, PublisherPublishResponseArgs> addOnPublishResponse(DoubleAction<Publisher, PublisherPublishResponseArgs> value) {
        _onPublishResponse = (DoubleAction)Delegate.combine(_onPublishResponse, value);
        return value;
    }

    public static DoubleAction<Publisher, PublisherServiceRequestArgs> addOnServiceRequest(DoubleAction<Publisher, PublisherServiceRequestArgs> value) {
        _onServiceRequest = (DoubleAction)Delegate.combine(_onServiceRequest, value);
        return value;
    }

    public static DoubleAction<Publisher, PublisherServiceResponseArgs> addOnServiceResponse(DoubleAction<Publisher, PublisherServiceResponseArgs> value) {
        _onServiceResponse = (DoubleAction)Delegate.combine(_onServiceResponse, value);
        return value;
    }

    public Notification notify(Guid clientId, String dataJson) throws Exception {
        return this.notify(new Notification(clientId, dataJson));
    }

    public Notification notify(Guid clientId, byte[] dataBytes, String tag) throws Exception {
        return this.notify(new Notification(clientId, dataBytes, tag));
    }

    public Notification notify(Guid clientId, byte[] dataBytes) throws Exception {
        return this.notify(new Notification(clientId, dataBytes));
    }

    public Notification notify(Guid clientId, String dataJson, String tag) throws Exception {
        return this.notify(new Notification(clientId, dataJson, tag));
    }

    public Notification notify(Notification notification) throws Exception {
        Notification[] notificationArray = this.notifyMany(new Notification[]{notification});
        if (notificationArray == null || ArrayExtensions.getLength((Object[])notificationArray) == 0) {
            return null;
        }
        return notificationArray[0];
    }

    public Notification[] notifyMany(Notification[] notifications) throws Exception {
        if (notifications == null || ArrayExtensions.getLength((Object[])notifications) == 0) {
            throw new Exception("notifications cannot be null/empty.");
        }
        return this.performNotify(notifications);
    }

    private Notification[] performNotify(Notification[] requestNotifications) throws Exception {
        PublisherNotifyRequestArgs args3 = new PublisherNotifyRequestArgs();
        args3.setRequests(requestNotifications);
        if (this.raiseRequestEvent(_onNotifyRequest, args3)) {
            Message[] requestMessages = Notification.toMessages(requestNotifications);
            PublisherResponseArgs responseArgs = this.send(requestMessages, super.getRequestUrl());
            Notification[] notificationArray = Notification.fromMessages(responseArgs.getResponses());
            PublisherNotifyResponseArgs args = new PublisherNotifyResponseArgs();
            args.setRequests(requestNotifications);
            args.setResponses(notificationArray);
            this.raiseResponseEvent(_onNotifyResponse, args, responseArgs);
            if (responseArgs.getException() != null) {
                throw responseArgs.getException();
            }
            return notificationArray;
        }
        return null;
    }

    private Publication[] performPublish(Publication[] requestPublications) throws Exception {
        PublisherPublishRequestArgs args3 = new PublisherPublishRequestArgs();
        args3.setRequests(requestPublications);
        if (this.raiseRequestEvent(_onPublishRequest, args3)) {
            Message[] requestMessages = Publication.toMessages(requestPublications);
            PublisherResponseArgs responseArgs = this.send(requestMessages, super.getRequestUrl());
            Publication[] publicationArray = Publication.fromMessages(responseArgs.getResponses());
            PublisherPublishResponseArgs args = new PublisherPublishResponseArgs();
            args.setRequests(requestPublications);
            args.setResponses(publicationArray);
            this.raiseResponseEvent(_onPublishResponse, args, responseArgs);
            if (responseArgs.getException() != null) {
                throw responseArgs.getException();
            }
            return publicationArray;
        }
        return null;
    }

    private Message[] performService(Message[] requestMessages) throws Exception {
        for (Message message : requestMessages) {
            if (MetaChannels.isServiceChannel(message.getBayeuxChannel())) continue;
            message.setBayeuxChannel(MetaChannels.convertChannelToServiced(message.getBayeuxChannel()));
        }
        PublisherServiceRequestArgs args3 = new PublisherServiceRequestArgs();
        args3.setRequests(requestMessages);
        if (this.raiseRequestEvent(_onServiceRequest, args3)) {
            PublisherResponseArgs responseArgs = this.send(requestMessages, super.getRequestUrl());
            Message[] responses = responseArgs.getResponses();
            PublisherServiceResponseArgs args = new PublisherServiceResponseArgs();
            args.setRequests(requestMessages);
            args.setResponses(responses);
            this.raiseResponseEvent(_onServiceResponse, args, responseArgs);
            if (responseArgs.getException() != null) {
                throw responseArgs.getException();
            }
            return responses;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processRequestUrl(String requestUrl) {
        HashMap<String, String> hashMap;
        if (StringExtensions.isNullOrEmpty((String)requestUrl)) {
            requestUrl = super.getRequestUrl();
        }
        boolean flag = false;
        String str = null;
        if (Global.equals((Object)((Object)super.getConcurrencyMode()), (Object)((Object)ConcurrencyMode.High))) {
            hashMap = _requestUrlCacheLock;
            synchronized (hashMap) {
                Holder _var0 = new Holder((Object)str);
                boolean _var1 = HashMapExtensions.tryGetValue(_requestUrlCache, (Object)requestUrl, (Holder)_var0);
                str = (String)_var0.getValue();
                flag = _var1;
            }
        }
        if (!flag) {
            str = requestUrl;
            str = HttpTransfer.addQueryToUrl((String)HttpTransfer.addQueryToUrl((String)str, (String)"src", (String)HttpWebRequestTransfer.getPlatformCode()), (String)"AspxAutoDetectCookieSupport", (String)"1");
            if (!Global.equals((Object)((Object)super.getConcurrencyMode()), (Object)((Object)ConcurrencyMode.High))) {
                return str;
            }
            hashMap = _requestUrlCache;
            synchronized (hashMap) {
                HashMapExtensions.getItem(_requestUrlCache).put(requestUrl, str);
            }
        }
        return str;
    }

    public Publication publish(String channel, String dataJson) throws Exception {
        return this.publish(new Publication(channel, dataJson));
    }

    public Publication publish(String channel, byte[] dataBytes) throws Exception {
        return this.publish(new Publication(channel, dataBytes));
    }

    public Publication publish(String channel, String dataJson, String tag) throws Exception {
        return this.publish(new Publication(channel, dataJson, tag));
    }

    public Publication publish(Publication publication) throws Exception {
        Publication[] publicationArray = this.publishMany(new Publication[]{publication});
        if (publicationArray == null || ArrayExtensions.getLength((Object[])publicationArray) == 0) {
            return null;
        }
        return publicationArray[0];
    }

    public Publication publish(String channel, byte[] dataBytes, String tag) throws Exception {
        return this.publish(new Publication(channel, dataBytes, tag));
    }

    public Publisher(String requestUrl) throws Exception {
        super.setRequestUrl(requestUrl);
    }

    public Publication[] publishMany(Publication[] publications) throws Exception {
        if (publications == null || ArrayExtensions.getLength((Object[])publications) == 0) {
            throw new Exception("publications cannot be null/empty.");
        }
        return this.performPublish(publications);
    }

    private <T extends BasePublisherEventArgs> void raiseEvent(DoubleAction<Publisher, T> eventMethod, T args) {
        args.setPublisher(this);
        if (eventMethod != null) {
            eventMethod.invoke((Object)this, args);
        }
    }

    private <T extends BasePublisherRequestEventArgs> boolean raiseRequestEvent(DoubleAction<Publisher, T> eventMethod, T args) {
        this.raiseEvent(eventMethod, args);
        return !args.getCancel();
    }

    private <T extends BasePublisherResponseEventArgs> void raiseResponseEvent(DoubleAction<Publisher, T> eventMethod, T args, PublisherResponseArgs responseArgs) {
        args.setException(responseArgs.getException());
        this.raiseEvent(eventMethod, args);
    }

    public static void removeOnNotifyRequest(DoubleAction<Publisher, PublisherNotifyRequestArgs> value) {
        _onNotifyRequest = (DoubleAction)Delegate.remove(_onNotifyRequest, value);
    }

    public static void removeOnNotifyResponse(DoubleAction<Publisher, PublisherNotifyResponseArgs> value) {
        _onNotifyResponse = (DoubleAction)Delegate.remove(_onNotifyResponse, value);
    }

    public static void removeOnPublishRequest(DoubleAction<Publisher, PublisherPublishRequestArgs> value) {
        _onPublishRequest = (DoubleAction)Delegate.remove(_onPublishRequest, value);
    }

    public static void removeOnPublishResponse(DoubleAction<Publisher, PublisherPublishResponseArgs> value) {
        _onPublishResponse = (DoubleAction)Delegate.remove(_onPublishResponse, value);
    }

    public static void removeOnServiceRequest(DoubleAction<Publisher, PublisherServiceRequestArgs> value) {
        _onServiceRequest = (DoubleAction)Delegate.remove(_onServiceRequest, value);
    }

    public static void removeOnServiceResponse(DoubleAction<Publisher, PublisherServiceResponseArgs> value) {
        _onServiceResponse = (DoubleAction)Delegate.remove(_onServiceResponse, value);
    }

    private PublisherResponseArgs send(Message[] requestMessages, String url) throws Exception {
        String str = this.processRequestUrl(url);
        url = this.processRequestUrl(url);
        for (Message message : requestMessages) {
            if (!super.getDisableBinary()) continue;
            message.setDisableBinary(new NullableBoolean(super.getDisableBinary()));
        }
        MessageRequestArgs args6 = new MessageRequestArgs(super.createHeaders());
        args6.setMessages(requestMessages);
        final Publisher _var0 = this;
        args6.setOnRequestCreated(new SingleAction<MessageRequestCreatedArgs>(){

            public void invoke(MessageRequestCreatedArgs e) {
                try {
                    _var0.internalOnRequestCreated(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final Publisher _var2 = this;
        args6.setOnResponseReceived(new SingleAction<MessageResponseReceivedArgs>(){

            public void invoke(MessageResponseReceivedArgs e) {
                try {
                    _var2.internalOnResponseReceived(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final Publisher _var4 = this;
        args6.setOnHttpRequestCreated(new SingleAction<HttpRequestCreatedArgs>(){

            public void invoke(HttpRequestCreatedArgs e) {
                try {
                    _var4.internalOnHttpRequestCreated(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final Publisher _var6 = this;
        args6.setOnHttpResponseReceived(new SingleAction<HttpResponseReceivedArgs>(){

            public void invoke(HttpResponseReceivedArgs e) {
                try {
                    _var6.internalOnHttpResponseReceived(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        args6.setSender((Object)this);
        args6.setTimeout(super.getRequestTimeout());
        args6.setUrl(url);
        MessageRequestArgs requestArgs = args6;
        requestArgs.setDynamicValue("frameUrl", str);
        MessageTransfer httpMessageTransfer = MessageTransferFactory.getHttpMessageTransfer();
        MessageResponseArgs args2 = httpMessageTransfer.send(requestArgs);
        try {
            httpMessageTransfer.shutdown();
        }
        catch (Exception exception1) {
            // empty catch block
        }
        if (args2.getException() != null) {
            PublisherResponseArgs args3 = new PublisherResponseArgs();
            args3.setException(args2.getException());
            return args3;
        }
        if (args2.getMessages() == null || ArrayExtensions.getLength((Object[])args2.getMessages()) == 0) {
            PublisherResponseArgs args4 = new PublisherResponseArgs();
            args4.setException(new Exception("Invalid response received from server."));
            return args4;
        }
        PublisherResponseArgs args5 = new PublisherResponseArgs();
        args5.setResponses(args2.getMessages());
        return args5;
    }

    public Message service(String channel, byte[] dataBytes, String tag) throws Exception {
        Message message = new Message(MetaChannels.convertChannelToServiced(channel));
        message.setDataBytes(dataBytes);
        message.setTag(tag);
        return this.service(message);
    }

    public Message service(String channel, String dataJson) throws Exception {
        Message message = new Message(MetaChannels.convertChannelToServiced(channel));
        message.setDataJson(dataJson);
        return this.service(message);
    }

    public Message service(Message message) throws Exception {
        Message[] messageArray = this.serviceMany(new Message[]{message});
        if (messageArray == null || ArrayExtensions.getLength((Object[])messageArray) == 0) {
            return null;
        }
        return messageArray[0];
    }

    public Message service(String channel, byte[] dataBytes) throws Exception {
        Message message = new Message(MetaChannels.convertChannelToServiced(channel));
        message.setDataBytes(dataBytes);
        return this.service(message);
    }

    public Message service(String channel, String dataJson, String tag) throws Exception {
        Message message = new Message(MetaChannels.convertChannelToServiced(channel));
        message.setDataJson(dataJson);
        message.setTag(tag);
        return this.service(message);
    }

    public Message[] serviceMany(Message[] messages) throws Exception {
        if (messages == null || ArrayExtensions.getLength((Object[])messages) == 0) {
            throw new Exception("messages cannot be null/empty.");
        }
        return this.performService(messages);
    }

    static {
        _requestUrlCache = new HashMap();
        _requestUrlCacheLock = new Object();
    }
}

