/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.app.Activity;
import android.text.Layout;
import android.widget.TextView;
import fm.icelink.LogLevel;
import fm.icelink.LogProvider;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class TextViewLogProvider
extends LogProvider {
    private Activity _activity;
    private TextView _textView;

    public TextViewLogProvider(Activity activity, TextView textView) {
        this(activity, textView, LogLevel.Debug);
    }

    public TextViewLogProvider(Activity activity, TextView textView, LogLevel level) {
        this._activity = activity;
        this._textView = textView;
        this.setLevel(level);
    }

    public void writeLine(final String text) {
        this._activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                TextViewLogProvider.this._textView.setText((CharSequence)(TextViewLogProvider.this._textView.getText() + text + "\n"));
                TextViewLogProvider.this._textView.post(new Runnable(){

                    @Override
                    public void run() {
                        Layout layout = TextViewLogProvider.this._textView.getLayout();
                        if (layout != null) {
                            int scrollAmount = layout.getLineTop(TextViewLogProvider.this._textView.getLineCount()) - TextViewLogProvider.this._textView.getHeight();
                            if (scrollAmount > 0) {
                                TextViewLogProvider.this._textView.scrollTo(0, scrollAmount);
                            } else {
                                TextViewLogProvider.this._textView.scrollTo(0, 0);
                            }
                        }
                    }
                });
            }
        });
    }

    protected void doLog(Date timestamp, LogLevel level, String tag, String message, Exception ex) {
        StringWriter trace = new StringWriter();
        ex.printStackTrace(new PrintWriter(trace));
        this.writeLine(String.format("%s %s", fm.icelink.android.LogProvider.getPrefix((LogLevel)level, (boolean)true), String.format("%s\n%s", message, trace.toString())));
    }
}

