/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Holder;
import fm.icelink.IMediaOutput;
import fm.icelink.IVideoOutput;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoEncoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.h264.Format;
import fm.icelink.h264.ProfileIdc;
import fm.icelink.h264.ProfileLevelId;
import fm.icelink.h264.Utility;
import fm.icelink.openh264.Native;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MediaDescription;

public class Encoder
extends VideoEncoder {
    private Native __encoder = new Native(true);
    private int __userSetBitrate = -1;
    private ProfileLevelId _profileLevelId;
    private int[] _supportedProfileIdcs;

    protected void doDestroy() {
        this.__encoder.destroy();
        this.__encoder = null;
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoBuffer buffer;
        int maxOutputBitrate = this.getMaxOutputBitrate();
        if (maxOutputBitrate > 0 && maxOutputBitrate != this.__encoder.getBitrate()) {
            Log.debug((String)StringExtensions.concat((String)"Changing OpenH264 encoder bitrate from ", (String)IntegerExtensions.toString((Integer)this.__encoder.getBitrate()), (String)" to ", (String)IntegerExtensions.toString((Integer)maxOutputBitrate)));
            this.__encoder.setBitrate(maxOutputBitrate);
        }
        if ((buffer = this.__encoder.encode(inputBuffer, (VideoFormat)super.getOutputFormat())) != null) {
            if (Utility.isKeyFrame((DataBuffer)buffer.getDataBuffer())) {
                Log.debug((String)"Encoder generated H.264 keyframe.");
            }
            frame.addBuffer((MediaBuffer)buffer);
            this.raiseFrame(frame);
            buffer.getDataBuffer().free();
        }
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        super.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
        Object[] attributeArray = mediaDescription.getRtpMapAttributes(((VideoFormat)super.getOutputFormat()).getName(), ((VideoFormat)super.getOutputFormat()).getClockRate(), ((VideoFormat)super.getOutputFormat()).getParameters());
        if (attributeArray != null) {
            for (int i = 0; i < ArrayExtensions.getLength((Object[])attributeArray); ++i) {
                Object attribute = attributeArray[i];
                FormatParametersAttribute relatedFormatParametersAttribute = attribute.getRelatedFormatParametersAttribute();
                if (relatedFormatParametersAttribute == null) {
                    relatedFormatParametersAttribute = new FormatParametersAttribute(attribute.getPayloadType());
                    attribute.setRelatedFormatParametersAttribute(relatedFormatParametersAttribute);
                }
                String str = null;
                Holder _var0 = new Holder(str);
                boolean _var1 = relatedFormatParametersAttribute.tryGetFormatSpecificParameter("profile-level-id", _var0);
                str = (String)_var0.getValue();
                if (str != null) {
                    Error error = this.updateProfileLevelId(new ProfileLevelId(str));
                    if (error == null) continue;
                    return error;
                }
                relatedFormatParametersAttribute.setFormatSpecificParameter("profile-level-id", this.getProfileLevelId().toString());
            }
        }
        return null;
    }

    public Encoder() {
        super(VideoFormat.getI420(), (VideoFormat)new Format());
        this.setProfileLevelId(new ProfileLevelId(66, 224, 31));
        this.setSupportedProfileIdcs(new int[]{ProfileIdc.getBaseline()});
    }

    public Encoder(IVideoOutput input) {
        this();
        super.addInput((IMediaOutput)input);
    }

    public int getBitrate() {
        return this.__encoder.getBitrate();
    }

    public boolean getForceKeyFrame() {
        return this.__encoder.getForceKeyFrame();
    }

    public String getLabel() {
        return "OpenH264 Encoder";
    }

    public int getMaxOutputBitrate() {
        int maxOutputBitrate = super.getMaxOutputBitrate();
        return this.__userSetBitrate < 0 ? maxOutputBitrate : (maxOutputBitrate < 0 ? this.__userSetBitrate : MathAssistant.min((int)this.__userSetBitrate, (int)maxOutputBitrate));
    }

    public ProfileLevelId getProfileLevelId() {
        return this._profileLevelId;
    }

    public double getQuality() {
        return this.__encoder.getQuality();
    }

    public int[] getSupportedProfileIdcs() {
        return this._supportedProfileIdcs;
    }

    public void setBitrate(int value) {
        this.__userSetBitrate = value;
        this.__encoder.setBitrate(value);
    }

    public void setForceKeyFrame(boolean value) {
        this.__encoder.setForceKeyFrame(value);
    }

    private void setProfileLevelId(ProfileLevelId value) {
        this._profileLevelId = value;
    }

    public void setQuality(double value) {
        this.__encoder.setQuality(value);
    }

    private void setSupportedProfileIdcs(int[] value) {
        this._supportedProfileIdcs = value;
    }

    private Error updateProfileLevelId(ProfileLevelId profileLevelId) {
        for (int num : this.getSupportedProfileIdcs()) {
            if (num != profileLevelId.getProfileIdc()) continue;
            this.setProfileLevelId(profileLevelId);
            return null;
        }
        return new Error(ErrorCode.LocalDescriptionError);
    }
}

