/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.prng;

import org.bouncycastle.crypto.prng.EntropySource;

public class EntropyUtil {
    public static byte[] generateSeed(EntropySource entropySource, int numBytes) {
        byte[] bytes = new byte[numBytes];
        if (numBytes * 8 <= entropySource.entropySize()) {
            byte[] ent = entropySource.getEntropy();
            System.arraycopy(ent, 0, bytes, 0, bytes.length);
        } else {
            int entSize = entropySource.entropySize() / 8;
            int i = 0;
            while (i < bytes.length) {
                byte[] ent = entropySource.getEntropy();
                if (ent.length <= bytes.length - i) {
                    System.arraycopy(ent, 0, bytes, i, ent.length);
                } else {
                    System.arraycopy(ent, 0, bytes, i, bytes.length - i);
                }
                i += entSize;
            }
        }
        return bytes;
    }
}

