/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.ivf;

import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.Encoding;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.vp8.Utility;

public class VideoRecorder
extends fm.icelink.VideoRecorder {
    private int __clockRate;
    private int __frameCount;
    private int __height;
    private volatile boolean __keyFrameWritten;
    private long __lastTimestamp;
    private long __presentationTimestamp;
    private int __width;

    @Override
    protected void doUpdateHeader() {
        super.getFileStream().write16To(12, this.__width);
        super.getFileStream().write16To(14, this.__height);
        super.getFileStream().write32To(16, this.__clockRate);
        super.getFileStream().write32To(24, this.__frameCount);
    }

    @Override
    protected boolean doWrite(VideoBuffer buffer, long presentationTimestamp) {
        if (!this.__keyFrameWritten && Utility.isKeyFrame(buffer.getDataBuffers()[0])) {
            this.__clockRate = ((VideoFormat)buffer.getFormat()).getClockRate();
            this.__width = Utility.deriveWidth(buffer.getDataBuffers()[0]);
            this.__height = Utility.deriveHeight(buffer.getDataBuffers()[0]);
            this.__keyFrameWritten = true;
        }
        DataBuffer dataBuffer = buffer.getDataBuffer();
        if (!this.__keyFrameWritten) {
            return false;
        }
        if (presentationTimestamp == -1L) {
            long num = DateExtensions.getTicks(DateExtensions.getUtcNow()) / 10000L;
            if (this.__presentationTimestamp == -1L) {
                this.__presentationTimestamp = 0L;
            } else {
                long num2 = num - this.__lastTimestamp;
                this.__presentationTimestamp += (long)((VideoFormat)buffer.getFormat()).getClockRate() * num2 / 1000L;
            }
            this.__lastTimestamp = num;
            presentationTimestamp = this.__presentationTimestamp;
        }
        super.getFileStream().write32(dataBuffer.getLength());
        super.getFileStream().write64(presentationTimestamp);
        super.getFileStream().write(dataBuffer.getData(), dataBuffer.getIndex(), dataBuffer.getLength());
        ++this.__frameCount;
        return true;
    }

    @Override
    protected void doWriteHeader() {
        super.getFileStream().write(Encoding.getUtf8().getBytes("DKIF"));
        super.getFileStream().write16(0);
        super.getFileStream().write16(32);
        super.getFileStream().write(Encoding.getUtf8().getBytes("VP80"));
        super.getFileStream().write16(0);
        super.getFileStream().write16(0);
        super.getFileStream().write32(0L);
        super.getFileStream().write32(1L);
        super.getFileStream().write32(0L);
        super.getFileStream().write32(0L);
    }

    public VideoRecorder(String path) {
        super(path);
    }
}

