/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpControlChunk;

class SctpShutdownChunk
extends SctpControlChunk {
    private long _cumulativeTsnAck;

    @Override
    public byte[] getBytes() {
        return SctpShutdownChunk.getBytes(this);
    }

    public static byte[] getBytes(SctpShutdownChunk chunk) {
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)chunk.getType());
        bytes.add((byte)0);
        bytes.addRange(Binary.toBytes16(8, false));
        bytes.addRange(Binary.toBytes32(chunk.getCumulativeTsnAck(), false));
        return bytes.toArray();
    }

    public long getCumulativeTsnAck() {
        return this._cumulativeTsnAck;
    }

    public static SctpShutdownChunk parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            offsetPlus.setValue(8);
            return new SctpShutdownChunk(Binary.fromBytes32(bytes, 4, false));
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpShutdownChunk(long cumulativeTSNAck) {
        super.setType(SctpChunkType.getShutdown());
        this.setCumulativeTsnAck(cumulativeTSNAck);
        super.setCanBundleWithDataAndSackChunks(false);
        super.setUnrecognized(false);
    }

    public void setCumulativeTsnAck(long value) {
        this._cumulativeTsnAck = value;
    }
}

