/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.BooleanHolder;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;

class Asn1ObjectIdentifier
extends Asn1Any {
    private long[] _values;

    public static boolean areEqual(long[] values1, long[] values2) {
        if (values1 == null != (values2 == null)) {
            return false;
        }
        if (values1 != null) {
            if (ArrayExtensions.getLength(values1) != ArrayExtensions.getLength(values2)) {
                return false;
            }
            for (int i = 0; i < ArrayExtensions.getLength(values1); ++i) {
                if (values1[i] == values2[i]) continue;
                return false;
            }
        }
        return true;
    }

    public Asn1ObjectIdentifier(long[] values) {
        this.setValues(values);
    }

    public Asn1ObjectIdentifier() {
    }

    @Override
    public byte[] getContents() {
        if (ArrayExtensions.getLength(this.getValues()) < 2) {
            Log.error("Object identifiers must have at least two values.");
            return null;
        }
        long num = this.getValues()[0];
        if (num < 0L || num > 2L) {
            Log.error("The first value in an object identifier is limited to values 0, 1, and 2.");
            return null;
        }
        long num2 = this.getValues()[1];
        if (!(num != 0L && num != 1L || num2 >= 0L && num2 <= 39L)) {
            Log.error("The second value in an object identifier is limited to the range 0 to 39 when the first value is 0 or 1.");
            return null;
        }
        ByteCollection bytes = new ByteCollection();
        bytes.add((byte)(40L * num + num2));
        for (int i = 2; i < ArrayExtensions.getLength(this.getValues()); ++i) {
            bytes.addRange(Asn1Any.encode128Long(this.getValues()[i]));
        }
        return bytes.toArray();
    }

    @Override
    public void getProperties(IntegerHolder tag, IntegerHolder klass, BooleanHolder isConstructed, BooleanHolder isIndefinite) {
        tag.setValue(6);
        klass.setValue(0);
        isConstructed.setValue(false);
        isIndefinite.setValue(false);
    }

    public long[] getValues() {
        return this._values;
    }

    public static Asn1ObjectIdentifier parseContents(byte[] contents) {
        int offset;
        int num6;
        byte num = contents[0];
        int num2 = 0;
        if (num >= 40) {
            num2 = num < 80 ? 1 : 2;
        }
        int num3 = num - 40 * num2;
        int num5 = 2;
        for (offset = 1; offset < ArrayExtensions.getLength(contents); offset += num6) {
            num6 = Asn1Any.getLength128(contents, offset);
            if (num6 == 0) {
                return null;
            }
            ++num5;
        }
        long[] values = new long[num5];
        values[0] = num2;
        values[1] = num3;
        offset = 1;
        for (int i = 2; i < num5; ++i) {
            num6 = Asn1Any.getLength128(contents, offset);
            values[i] = Asn1Any.decode128Long(contents, offset, num6);
            offset += num6;
        }
        return new Asn1ObjectIdentifier(values);
    }

    public void setValues(long[] value) {
        this._values = value;
    }
}

