/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.WebSocketCloseArgs;
import fm.icelink.WebSocketCloseCompleteArgs;
import fm.icelink.WebSocketOpenArgs;
import fm.icelink.WebSocketOpenFailureArgs;
import fm.icelink.WebSocketOpenSuccessArgs;
import fm.icelink.WebSocketReceiveArgs;
import fm.icelink.WebSocketStatusCode;
import fm.icelink.WebSocketStreamFailureArgs;

public class WebSocketBase {
    protected void raiseCloseComplete(WebSocketCloseArgs closeArgs, WebSocketStatusCode statusCode, String reason) {
        if (closeArgs != null && closeArgs.getOnComplete() != null) {
            WebSocketCloseCompleteArgs p = new WebSocketCloseCompleteArgs();
            p.setCloseArgs(closeArgs);
            p.setStatusCode(statusCode);
            p.setReason(reason);
            closeArgs.getOnComplete().invoke(p);
        }
    }

    protected void raiseOpenFailure(WebSocketOpenArgs openArgs, WebSocketStatusCode statusCode, Exception exception) {
        if (openArgs != null && openArgs.getOnFailure() != null) {
            WebSocketOpenFailureArgs p = new WebSocketOpenFailureArgs();
            p.setOpenArgs(openArgs);
            p.setStatusCode(statusCode);
            p.setException(exception);
            openArgs.getOnFailure().invoke(p);
        }
    }

    protected void raiseOpenSuccess(WebSocketOpenArgs openArgs) {
        if (openArgs != null && openArgs.getOnSuccess() != null) {
            WebSocketOpenSuccessArgs p = new WebSocketOpenSuccessArgs();
            p.setOpenArgs(openArgs);
            openArgs.getOnSuccess().invoke(p);
        }
    }

    protected void raiseReceive(WebSocketOpenArgs openArgs, String textMessage, byte[] binaryMessage) {
        if (openArgs != null && openArgs.getOnReceive() != null) {
            WebSocketReceiveArgs p = new WebSocketReceiveArgs();
            p.setOpenArgs(openArgs);
            p.setTextMessage(textMessage);
            p.setBinaryMessage(binaryMessage);
            openArgs.getOnReceive().invoke(p);
        }
    }

    protected void raiseStreamFailure(WebSocketOpenArgs openArgs, WebSocketStatusCode statusCode, Exception exception) {
        if (openArgs != null && openArgs.getOnStreamFailure() != null) {
            WebSocketStreamFailureArgs p = new WebSocketStreamFailureArgs();
            p.setOpenArgs(openArgs);
            p.setStatusCode(statusCode);
            p.setException(exception);
            openArgs.getOnStreamFailure().invoke(p);
        }
    }
}

