/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IFunction0;
import fm.icelink.IFunction1;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.PromiseBase;

public class Promise<T>
extends PromiseBase<T> {
    private Future<T> doFail(final IAction1<Exception> rejectAction, final Promise<T> promise) {
        super.process(promise, new IAction1<T>(){

            @Override
            public void invoke(T result) {
                promise.resolve(result);
            }
        }, new IAction1<Exception>(){

            @Override
            public void invoke(Exception exception) {
                if (rejectAction != null) {
                    rejectAction.invoke(exception);
                }
                promise.reject(exception);
            }
        });
        return promise;
    }

    private Future<T> doThen(final IAction1<T> resolveAction, final IAction1<Exception> rejectAction, final Promise<T> promise) {
        super.process(promise, new IAction1<T>(){

            @Override
            public void invoke(T result) {
                if (resolveAction != null) {
                    resolveAction.invoke(result);
                }
                promise.resolve(result);
            }
        }, new IAction1<Exception>(){

            @Override
            public void invoke(Exception exception) {
                if (rejectAction != null) {
                    rejectAction.invoke(exception);
                }
                promise.reject(exception);
            }
        });
        return promise;
    }

    private <R> Future<R> doThen(final IFunction1<T, Future<R>> resolveFunction, final IAction1<Exception> rejectAction, final Promise<R> promise) {
        super.process(promise, new IAction1<T>(){

            @Override
            public void invoke(T result) {
                IAction1 resolveAction = null;
                IAction1<Exception> action1 = null;
                Future future = (Future)resolveFunction.invoke(result);
                if (future == null) {
                    Log.error("Resolve function may not return null.");
                } else {
                    if (resolveAction == null) {
                        resolveAction = new IAction1<R>(){

                            @Override
                            public void invoke(R chainedResult) {
                                promise.resolve(chainedResult);
                            }
                        };
                    }
                    if (action1 == null) {
                        action1 = new IAction1<Exception>(){

                            @Override
                            public void invoke(Exception exception) {
                                promise.reject(exception);
                            }
                        };
                    }
                    future.then(resolveAction, action1);
                }
            }
        }, new IAction1<Exception>(){

            @Override
            public void invoke(Exception exception) {
                if (rejectAction != null) {
                    rejectAction.invoke(exception);
                }
                promise.reject(exception);
            }
        });
        return promise;
    }

    private static <R> Future<R> doWrapAsync(final Promise<R> promise, final IFunction0<R> callbackFunction) {
        ManagedThread.dispatch(new IAction0(){

            @Override
            public void invoke() {
                try {
                    if (callbackFunction == null) {
                        promise.resolve(null);
                    } else {
                        promise.resolve(callbackFunction.invoke());
                    }
                }
                catch (Exception exception) {
                    promise.reject(exception);
                }
            }
        });
        return promise;
    }

    private static Future<Object> doWrapAsync(final Promise<Object> promise, final IAction0 callbackAction) {
        ManagedThread.dispatch(new IAction0(){

            @Override
            public void invoke() {
                try {
                    if (callbackAction != null) {
                        callbackAction.invoke();
                    }
                    promise.resolve(null);
                }
                catch (Exception exception) {
                    promise.reject(exception);
                }
            }
        });
        return promise;
    }

    @Override
    public Future<T> fail(IAction1<Exception> rejectAction) {
        return this.doFail(rejectAction, new Promise<T>());
    }

    public Promise() {
    }

    public Promise(IAction2<IAction1<T>, IAction1<Exception>> callback) {
        IAction1 action = null;
        IAction1<Exception> action2 = null;
        if (action == null) {
            action = new IAction1<T>(){

                @Override
                public void invoke(T o) {
                    Promise.this.resolve(o);
                }
            };
        }
        if (action2 == null) {
            action2 = new IAction1<Exception>(){

                @Override
                public void invoke(Exception ex) {
                    Promise.this.reject(ex);
                }
            };
        }
        callback.invoke(action, action2);
    }

    @Override
    public <R> Future<R> then(IFunction1<T, Future<R>> resolveFunction) {
        return this.then(resolveFunction, null);
    }

    @Override
    public Future<T> then(IAction1<T> resolveAction) {
        return this.then(resolveAction, null);
    }

    @Override
    public <R> Future<R> then(IFunction1<T, Future<R>> resolveFunction, IAction1<Exception> rejectAction) {
        if (resolveFunction == null) {
            Log.error("Resolve function may not be null.");
            return null;
        }
        return this.doThen(resolveFunction, rejectAction, new Promise<T>());
    }

    @Override
    public Future<T> then(IAction1<T> resolveAction, IAction1<Exception> rejectAction) {
        return this.doThen(resolveAction, rejectAction, new Promise<T>());
    }

    public static <R> Future<R> wrap(IFunction0<R> callbackFunction) {
        Promise<R> promise = new Promise<R>();
        try {
            if (callbackFunction == null) {
                promise.resolve(null);
                return promise;
            }
            promise.resolve(callbackFunction.invoke());
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public static Future<Object> wrap(IAction0 callbackAction) {
        Promise<Object> promise = new Promise<Object>();
        try {
            if (callbackAction != null) {
                callbackAction.invoke();
            }
            promise.resolve(null);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public static <R> Future<R> wrapAsync(IFunction0<R> callbackFunction) {
        return Promise.doWrapAsync(new Promise(), callbackFunction);
    }

    public static Future<Object> wrapAsync(IAction0 callbackAction) {
        return Promise.doWrapAsync(new Promise<Object>(), callbackAction);
    }
}

