/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.BaseStats;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableInteger;
import fm.icelink.NullableLong;
import java.util.ArrayList;
import java.util.HashMap;

public class MediaTrackStats
extends BaseStats {
    private boolean _detached;
    private int _frameHeight;
    private int _frameRate;
    private long _framesCorrupted;
    private long _framesDecoded;
    private long _framesDropped;
    private long _framesEncoded;
    private long _framesReceived;
    private long _framesSent;
    private int _frameWidth;
    private boolean _stopped;
    private long[] _synchronizationSources;

    @Override
    protected void deserializeProperties(String key, String valueJson) {
        super.deserializeProperties(key, valueJson);
        String _var0 = key;
        if (_var0.equals("stopped")) {
            this.setStopped(JsonSerializer.deserializeBoolean(valueJson).getValue());
        } else if (_var0.equals("detached")) {
            this.setDetached(JsonSerializer.deserializeBoolean(valueJson).getValue());
        } else if (_var0.equals("ssrcs")) {
            this.setSynchronizationSources(JsonSerializer.deserializeLongArray(valueJson));
        } else if (_var0.equals("frameWidth")) {
            this.setFrameWidth(JsonSerializer.deserializeInteger(valueJson).getValue());
        } else if (_var0.equals("frameHeight")) {
            this.setFrameHeight(JsonSerializer.deserializeInteger(valueJson).getValue());
        } else if (_var0.equals("frameRate")) {
            this.setFrameRate(JsonSerializer.deserializeInteger(valueJson).getValue());
        } else if (_var0.equals("framesSent")) {
            this.setFramesSent(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("framesReceived")) {
            this.setFramesReceived(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("framesDecoded")) {
            this.setFramesDecoded(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("framesDropped")) {
            this.setFramesDropped(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("framesCorrupted")) {
            this.setFramesCorrupted(JsonSerializer.deserializeLong(valueJson).getValue());
        } else if (_var0.equals("framesEncoded")) {
            this.setFramesEncoded(JsonSerializer.deserializeLong(valueJson).getValue());
        }
    }

    public static MediaTrackStats fromJson(String mediaTrackJson) {
        return JsonSerializer.deserializeObject(mediaTrackJson, new IFunction0<MediaTrackStats>(){

            @Override
            public MediaTrackStats invoke() {
                return new MediaTrackStats();
            }
        }, new IAction3<MediaTrackStats, String, String>(){

            @Override
            public void invoke(MediaTrackStats obj, String key, String valueJson) {
                obj.deserializeProperties(key, valueJson);
            }
        });
    }

    public static MediaTrackStats[] fromJsonArray(String mediaTracksJson) {
        ArrayList<MediaTrackStats> list = JsonSerializer.deserializeObjectArray(mediaTracksJson, new IFunctionDelegate1<String, MediaTrackStats>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTrackStats.fromJson";
            }

            @Override
            public MediaTrackStats invoke(String mediaTrackJson) {
                return MediaTrackStats.fromJson(mediaTrackJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new MediaTrackStats[0]);
    }

    public boolean getDetached() {
        return this._detached;
    }

    public int getFrameHeight() {
        return this._frameHeight;
    }

    public int getFrameRate() {
        return this._frameRate;
    }

    public long getFramesCorrupted() {
        return this._framesCorrupted;
    }

    public long getFramesDecoded() {
        return this._framesDecoded;
    }

    public long getFramesDropped() {
        return this._framesDropped;
    }

    public long getFramesEncoded() {
        return this._framesEncoded;
    }

    public long getFramesReceived() {
        return this._framesReceived;
    }

    public long getFramesSent() {
        return this._framesSent;
    }

    public int getFrameWidth() {
        return this._frameWidth;
    }

    public boolean getStopped() {
        return this._stopped;
    }

    public long getSynchronizationSource() {
        long[] synchronizationSources = this.getSynchronizationSources();
        if (synchronizationSources == null || ArrayExtensions.getLength(synchronizationSources) == 0) {
            return 0L;
        }
        return synchronizationSources[0];
    }

    public long[] getSynchronizationSources() {
        return this._synchronizationSources;
    }

    @Override
    protected void serializeProperties(HashMap<String, String> jsonObject) {
        super.serializeProperties(jsonObject);
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "stopped", JsonSerializer.serializeBoolean(new NullableBoolean(this.getStopped())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "detached", JsonSerializer.serializeBoolean(new NullableBoolean(this.getDetached())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "ssrcs", JsonSerializer.serializeLongArray(this.getSynchronizationSources()));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "frameWidth", JsonSerializer.serializeInteger(new NullableInteger(this.getFrameWidth())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "frameHeight", JsonSerializer.serializeInteger(new NullableInteger(this.getFrameHeight())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "frameRate", JsonSerializer.serializeInteger(new NullableInteger(this.getFrameRate())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "framesSent", JsonSerializer.serializeLong(new NullableLong(this.getFramesSent())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "framesReceived", JsonSerializer.serializeLong(new NullableLong(this.getFramesReceived())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "framesDecoded", JsonSerializer.serializeLong(new NullableLong(this.getFramesDecoded())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "framesDropped", JsonSerializer.serializeLong(new NullableLong(this.getFramesDropped())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "framesCorrupted", JsonSerializer.serializeLong(new NullableLong(this.getFramesCorrupted())));
        HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "framesEncoded", JsonSerializer.serializeLong(new NullableLong(this.getFramesEncoded())));
    }

    void setDetached(boolean value) {
        this._detached = value;
    }

    void setFrameHeight(int value) {
        this._frameHeight = value;
    }

    void setFrameRate(int value) {
        this._frameRate = value;
    }

    void setFramesCorrupted(long value) {
        this._framesCorrupted = value;
    }

    void setFramesDecoded(long value) {
        this._framesDecoded = value;
    }

    void setFramesDropped(long value) {
        this._framesDropped = value;
    }

    void setFramesEncoded(long value) {
        this._framesEncoded = value;
    }

    void setFramesReceived(long value) {
        this._framesReceived = value;
    }

    void setFramesSent(long value) {
        this._framesSent = value;
    }

    void setFrameWidth(int value) {
        this._frameWidth = value;
    }

    void setStopped(boolean value) {
        this._stopped = value;
    }

    void setSynchronizationSources(long[] value) {
        this._synchronizationSources = value;
    }

    public static String toJson(MediaTrackStats mediaTrack) {
        return JsonSerializer.serializeObject(mediaTrack, new IAction2<MediaTrackStats, HashMap<String, String>>(){

            @Override
            public void invoke(MediaTrackStats obj, HashMap<String, String> jsonObject) {
                obj.serializeProperties(jsonObject);
            }
        });
    }

    public String toJson() {
        return MediaTrackStats.toJson(this);
    }

    public static String toJsonArray(MediaTrackStats[] mediaTracks) {
        return JsonSerializer.serializeObjectArray(mediaTracks, new IFunctionDelegate1<MediaTrackStats, String>(){

            @Override
            public String getId() {
                return "fm.icelink.MediaTrackStats.toJson";
            }

            @Override
            public String invoke(MediaTrackStats mediaTrack) {
                return MediaTrackStats.toJson(mediaTrack);
            }
        });
    }
}

