/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;

public class Crc32 {
    private long[] __lookup;
    private long _finalXorValue;
    private long _initialValue;
    private long _polynomial;
    private boolean _reverseBits;

    public long compute(byte[] bytes) {
        return this.compute(bytes, 0, ArrayExtensions.getLength(bytes));
    }

    public long compute(byte[] bytes, int offset, int length) {
        long initialValue = this.getInitialValue();
        for (int i = 0; i < length; ++i) {
            int num3;
            if (this.getReverseBits()) {
                num3 = (int)((BitAssistant.rightShiftLong(initialValue, 24) ^ (long)BitAssistant.castInteger(bytes[offset + i])) % 256L);
                initialValue = BitAssistant.leftShiftLong(initialValue, 8) ^ this.__lookup[num3];
                continue;
            }
            num3 = (int)((initialValue & 0xFFL ^ (long)BitAssistant.castInteger(bytes[offset + i])) % 256L);
            initialValue = BitAssistant.rightShiftLong(initialValue, 8) ^ this.__lookup[num3];
        }
        if ((initialValue ^= this.getFinalXorValue()) < 0L) {
            initialValue += 0xFFFFFFFFL;
            ++initialValue;
        }
        return initialValue & 0xFFFFFFFFL;
    }

    public long compute(byte[] bytes, int offset) {
        return this.compute(bytes, offset, ArrayExtensions.getLength(bytes) - offset);
    }

    public String computeHex(byte[] bytes, int offset, int length) {
        return BitAssistant.getHexString(Binary.toBytes32(this.compute(bytes, offset, length), false));
    }

    public String computeHex(byte[] bytes, int offset) {
        return this.computeHex(bytes, offset, ArrayExtensions.getLength(bytes) - offset);
    }

    public String computeHex(byte[] bytes) {
        return this.computeHex(bytes, 0, ArrayExtensions.getLength(bytes));
    }

    public Crc32(long polynomial, boolean reverseBits) {
        this.setPolynomial(Crc32.processPolynomial(polynomial));
        this.setReverseBits(reverseBits);
        this.setInitialValue(0xFFFFFFFFL);
        this.setFinalXorValue(0xFFFFFFFFL);
        this.__lookup = this.createLookup();
    }

    public Crc32(long polynomial) {
        this(polynomial, false);
    }

    private long[] createLookup() {
        long[] numArray = new long[256];
        for (int i = 0; i < ArrayExtensions.getLength(numArray); ++i) {
            long num2 = i;
            for (int j = 8; j > 0; --j) {
                if ((num2 & 1L) == 1L) {
                    num2 = num2 >> 1 ^ this.getPolynomial();
                    continue;
                }
                num2 >>= 1;
            }
            if (this.getReverseBits()) {
                numArray[Crc32.reverseBits8((int)i)] = Crc32.reverseBits32(num2);
                continue;
            }
            numArray[i] = num2;
        }
        return numArray;
    }

    public static long getCrc32cPolynomial() {
        return 517762881L;
    }

    public static long getCrc32dPolynomial() {
        return 2821953579L;
    }

    public static long getCrc32Polynomial() {
        return 79764919L;
    }

    public long getFinalXorValue() {
        return this._finalXorValue;
    }

    public long getInitialValue() {
        return this._initialValue;
    }

    public long getPolynomial() {
        return this._polynomial;
    }

    public boolean getReverseBits() {
        return this._reverseBits;
    }

    private static long processPolynomial(long polynomial) {
        return Crc32.reverseBits32(polynomial);
    }

    private static long reverseBits32(long value) {
        return Binary.fromBytes32(BitAssistant.getBinaryBytes(Crc32.reverseString(BitAssistant.getBinaryString(Binary.toBytes32(value, false)))), 0, false);
    }

    private static int reverseBits8(int value) {
        return Binary.fromBytes8(BitAssistant.getBinaryBytes(Crc32.reverseString(BitAssistant.getBinaryString(Binary.toBytes8(value)))), 0);
    }

    private static String reverseString(String value) {
        StringBuilder builder = new StringBuilder();
        for (int i = StringExtensions.getLength(value) - 1; i >= 0; --i) {
            StringBuilderExtensions.append(builder, StringExtensions.substring(value, i, 1));
        }
        return builder.toString();
    }

    public void setFinalXorValue(long value) {
        this._finalXorValue = value;
    }

    public void setInitialValue(long value) {
        this._initialValue = value;
    }

    private void setPolynomial(long value) {
        this._polynomial = value;
    }

    private void setReverseBits(boolean value) {
        this._reverseBits = value;
    }
}

