/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.DataBuffer;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioInputCollection;
import fm.icelink.IAudioOutput;
import fm.icelink.IAudioReframer;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaOutput;
import fm.icelink.IOutput;
import fm.icelink.MathAssistant;
import fm.icelink.MediaSource;
import fm.icelink.SoundReframerContext;

public abstract class AudioSource
extends MediaSource<IAudioOutput, IAudioInput, IAudioInputCollection, AudioSource, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>
implements IAudioOutput,
IMediaOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IOutput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement,
IAudioReframer {
    private SoundReframerContext __reframerContext = new SoundReframerContext(20.0);
    private double __volume = 1.0;

    public AudioSource(AudioFormat outputFormat) {
        super(outputFormat);
    }

    public static int calculateDuration(int dataLength, int clockRate, int channelCount) {
        return 1000 * dataLength / (clockRate * channelCount * 2);
    }

    public int calculateDuration(int dataLength) {
        return AudioSource.calculateDuration(dataLength, ((AudioFormat)super.getOutputFormat()).getConfig());
    }

    public static int calculateDuration(int dataLength, AudioConfig config) {
        return AudioSource.calculateDuration(dataLength, config.getClockRate(), config.getChannelCount());
    }

    public static int calculateDurationFloat(int dataLength, int clockRate, int channelCount) {
        return 1000 * dataLength / (clockRate * channelCount * 4);
    }

    @Override
    protected IAudioInputCollection createInputCollection(IAudioOutput output) {
        return new IAudioInputCollection(output);
    }

    @Override
    public AudioConfig getConfig() {
        AudioFormat outputFormat = (AudioFormat)super.getOutputFormat();
        if (outputFormat != null) {
            return outputFormat.getConfig();
        }
        return null;
    }

    @Override
    public boolean getDisableTimestampReset() {
        return this.__reframerContext.getDisableTimestampReset();
    }

    @Override
    public boolean getForceTimestampReset() {
        return this.__reframerContext.getForceTimestampReset();
    }

    @Override
    public double getFrameDuration() {
        return this.__reframerContext.getFrameDuration();
    }

    private static AudioBuffer getPcmBuffer(AudioFrame frame, AudioFormat format) {
        if (format != null && format.getIsPcm()) {
            return (AudioBuffer)frame.getBuffer(format);
        }
        return null;
    }

    @Override
    public int getTimestampResetInterval() {
        return this.__reframerContext.getTimestampResetInterval();
    }

    @Override
    public double getVolume() {
        return this.__volume;
    }

    @Override
    protected void raiseFrame(AudioFrame frame) {
        AudioBuffer buffer = (AudioBuffer)frame.getBuffer(AudioFormat.getPcmName());
        if (buffer == null) {
            this.raiseProcessedFrame(frame);
        } else {
            if (this.__reframerContext.getOnFrame() == null) {
                this.__reframerContext.setOnFrame((IAction1<AudioFrame>)new IActionDelegate1<AudioFrame>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.AudioSource.raiseProcessedFrame";
                    }

                    @Override
                    public void invoke(AudioFrame frame) {
                        AudioSource.this.raiseProcessedFrame(frame);
                    }
                });
            }
            this.__reframerContext.processFrame(frame, buffer);
        }
    }

    private void raiseProcessedFrame(AudioFrame frame) {
        AudioBuffer pcmBuffer = AudioSource.getPcmBuffer(frame, (AudioFormat)super.getOutputFormat());
        if (pcmBuffer != null) {
            if (this.getVolume() != 1.0) {
                pcmBuffer.applyGain(this.getVolume());
            }
            AudioSource.setDuration(frame, pcmBuffer, (AudioFormat)super.getOutputFormat());
        }
        super.raiseFrame(frame);
    }

    @Override
    public void setDisableTimestampReset(boolean value) {
        this.__reframerContext.setDisableTimestampReset(value);
    }

    private static void setDuration(AudioFrame frame, AudioBuffer pcmBuffer, AudioFormat format) {
        DataBuffer dataBuffer;
        if (frame.getDuration() == -1.0 && format != null && format.getIsPcm() && (dataBuffer = pcmBuffer.getDataBuffer()) != null) {
            frame.setDuration((double)dataBuffer.getLength() * 1000.0 / (double)(format.getClockRate() * format.getChannelCount() * 2));
        }
    }

    @Override
    public void setForceTimestampReset(boolean value) {
        this.__reframerContext.setForceTimestampReset(value);
    }

    @Override
    public void setFrameDuration(double value) {
        this.__reframerContext.setFrameDuration(value);
    }

    @Override
    public void setTimestampResetInterval(int value) {
        this.__reframerContext.setTimestampResetInterval(value);
    }

    @Override
    public void setVolume(double value) {
        this.__volume = MathAssistant.min(MathAssistant.max(value, 0.0), 1.0);
    }
}

