/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.Dynamic;
import fm.Global;
import fm.StringExtensions;
import fm.websync.Serializer;

public class Subscription
extends Dynamic {
    private String __channel;
    private String __tag;

    public Subscription duplicate() throws Exception {
        return new Subscription(this.getChannel(), this.getTag());
    }

    public boolean equals(Object obj) {
        Subscription subscription = (Subscription)((Object)Global.tryCast((Object)obj, Subscription.class));
        return Global.equals((Object)((Object)subscription), (Object)((Object)this));
    }

    public static Subscription fromJson(String subscriptionJson) throws Exception {
        return Serializer.deserializeSubscription(subscriptionJson);
    }

    public static Subscription[] fromJsonMultiple(String subscriptionsJson) throws Exception {
        return Serializer.deserializeSubscriptionArray(subscriptionsJson);
    }

    public String getChannel() {
        return this.__channel;
    }

    public String getTag() {
        return this.__tag != null ? this.__tag : StringExtensions.empty;
    }

    public int hashCode() {
        int num = 17;
        num = num * 23 + this.getChannel().hashCode();
        if (this.getTag() != null) {
            num = num * 23 + this.getTag().hashCode();
        }
        return num;
    }

    public void setChannel(String value) throws Exception {
        if (value == null) {
            throw new Exception("channel cannot be null.");
        }
        this.__channel = value;
        super.setIsDirty(true);
    }

    public void setTag(String value) {
        this.__tag = value != null ? value : StringExtensions.empty;
        super.setIsDirty(true);
    }

    public Subscription(String channel) throws Exception {
        this.setChannel(channel);
    }

    public Subscription(String channel, String tag) throws Exception {
        this.setChannel(channel);
        this.setTag(tag);
    }

    public String toJson() {
        return Subscription.toJson(this);
    }

    public static String toJson(Subscription subscription) {
        return Serializer.serializeSubscription(subscription);
    }

    public static String toJsonMultiple(Subscription[] subscriptions) {
        return Serializer.serializeSubscriptionArray(subscriptions);
    }
}

