/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.websync4;

import fm.SingleAction;
import fm.icelink.ArrayExtensions;
import fm.icelink.Candidate;
import fm.icelink.Connection;
import fm.icelink.ConnectionState;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IFunction1;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.Promise;
import fm.icelink.PromiseBase;
import fm.icelink.SessionDescription;
import fm.icelink.SignallingState;
import fm.icelink.StringExtensions;
import fm.icelink.Unhandled;
import fm.icelink.Utility;
import fm.icelink.websync4.ConnectionCollection;
import fm.icelink.websync4.JoinConferenceArgs;
import fm.icelink.websync4.JoinConferenceFailureArgs;
import fm.icelink.websync4.JoinConferenceReceiveArgs;
import fm.icelink.websync4.JoinConferenceSuccessArgs;
import fm.icelink.websync4.LeaveConferenceArgs;
import fm.icelink.websync4.LeaveConferenceFailureArgs;
import fm.icelink.websync4.LeaveConferenceSuccessArgs;
import fm.icelink.websync4.PeerClient;
import fm.icelink.websync4.PendingRenegotiationProperties;
import fm.icelink.websync4.State;
import fm.websync.BaseFailureArgs;
import fm.websync.BaseReceiveArgs;
import fm.websync.BaseSuccessArgs;
import fm.websync.Client;
import fm.websync.Extensible;
import fm.websync.PublishArgs;
import fm.websync.PublishFailureArgs;
import fm.websync.PublishSuccessArgs;
import fm.websync.PublishingClient;
import fm.websync.Record;
import fm.websync.StreamFailureArgs;
import fm.websync.SubscribeReceiveArgs;
import fm.websync.chat.ChatUser;
import fm.websync.chat.JoinArgs;
import fm.websync.chat.JoinFailureArgs;
import fm.websync.chat.JoinReceiveArgs;
import fm.websync.chat.JoinSuccessArgs;
import fm.websync.chat.LeaveArgs;
import fm.websync.chat.LeaveFailureArgs;
import fm.websync.chat.LeaveSuccessArgs;
import fm.websync.chat.UserJoinArgs;
import fm.websync.chat.UserLeaveArgs;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ClientExtensions {
    private static Object __lock;
    static String _retriable;

    private static void acceptAnswer(Connection connection, SessionDescription remoteDescription) {
        connection.setRemoteDescription(remoteDescription).then((IAction1)new IAction1<SessionDescription>(){

            public void invoke(SessionDescription answer) {
            }
        }, (IAction1)new IAction1<Exception>(){

            public void invoke(Exception ex) {
                Log.error((String)"Could not set remote answer.", (Exception)ex);
            }
        });
    }

    private static void acceptOfferCreateAnswerAndSend(Connection connection, Client client, SessionDescription remoteDescription, String userId, String channel, boolean competingOffer, HashMap<String, Record> boundRecords, State state) {
        if (competingOffer) {
            if (remoteDescription.getTieBreaker() != null && connection.getTieBreaker() != null) {
                if ((Global.equals((Object)connection.getState(), (Object)ConnectionState.New) || Global.equals((Object)connection.getState(), (Object)ConnectionState.Initializing) || Global.equals((Object)connection.getState(), (Object)ConnectionState.Connecting) || Global.equals((Object)connection.getState(), (Object)ConnectionState.Connected)) && connection.getTieBreaker().compareTo(remoteDescription.getTieBreaker()) > 0) {
                    Log.debug((String)"Received competing offer, but won the tie breaker.");
                } else {
                    if (!(Global.equals((Object)connection.getState(), (Object)ConnectionState.Failed) || Global.equals((Object)connection.getState(), (Object)ConnectionState.Failing) || Global.equals((Object)connection.getState(), (Object)ConnectionState.Closing) || Global.equals((Object)connection.getState(), (Object)ConnectionState.Closed))) {
                        Log.debug((String)"Competing offer detected. Switching to answering role...");
                        connection.unsetDynamicValue("fm.icelink.retriableConnection");
                        connection.close();
                    }
                    ClientExtensions.createNewConnectionAndSend(userId, boundRecords, state, remoteDescription, client, channel);
                }
            } else {
                boolean flag2;
                String str = "";
                boolean flag = remoteDescription.getTieBreaker() == null;
                boolean bl = flag2 = connection.getTieBreaker() == null;
                str = flag && flag2 ? "remote and local tiebreakers are " : (flag ? "remote tiebreaker is " : "local tiebreaker is ");
                Log.error((String)StringExtensions.format((String)"Received competing offer, but {0} null. Cannot resolve conflict. Will assume answering role.", (Object)str));
                connection.unsetDynamicValue("fm.icelink.retriableConnection");
                connection.close();
                ClientExtensions.createNewConnectionAndSend(userId, boundRecords, state, remoteDescription, client, channel);
            }
        } else {
            ClientExtensions.setRemoteDescription(connection, remoteDescription, client, channel, userId);
        }
    }

    private static Promise<SessionDescription> createAndSendOffer(final Connection connection, final Client client, final String channel, final String userId, final Promise<SessionDescription> promise) {
        connection.createOffer().then((IFunction1)new IFunction1<SessionDescription, Future<SessionDescription>>(){

            public Future<SessionDescription> invoke(SessionDescription offer) {
                return connection.setLocalDescription(offer);
            }
        }, (IAction1)new IAction1<Exception>(){

            public void invoke(Exception ex) {
                Log.error((String)StringExtensions.format((String)"Could not create local offer: {0}", (Object)ex.getMessage()), (Exception)ex);
            }
        }).then((IFunction1)new IFunction1<SessionDescription, Future<SessionDescription>>(){

            public Future<SessionDescription> invoke(SessionDescription localDescription) {
                return ClientExtensions.sendLocalDescription(client, channel, userId, localDescription, (Promise<SessionDescription>)new Promise());
            }
        }, (IAction1)new IAction1<Exception>(){

            public void invoke(Exception ex) {
                Log.error((String)StringExtensions.format((String)"Could not set local offer: {0}", (Object)ex.getMessage()), (Exception)ex);
            }
        }).then((IAction1)new IAction1<SessionDescription>(){

            public void invoke(SessionDescription localDescription) {
                promise.resolve(null);
            }
        }, (IAction1)new IAction1<Exception>(){

            public void invoke(Exception ex) {
                Log.error((String)StringExtensions.format((String)"Could not send local offer: {0}", (Object)ex.getMessage()), (Exception)ex);
                promise.reject(ex);
            }
        });
        return promise;
    }

    private static Promise<SessionDescription> createAndSendOffer(Connection connection, Client client, String channel, String userId) {
        Promise promise = new Promise();
        return ClientExtensions.createAndSendOffer(connection, client, channel, userId, (Promise<SessionDescription>)promise);
    }

    private static void createNewConnectionAndSend(String userId, HashMap<String, Record> boundRecords, State state, SessionDescription remoteDescription, Client client, String channel) {
        Connection andCacheConnection = ClientExtensions.getAndCacheConnection(PeerClient.createPeerClient(userId, boundRecords, state));
        if (andCacheConnection != null) {
            ClientExtensions.setRemoteDescription(andCacheConnection, remoteDescription, client, channel, userId);
        }
    }

    private static Client doJoinConference(final Client client, final JoinConferenceArgs args, final State state) {
        Client client2;
        IAction2<Connection, Candidate> action = null;
        SingleAction<JoinFailureArgs> action2 = null;
        SingleAction<JoinSuccessArgs> action3 = null;
        SingleAction<JoinReceiveArgs> action4 = null;
        SingleAction<UserJoinArgs> action5 = null;
        SingleAction<UserLeaveArgs> action6 = null;
        try {
            String clientId = client.getInstanceId().toString();
            String instanceChannel = ClientExtensions.getInstanceChannel(args.getConferenceChannel(), clientId);
            if (action == null) {
                action = new IAction2<Connection, Candidate>(){

                    public void invoke(Connection connection, Candidate localCandidate) {
                        Object dynamicValue = connection.getDynamicValue("fm.icelink.remoteUserId");
                        if (dynamicValue != null && !localCandidate.getDispatched()) {
                            ClientExtensions.sendLocalCandidate(client, args.getConferenceChannel(), (String)dynamicValue, localCandidate);
                        }
                    }
                };
            }
            state.getConnections().addOnLocalCandidate(action);
            client.setDynamicValue(args.getConferenceChannel(), (Object)state);
            JoinArgs args3 = new JoinArgs(new String[]{args.getConferenceChannel(), instanceChannel}, "fm.icelink.websync");
            args3.setUserId(clientId);
            args3.setUserNickname("fm.icelink.websync");
            args3.setRequestUrl(args.getRequestUrl());
            args3.setSynchronous(args.getSynchronous());
            args3.setDynamicProperties(args.getDynamicProperties());
            if (action2 == null) {
                action2 = new SingleAction<JoinFailureArgs>(){

                    public void invoke(JoinFailureArgs e) {
                        client.unsetDynamicValue(args.getConferenceChannel());
                        ClientExtensions.raiseJoinFailure(args, (BaseFailureArgs)e, args.getConferenceChannel());
                    }
                };
            }
            args3.setOnFailure(action2);
            if (action3 == null) {
                action3 = new SingleAction<JoinSuccessArgs>(){

                    public void invoke(JoinSuccessArgs e) {
                        ClientExtensions.raiseJoinSuccess(args, (BaseSuccessArgs)e, args.getConferenceChannel(), e.getUsers());
                    }
                };
            }
            args3.setOnSuccess(action3);
            if (action4 == null) {
                action4 = new SingleAction<JoinReceiveArgs>(){

                    public void invoke(JoinReceiveArgs e) {
                        try {
                            ChatUser publishingUser = e.getPublishingUser();
                            if (publishingUser == null) {
                                throw new RuntimeException(new Exception("Publishing user is null."));
                            }
                            PublishingClient publishingClient = e.getPublishingClient();
                            if (publishingClient == null) {
                                throw new RuntimeException(new Exception("Publishing client is null."));
                            }
                            String remoteUserId = publishingUser.getUserId();
                            HashMap remoteBoundRecords = publishingClient.getBoundRecords();
                            if (Global.equals((Object)e.getChannel(), (Object)args.getConferenceChannel())) {
                                ClientExtensions.raiseJoinReceive(args, (BaseReceiveArgs)e, e.getChannel(), remoteUserId, remoteBoundRecords);
                            } else if (Global.equals((Object)publishingUser.getUserNickname(), (Object)"fm.icelink.websync")) {
                                if (Global.equals((Object)e.getTag(), (Object)"fm.icelink.websync.offeranswer")) {
                                    ClientExtensions.receiveRemoteDescription((SubscribeReceiveArgs)e, state, remoteUserId, remoteBoundRecords, client, args.getConferenceChannel());
                                } else if (Global.equals((Object)e.getTag(), (Object)"fm.icelink.websync.candidate")) {
                                    ClientExtensions.receiveRemoteCandidate((SubscribeReceiveArgs)e, state, remoteUserId, remoteBoundRecords);
                                } else {
                                    ClientExtensions.raiseJoinReceive(args, (BaseReceiveArgs)e, e.getChannel(), remoteUserId, remoteBoundRecords);
                                }
                            } else {
                                ClientExtensions.raiseJoinReceive(args, (BaseReceiveArgs)e, e.getChannel(), remoteUserId, remoteBoundRecords);
                            }
                        }
                        catch (Exception exception) {
                            Log.error((String)"Unexpected exception in receive handler.", (Exception)exception);
                        }
                    }
                };
            }
            args3.setOnReceive(action4);
            if (action5 == null) {
                action5 = new SingleAction<UserJoinArgs>(){

                    public void invoke(UserJoinArgs e) {
                        try {
                            String userId = e.getJoinedUser().getUserId();
                            HashMap boundRecords = e.getJoinedUser().getBoundRecords();
                            if (Global.equals((Object)e.getJoinedUser().getUserNickname(), (Object)"fm.icelink.websync")) {
                                Connection andCacheConnection = state.getConnections().getByRemoteUserId(userId);
                                if (andCacheConnection != null) {
                                    if (state.getUnlinkExistingOnUserJoin()) {
                                        andCacheConnection.unsetDynamicValue("fm.icelink.retriableConnection");
                                        andCacheConnection.close();
                                    } else {
                                        return;
                                    }
                                }
                                if ((andCacheConnection = ClientExtensions.getAndCacheConnection(PeerClient.createPeerClient(userId, boundRecords, state))) != null) {
                                    ClientExtensions.createAndSendOffer(andCacheConnection, client, args.getConferenceChannel(), userId);
                                }
                            }
                        }
                        catch (Exception exception) {
                            Log.error((String)"Unexpected exception in user-join handler.", (Exception)exception);
                        }
                    }
                };
            }
            args3.setOnUserJoin(action5);
            if (action6 == null) {
                action6 = new SingleAction<UserLeaveArgs>(){

                    public void invoke(UserLeaveArgs e) {
                        try {
                            Connection byRemoteUserId;
                            String userId = e.getLeftUser().getUserId();
                            if (Global.equals((Object)e.getLeftUser().getUserNickname(), (Object)"fm.icelink.websync") && state.getUnlinkOnUserLeave() && (byRemoteUserId = state.getConnections().getByRemoteUserId(userId)) != null) {
                                byRemoteUserId.unsetDynamicValue("fm.icelink.retriableConnection");
                                byRemoteUserId.close();
                            }
                        }
                        catch (Exception exception) {
                            Log.error((String)"Unexpected exception in user-leave handler.", (Exception)exception);
                        }
                    }
                };
            }
            args3.setOnUserLeave(action6);
            JoinArgs joinArgs = args3;
            joinArgs.copyExtensions((Extensible)args);
            fm.websync.chat.ClientExtensions.join((Client)client, (JoinArgs)joinArgs);
            client2 = client;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return client2;
    }

    private static Client doLeaveConference(final Client client, final LeaveConferenceArgs args, final State state) {
        Client client2;
        SingleAction<LeaveFailureArgs> action = null;
        SingleAction<LeaveSuccessArgs> action2 = null;
        try {
            if (state == null) {
                LeaveSuccessArgs args3 = new LeaveSuccessArgs();
                args3.setClient(client);
                args3.setDynamicProperties(args.getDynamicProperties());
                LeaveSuccessArgs e = args3;
                e.copyExtensions((Extensible)args);
                ClientExtensions.raiseLeaveSuccess(args, (BaseSuccessArgs)e, args.getConferenceChannel());
                return client;
            }
            state.setUnlinkAllOnLeaveSuccess(args.getUnlinkAllOnSuccess());
            String clientId = client.getClientId().toString();
            String instanceChannel = ClientExtensions.getInstanceChannel(args.getConferenceChannel(), clientId);
            LeaveArgs args5 = new LeaveArgs(new String[]{args.getConferenceChannel(), instanceChannel}, "fm.icelink.websync");
            args5.setRequestUrl(args.getRequestUrl());
            args5.setSynchronous(args.getSynchronous());
            args5.setDynamicProperties(args.getDynamicProperties());
            if (action == null) {
                action = new SingleAction<LeaveFailureArgs>(){

                    public void invoke(LeaveFailureArgs e) {
                        ClientExtensions.raiseLeaveFailure(args, (BaseFailureArgs)e, args.getConferenceChannel());
                    }
                };
            }
            args5.setOnFailure(action);
            if (action2 == null) {
                action2 = new SingleAction<LeaveSuccessArgs>(){

                    public void invoke(LeaveSuccessArgs e) {
                        client.unsetDynamicValue(args.getConferenceChannel());
                        if (state.getUnlinkAllOnLeaveSuccess()) {
                            for (Connection connection : (Connection[])state.getConnections().getValues()) {
                                connection.unsetDynamicValue("fm.icelink.retriableConnection");
                                connection.close();
                            }
                        }
                        ClientExtensions.raiseLeaveSuccess(args, (BaseSuccessArgs)e, args.getConferenceChannel());
                    }
                };
            }
            args5.setOnSuccess(action2);
            LeaveArgs leaveArgs = args5;
            leaveArgs.copyExtensions((Extensible)args);
            fm.websync.chat.ClientExtensions.leave((Client)client, (LeaveArgs)leaveArgs);
            client2 = client;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return client2;
    }

    private static void doRenegotiateConference(Client client, State state, Promise<Object> promise, Connection[] connections) {
        if (state != null) {
            if (state.getConnections() == null) {
                promise.reject(new Exception("No connections exist. Cannot renegotiate"));
            } else {
                String conferenceChannel = state.getConnections().getJoinArgs().getConferenceChannel();
                ArrayList<Future<SessionDescription>> individualPromises = new ArrayList<Future<SessionDescription>>();
                if (ArrayExtensions.getLength((Object[])connections) > 0) {
                    ClientExtensions.renegotiateConnection(0, client, conferenceChannel, promise, connections, individualPromises);
                } else {
                    promise.reject(new Exception("No connections exist. Cannot renegotiate"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getAndCacheConnection(final PeerClient remoteClient) {
        IAction1<Connection> action = null;
        State state = remoteClient.getState();
        JoinConferenceArgs joinArgs = state.getConnections().getJoinArgs();
        Connection connection = null;
        Object object = __lock;
        synchronized (object) {
            String tieBreaker = Utility.generateTieBreaker();
            if (!state.getConnections().checkForExistingConnection(remoteClient.getInstanceId(), tieBreaker)) {
                return connection;
            }
            connection = ClientExtensions.raiseJoinRemoteClient(joinArgs, remoteClient, remoteClient.getInstanceId());
            if (connection == null) {
                return connection;
            }
            connection.setTieBreaker(tieBreaker);
            connection.addOnSignallingStateChange((IAction1)new IAction1<Connection>(){

                public void invoke(Connection c) {
                    if (Global.equals((Object)c.getSignallingState(), (Object)SignallingState.Stable)) {
                        ClientExtensions.processReadyForRenegotiation(c);
                    }
                }
            });
            if (action == null) {
                action = new IAction1<Connection>(){

                    public void invoke(Connection c) {
                        if (Global.equals((Object)c.getState(), (Object)ConnectionState.Connected)) {
                            ClientExtensions.processReadyForRenegotiation(c);
                        } else if (Global.equals((Object)c.getState(), (Object)ConnectionState.Closed) || Global.equals((Object)c.getState(), (Object)ConnectionState.Failed)) {
                            remoteClient.getState().getConnections().remove(c);
                            c.unsetDynamicValue("fm.icelink.retriableConnection");
                        }
                    }
                };
            }
            connection.addOnStateChange(action);
            if (!state.getConnections().add(connection)) {
                connection.close();
                connection = null;
            }
        }
        return connection;
    }

    private static String getInstanceChannel(String conferenceChannel, String clientId) {
        return StringExtensions.concat((String)"/fm.icelink.websync.instance", (String)conferenceChannel, (String)"/", (String)clientId);
    }

    public static Client joinConference(final Client client, final JoinConferenceArgs args) {
        if (StringExtensions.isNullOrEmpty((String)args.getConferenceChannel())) {
            throw new RuntimeException(new Exception("Conference channel cannot be null."));
        }
        State state2 = new State();
        state2.setConnections(new ConnectionCollection(args));
        state2.setUnlinkExistingOnUserJoin(args.getUnlinkExistingOnUserJoin());
        state2.setUnlinkOnUserLeave(args.getUnlinkOnUserLeave());
        State state = state2;
        client.addOnStreamFailure((SingleAction)new SingleAction<StreamFailureArgs>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(StreamFailureArgs e) {
                Object object = __lock;
                synchronized (object) {
                    State dynamicValue = (State)Global.tryCast((Object)client.getDynamicValue(args.getConferenceChannel()), State.class);
                    if (dynamicValue != null) {
                        for (Connection connection : (Connection[])dynamicValue.getConnections().getValues()) {
                            connection.unsetDynamicValue("fm.icelink.retriableConnection");
                            connection.close();
                        }
                    }
                }
            }
        });
        return ClientExtensions.doJoinConference(client, args, state);
    }

    public static Client leaveConference(Client client, LeaveConferenceArgs args) {
        if (StringExtensions.isNullOrEmpty((String)args.getConferenceChannel())) {
            throw new RuntimeException(new Exception("Conference channel cannot be null."));
        }
        State state = client == null ? null : (State)Global.tryCast((Object)client.getDynamicValue(args.getConferenceChannel()), State.class);
        return ClientExtensions.doLeaveConference(client, args, state);
    }

    private static void preparePendingRenegotiationPromise(Connection connection, Client client, String channel, ArrayList<Future<SessionDescription>> individualPromises, int processed) {
        Promise pendingPromise = new Promise();
        connection.setDynamicValue("fm.icelink.pendingRenegotiationPromise", (Object)new PendingRenegotiationProperties((Promise<SessionDescription>)pendingPromise, client, channel));
        individualPromises.add((Future<SessionDescription>)pendingPromise);
    }

    private static void processReadyForRenegotiation(Connection connection) {
        Object dynamicValue = connection.getDynamicValue("fm.icelink.pendingRenegotiationPromise");
        if (dynamicValue != null) {
            PendingRenegotiationProperties properties = (PendingRenegotiationProperties)dynamicValue;
            connection.setDynamicValue("fm.icelink.pendingRenegotiationPromise", null);
            String userId = (String)connection.getDynamicValue("fm.icelink.remoteUserId");
            if (userId != null) {
                ClientExtensions.createAndSendOffer(connection, properties.getClient(), properties.getChannel(), userId, properties.getPendingPromise());
            } else {
                properties.getPendingPromise().reject(new Exception("Remote User ID is not set for connection on renegotiation. Cannot signal."));
            }
        }
    }

    private static void raiseJoinFailure(JoinConferenceArgs args, BaseFailureArgs e, String conferenceChannel) {
        try {
            if (args.getOnFailure() != null) {
                JoinConferenceFailureArgs args3 = new JoinConferenceFailureArgs();
                args3.__conferenceChannel = conferenceChannel;
                args3.setClient(e.getClient());
                args3.setException(e.getException());
                args3.setTimestamp(e.getTimestamp());
                args3.setDynamicProperties(e.getDynamicProperties());
                JoinConferenceFailureArgs p = args3;
                p.copyExtensions((Extensible)e);
                try {
                    args.getOnFailure().invoke((Object)p);
                }
                catch (Exception exception1) {
                    Exception exception = exception1;
                    Unhandled.logException((Exception)exception, (String)"Client -> JoinConference -> OnFailure");
                }
            }
        }
        catch (Exception exception2) {
            Exception exception = exception2;
            throw new RuntimeException(exception);
        }
    }

    private static void raiseJoinReceive(JoinConferenceArgs args, BaseReceiveArgs e, String channel, String remoteUserId, HashMap<String, Record> remoteBoundRecords) {
        try {
            if (args.getOnReceive() != null) {
                JoinConferenceReceiveArgs args3 = new JoinConferenceReceiveArgs(channel, e.getDataJson(), e.getDataBytes(), e.getConnectionType(), e.getReconnectAfter());
                args3.__publishingPeer = new PeerClient(remoteUserId, remoteBoundRecords);
                args3.setClient(e.getClient());
                args3.setTimestamp(e.getTimestamp());
                args3.setDynamicProperties(e.getDynamicProperties());
                JoinConferenceReceiveArgs p = args3;
                p.copyExtensions((Extensible)e);
                args.getOnReceive().invoke((Object)p);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Connection raiseJoinRemoteClient(JoinConferenceArgs args, PeerClient remoteClient, String userId) {
        if (args.getOnRemoteClient() != null) {
            Connection connection = null;
            try {
                connection = (Connection)args.getOnRemoteClient().invoke((Object)remoteClient);
            }
            catch (Exception exception) {
                Unhandled.logException((Exception)exception, (String)"Client -> JoinConference -> OnRemoteClient");
            }
            if (connection != null) {
                connection.setDynamicValue("fm.icelink.remoteUserId", (Object)userId);
                connection.setDynamicValue("fm.icelink.retriableConnection", new Object());
            }
            return connection;
        }
        return null;
    }

    private static void raiseJoinSuccess(JoinConferenceArgs args, BaseSuccessArgs e, String conferenceChannel, ChatUser[] users) {
        try {
            if (args.getOnSuccess() != null) {
                JoinConferenceSuccessArgs args3 = new JoinConferenceSuccessArgs();
                args3.__conferenceChannel = conferenceChannel;
                args3.__users = users;
                args3.setClient(e.getClient());
                args3.setTimestamp(e.getTimestamp());
                args3.setDynamicProperties(e.getDynamicProperties());
                JoinConferenceSuccessArgs p = args3;
                p.copyExtensions((Extensible)e);
                try {
                    args.getOnSuccess().invoke((Object)p);
                }
                catch (Exception exception1) {
                    Exception exception = exception1;
                    Unhandled.logException((Exception)exception, (String)"Client -> JoinConference -> OnSuccess");
                }
            }
        }
        catch (Exception exception2) {
            Exception exception = exception2;
            throw new RuntimeException(exception);
        }
    }

    private static void raiseLeaveFailure(LeaveConferenceArgs args, BaseFailureArgs e, String conferenceChannel) {
        try {
            if (args.getOnFailure() != null) {
                LeaveConferenceFailureArgs args3 = new LeaveConferenceFailureArgs();
                args3.__conferenceChannel = conferenceChannel;
                args3.setClient(e.getClient());
                args3.setException(e.getException());
                args3.setTimestamp(e.getTimestamp());
                args3.setDynamicProperties(e.getDynamicProperties());
                LeaveConferenceFailureArgs p = args3;
                p.copyExtensions((Extensible)e);
                try {
                    args.getOnFailure().invoke((Object)p);
                }
                catch (Exception exception1) {
                    Exception exception = exception1;
                    Unhandled.logException((Exception)exception, (String)"Client -> LeaveConference -> OnFailure");
                }
            }
        }
        catch (Exception exception2) {
            Exception exception = exception2;
            throw new RuntimeException(exception);
        }
    }

    private static void raiseLeaveSuccess(LeaveConferenceArgs args, BaseSuccessArgs e, String conferenceChannel) {
        try {
            if (args.getOnSuccess() != null) {
                LeaveConferenceSuccessArgs args3 = new LeaveConferenceSuccessArgs();
                args3.__conferenceChannel = conferenceChannel;
                args3.setClient(e.getClient());
                args3.setTimestamp(e.getTimestamp());
                args3.setDynamicProperties(e.getDynamicProperties());
                LeaveConferenceSuccessArgs p = args3;
                p.copyExtensions((Extensible)e);
                try {
                    args.getOnSuccess().invoke((Object)p);
                }
                catch (Exception exception1) {
                    Exception exception = exception1;
                    Unhandled.logException((Exception)exception, (String)"Client -> LeaveConference -> OnSuccess");
                }
            }
        }
        catch (Exception exception2) {
            Exception exception = exception2;
            throw new RuntimeException(exception);
        }
    }

    private static boolean receiveRemoteCandidate(SubscribeReceiveArgs e, State state, String userId, HashMap<String, Record> boundRecords) {
        ConnectionCollection connections = state.getConnections();
        Candidate remoteCandidate = Candidate.fromJson((String)e.getDataJson());
        if (remoteCandidate == null) {
            Log.error((String)StringExtensions.format((String)"{0}: Could not parse remote candidate: {1}", (Object)userId, (Object)e.getDataJson()));
            return false;
        }
        Connection byRemoteUserId = connections.getByRemoteUserId(userId);
        if (byRemoteUserId == null) {
            byRemoteUserId = ClientExtensions.getAndCacheConnection(PeerClient.createPeerClient(userId, boundRecords, state));
        }
        if (byRemoteUserId != null) {
            byRemoteUserId.addRemoteCandidate(remoteCandidate).fail((IAction1)new IAction1<Exception>(){

                public void invoke(Exception ex) {
                    Log.error((String)"Could not add remote candidate.", (Exception)ex);
                }
            });
            return true;
        }
        return false;
    }

    private static boolean receiveRemoteDescription(SubscribeReceiveArgs e, State state, String userId, HashMap<String, Record> boundRecords, Client client, String conferenceChannel) {
        SessionDescription remoteDescription = SessionDescription.fromJson((String)e.getDataJson());
        if (remoteDescription == null) {
            Log.error((String)StringExtensions.format((String)"{0}: Could not parse remote description: {1}", (Object)userId, (Object)e.getDataJson()));
            return false;
        }
        Connection byRemoteUserId = state.getConnections().getByRemoteUserId(userId);
        if (remoteDescription.getIsOffer()) {
            boolean flag;
            long sessionId = remoteDescription.getSessionId();
            long sessionVersion = remoteDescription.getSessionVersion();
            boolean bl = flag = byRemoteUserId != null;
            if (flag) {
                long num4;
                long num3 = byRemoteUserId.getRemoteDescription() != null ? byRemoteUserId.getRemoteDescription().getSessionId() : -1L;
                long l = num4 = byRemoteUserId.getRemoteDescription() != null ? byRemoteUserId.getRemoteDescription().getSessionVersion() : -1L;
                if (num3 != -1L && num3 != sessionId) {
                    Log.debug((String)StringExtensions.format((String)"Received remote session description with id {0} and version {1}. Current remote description has id {2} and version {3}. This is re-connection request. Shutting down existing connection.", (Object[])new Object[]{LongExtensions.toString((Long)sessionId), LongExtensions.toString((Long)sessionVersion), LongExtensions.toString((Long)num3), LongExtensions.toString((Long)num4)}));
                    byRemoteUserId.unsetDynamicValue("fm.icelink.retriableConnection");
                    byRemoteUserId.close();
                    byRemoteUserId = null;
                    flag = false;
                } else if (num4 != -1L && num4 >= sessionVersion) {
                    Log.debug((String)StringExtensions.format((String)"Received remote SDP description with id {0} and version {1}. Current remote description has id {2} and version {3}. Discarding stale request.", (Object[])new Object[]{LongExtensions.toString((Long)sessionId), LongExtensions.toString((Long)sessionVersion), LongExtensions.toString((Long)num3), LongExtensions.toString((Long)num4)}));
                    return false;
                }
            }
            if (!flag) {
                byRemoteUserId = ClientExtensions.getAndCacheConnection(PeerClient.createPeerClient(userId, boundRecords, state));
            }
            if (byRemoteUserId != null) {
                boolean competingOffer = Global.equals((Object)byRemoteUserId.getSignallingState(), (Object)SignallingState.HaveLocalOffer);
                ClientExtensions.acceptOfferCreateAnswerAndSend(byRemoteUserId, client, remoteDescription, userId, conferenceChannel, competingOffer, boundRecords, state);
                return true;
            }
            return false;
        }
        if (byRemoteUserId == null) {
            Log.error((String)StringExtensions.format((String)"Answer from user {0} received, but connection does not exist: {1}", (Object)userId, (Object)e.getDataJson()));
            return false;
        }
        ClientExtensions.acceptAnswer(byRemoteUserId, remoteDescription);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconnectRemoteClient(Client client, PeerClient remoteClient, Connection failedConnection) {
        Object object = __lock;
        synchronized (object) {
            if (failedConnection != null && failedConnection.getDynamicValue("fm.icelink.retriableConnection") != null) {
                Connection andCacheConnection = ClientExtensions.getAndCacheConnection(remoteClient);
                if (andCacheConnection != null) {
                    if (remoteClient.getState() != null) {
                        String conferenceChannel = remoteClient.getState().getConnections().getJoinArgs().getConferenceChannel();
                        ClientExtensions.createAndSendOffer(andCacheConnection, client, conferenceChannel, remoteClient.getInstanceId());
                    } else {
                        Log.error((String)"Cannot reconnect remote client. Null state.");
                    }
                } else {
                    Log.debug((String)StringExtensions.format((String)"Will not reconnect connection {0} because associated websync client encountered stream failure.", (Object)andCacheConnection.getId()));
                }
            }
        }
    }

    public static Future<Object> renegotiate(Client client, String conferenceChannel, Connection connection) {
        Promise promise = new Promise();
        if (StringExtensions.isNullOrEmpty((String)conferenceChannel)) {
            throw new RuntimeException(new Exception("Conference channel cannot be null."));
        }
        State dynamicValue = (State)Global.tryCast((Object)client.getDynamicValue(conferenceChannel), State.class);
        Connection[] connections = new Connection[]{connection};
        ClientExtensions.doRenegotiateConference(client, dynamicValue, (Promise<Object>)promise, connections);
        return promise;
    }

    private static void renegotiateConnection(int processed, Client client, String channel, Promise<Object> promise, Connection[] connections, ArrayList<Future<SessionDescription>> individualPromises) {
        try {
            Connection connection = connections[processed];
            if (Global.equals((Object)connection.getState(), (Object)ConnectionState.Connected)) {
                if (Global.equals((Object)connection.getSignallingState(), (Object)SignallingState.Stable)) {
                    connection.setDynamicValue("fm.icelink.pendingRenegotiationPromise", null);
                    String dynamicValue = (String)connection.getDynamicValue("fm.icelink.remoteUserId");
                    if (dynamicValue != null) {
                        individualPromises.add((Future<SessionDescription>)ClientExtensions.createAndSendOffer(connection, client, channel, dynamicValue));
                    } else {
                        Promise item = new Promise();
                        item.reject(new Exception("Remote User ID is not set for connection on renegotiation. Cannot signal."));
                        individualPromises.add((Future<SessionDescription>)item);
                    }
                } else {
                    ClientExtensions.preparePendingRenegotiationPromise(connection, client, channel, individualPromises, processed);
                    if (Global.equals((Object)connection.getSignallingState(), (Object)SignallingState.Stable)) {
                        connection.setDynamicValue("fm.icelink.pendingRenegotiationPromise", null);
                        --processed;
                    }
                }
            } else if (Global.equals((Object)connection.getState(), (Object)ConnectionState.Connecting)) {
                ClientExtensions.preparePendingRenegotiationPromise(connection, client, channel, individualPromises, processed);
                if (Global.equals((Object)connection.getState(), (Object)ConnectionState.Connected)) {
                    connection.setDynamicValue("fm.icelink.pendingRenegotiationPromise", null);
                    --processed;
                }
            }
            ClientExtensions.resolveNextConnection(processed, client, channel, promise, connections, individualPromises);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
    }

    private static void resolveNextConnection(int processed, Client client, String channel, final Promise<Object> promise, Connection[] connections, ArrayList<Future<SessionDescription>> individualPromises) {
        IAction1<Exception> rejectAction = null;
        IAction1<SessionDescription> resolveAction = null;
        if (++processed >= ArrayExtensions.getLength((Object[])connections)) {
            if (resolveAction == null) {
                resolveAction = new IAction1<SessionDescription>(){

                    public void invoke(SessionDescription descriptions) {
                        promise.resolve(null);
                    }
                };
            }
            if (rejectAction == null) {
                rejectAction = new IAction1<Exception>(){

                    public void invoke(Exception ex) {
                        promise.reject(ex);
                    }
                };
            }
            PromiseBase.all((Future[])individualPromises.toArray(new Future[0])).then((IAction1)resolveAction).fail((IAction1)rejectAction);
        } else {
            ClientExtensions.renegotiateConnection(processed, client, channel, promise, connections, individualPromises);
        }
    }

    private static void sendLocalCandidate(Client client, final String conferenceChannel, String userId, Candidate localCandidate) {
        SingleAction<PublishFailureArgs> action = null;
        try {
            PublishArgs publishArgs = new PublishArgs(ClientExtensions.getInstanceChannel(conferenceChannel, userId), localCandidate.toJson(), "fm.icelink.websync.candidate");
            if (action == null) {
                action = new SingleAction<PublishFailureArgs>(){

                    public void invoke(PublishFailureArgs e) {
                        Log.error((String)StringExtensions.format((String)"{0}: Could not publish local candidate.", (Object)conferenceChannel), (Exception)e.getException());
                    }
                };
            }
            publishArgs.setOnFailure(action);
            client.publish(publishArgs);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Future<SessionDescription> sendLocalDescription(Client client, final String conferenceChannel, String userId, final SessionDescription localDescription, final Promise<SessionDescription> promise) {
        SingleAction<PublishFailureArgs> action = null;
        SingleAction<PublishSuccessArgs> action2 = null;
        try {
            PublishArgs publishArgs = new PublishArgs(ClientExtensions.getInstanceChannel(conferenceChannel, userId), localDescription.toJson(), "fm.icelink.websync.offeranswer");
            if (action == null) {
                action = new SingleAction<PublishFailureArgs>(){

                    public void invoke(PublishFailureArgs e) {
                        Log.error((String)StringExtensions.format((String)"{0}: Could not publish local description.", (Object)conferenceChannel), (Exception)e.getException());
                        promise.reject(e.getException());
                    }
                };
            }
            publishArgs.setOnFailure(action);
            if (action2 == null) {
                action2 = new SingleAction<PublishSuccessArgs>(){

                    public void invoke(PublishSuccessArgs e) {
                        promise.resolve((Object)localDescription);
                    }
                };
            }
            publishArgs.setOnSuccess(action2);
            client.publish(publishArgs);
        }
        catch (Exception exception) {
            Log.error((String)StringExtensions.format((String)"{0}: Could not publish local description.", (Object)conferenceChannel), (Exception)exception);
            promise.reject(exception);
        }
        return promise;
    }

    private static void setRemoteDescription(final Connection connection, SessionDescription remoteDescription, final Client client, final String channel, final String userId) {
        connection.setRemoteDescription(remoteDescription).then((IFunction1)new IFunction1<SessionDescription, Future<SessionDescription>>(){

            public Future<SessionDescription> invoke(SessionDescription offer) {
                return connection.createAnswer();
            }
        }, (IAction1)new IAction1<Exception>(){

            public void invoke(Exception ex) {
                Log.error((String)"Could not set remote offer.");
            }
        }).then((IFunction1)new IFunction1<SessionDescription, Future<SessionDescription>>(){

            public Future<SessionDescription> invoke(SessionDescription answer) {
                return connection.setLocalDescription(answer);
            }
        }, (IAction1)new IAction1<Exception>(){

            public void invoke(Exception ex) {
                Log.error((String)"Could not create local answer.", (Exception)ex);
            }
        }).then((IFunction1)new IFunction1<SessionDescription, Future<SessionDescription>>(){

            public Future<SessionDescription> invoke(SessionDescription localDescription) {
                return ClientExtensions.sendLocalDescription(client, channel, userId, localDescription, (Promise<SessionDescription>)new Promise());
            }
        }, (IAction1)new IAction1<Exception>(){

            public void invoke(Exception ex) {
                Log.error((String)"Could not set local answer.", (Exception)ex);
            }
        });
    }

    static {
        _retriable = "fm.icelink.retriableConnection";
        __lock = new Object();
    }
}

