/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class PKCS10CertificationRequestBuilder {
    private SubjectPublicKeyInfo publicKeyInfo;
    private X500Name subject;
    private List attributes = new ArrayList();
    private boolean leaveOffEmpty = false;

    public PKCS10CertificationRequestBuilder(X500Name subject, SubjectPublicKeyInfo publicKeyInfo) {
        this.subject = subject;
        this.publicKeyInfo = publicKeyInfo;
    }

    public PKCS10CertificationRequestBuilder addAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        this.attributes.add(new Attribute(attrType, new DERSet(attrValue)));
        return this;
    }

    public PKCS10CertificationRequestBuilder addAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable[] attrValues) {
        this.attributes.add(new Attribute(attrType, new DERSet(attrValues)));
        return this;
    }

    public PKCS10CertificationRequestBuilder setLeaveOffEmptyAttributes(boolean leaveOffEmpty) {
        this.leaveOffEmpty = leaveOffEmpty;
        return this;
    }

    public PKCS10CertificationRequest build(ContentSigner signer) {
        CertificationRequestInfo info;
        if (this.attributes.isEmpty()) {
            info = this.leaveOffEmpty ? new CertificationRequestInfo(this.subject, this.publicKeyInfo, null) : new CertificationRequestInfo(this.subject, this.publicKeyInfo, (ASN1Set)new DERSet());
        } else {
            ASN1EncodableVector v = new ASN1EncodableVector();
            Iterator it = this.attributes.iterator();
            while (it.hasNext()) {
                v.add(Attribute.getInstance(it.next()));
            }
            info = new CertificationRequestInfo(this.subject, this.publicKeyInfo, (ASN1Set)new DERSet(v));
        }
        try {
            OutputStream sOut = signer.getOutputStream();
            sOut.write(info.getEncoded("DER"));
            sOut.close();
            return new PKCS10CertificationRequest(new CertificationRequest(info, signer.getAlgorithmIdentifier(), new DERBitString(signer.getSignature())));
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot produce certification request signature");
        }
    }
}

