/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import org.bouncycastle.openpgp.PGPException;

public class PGPPad {
    private PGPPad() {
    }

    public static byte[] padSessionData(byte[] sessionInfo) {
        byte[] result = new byte[40];
        System.arraycopy(sessionInfo, 0, result, 0, sessionInfo.length);
        byte padValue = (byte)(result.length - sessionInfo.length);
        int i = sessionInfo.length;
        while (i != result.length) {
            result[i] = padValue;
            ++i;
        }
        return result;
    }

    public static byte[] unpadSessionData(byte[] encoded) throws PGPException {
        byte padValue = encoded[encoded.length - 1];
        int i = encoded.length - padValue;
        while (i != encoded.length) {
            if (encoded[i] != padValue) {
                throw new PGPException("bad padding found in session data");
            }
            ++i;
        }
        byte[] taggedKey = new byte[encoded.length - padValue];
        System.arraycopy(encoded, 0, taggedKey, 0, taggedKey.length);
        return taggedKey;
    }
}

