/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun.turn;

import fm.icelink.DataBuffer;
import fm.icelink.StringExtensions;
import fm.icelink.stun.Attribute;

public class EvenPortAttribute
extends Attribute {
    private boolean _reserveNextHigher;

    private EvenPortAttribute() {
    }

    public EvenPortAttribute(boolean reserveNextHigher) {
        this.setReserveNextHigher(reserveNextHigher);
    }

    public boolean getReserveNextHigher() {
        return this._reserveNextHigher;
    }

    @Override
    public int getTypeValue() {
        return Attribute.getEvenPortType();
    }

    @Override
    protected int getValueLength() {
        return 1;
    }

    public static EvenPortAttribute readValueFrom(DataBuffer buffer, int offset) {
        EvenPortAttribute attribute = new EvenPortAttribute();
        attribute.setReserveNextHigher((buffer.read8(offset) & 0x80) == 128);
        return attribute;
    }

    public void setReserveNextHigher(boolean value) {
        this._reserveNextHigher = value;
    }

    public String toString() {
        return StringExtensions.format("EVEN-PORT ({0}reserve next higher)", this.getReserveNextHigher() ? "" : "don't ");
    }

    @Override
    protected void writeValueTo(DataBuffer buffer, int offset) {
        buffer.write8(this.getReserveNextHigher() ? 128 : 0, offset);
    }
}

