/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.rtp;

import fm.icelink.LongExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;

public class SsrcAttribute
extends Attribute {
    private String _name;
    private long _synchronizationSource;
    private String _value;

    public static SsrcAttribute fromAttributeValue(String value) {
        int index = StringExtensions.indexOf(value, " ");
        long num2 = ParseAssistant.parseLongValue(StringExtensions.substring(value, 0, index));
        value = value.substring(index + 1);
        int length = StringExtensions.indexOf(value, ":");
        String str = null;
        String str2 = null;
        if (length == -1) {
            str = value;
        } else {
            str = StringExtensions.substring(value, 0, length);
            str2 = value = value.substring(length + 1);
        }
        SsrcAttribute attribute = new SsrcAttribute();
        attribute.setSynchronizationSource(num2);
        attribute.setName(str);
        attribute.setValue(str2);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, LongExtensions.toString(this.getSynchronizationSource()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getName());
        if (!StringExtensions.isNullOrEmpty(this.getValue())) {
            StringBuilderExtensions.append(builder, ":");
            StringBuilderExtensions.append(builder, this.getValue());
        }
        return builder.toString();
    }

    public String getName() {
        return this._name;
    }

    public long getSynchronizationSource() {
        return this._synchronizationSource;
    }

    public String getValue() {
        return this._value;
    }

    private void setName(String value) {
        this._name = value;
    }

    private void setSynchronizationSource(long value) {
        this._synchronizationSource = value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public SsrcAttribute(long synchronizationSource, String attributeName) {
        this(synchronizationSource, attributeName, null);
    }

    private SsrcAttribute() {
        super.setAttributeType(AttributeType.RtpSsrcAttribute);
    }

    public SsrcAttribute(long synchronizationSource, String attributeName, String attributeValue) {
        super.setAttributeType(AttributeType.RtpSsrcAttribute);
        if (StringExtensions.isNullOrEmpty(attributeName)) {
            throw new RuntimeException(new Exception("attributeName cannot be null."));
        }
        this.setSynchronizationSource(synchronizationSource);
        this.setName(attributeName);
        this.setValue(attributeValue);
    }
}

