/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp;

import fm.icelink.ArrayExtensions;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.RepeatTime;
import fm.icelink.sdp.Timing;
import fm.icelink.sdp.Utility;
import java.util.ArrayList;

public class TimeDescription {
    private ArrayList<RepeatTime> __repeatTimes = new ArrayList();
    private Timing _timing;

    public void addRepeatTime(RepeatTime repeatTime) {
        this.__repeatTimes.add(repeatTime);
    }

    public RepeatTime[] getRepeatTimes() {
        return this.__repeatTimes.toArray(new RepeatTime[0]);
    }

    public Timing getTiming() {
        return this._timing;
    }

    public static TimeDescription parse(String s) {
        Object[] strArray = Utility.splitAndClean(s);
        if (strArray[0].charAt(0) != 't') {
            return null;
        }
        TimeDescription description = new TimeDescription(Timing.parse(strArray[0]));
        for (int i = 1; i < ArrayExtensions.getLength(strArray); ++i) {
            Object str = strArray[i];
            if (((String)str).charAt(0) != 'r') continue;
            description.addRepeatTime(RepeatTime.parse((String)str));
        }
        return description;
    }

    public boolean removeRepeatTime(RepeatTime repeatTime) {
        return this.__repeatTimes.remove(repeatTime);
    }

    private void setTiming(Timing value) {
        this._timing = value;
    }

    public TimeDescription(Timing timing) {
        if (timing == null) {
            throw new RuntimeException(new Exception("timing cannot be null."));
        }
        this.setTiming(timing);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, StringExtensions.concat(this.getTiming().toString(), "\r\n"));
        for (RepeatTime time : this.getRepeatTimes()) {
            StringBuilderExtensions.append(builder, StringExtensions.concat(time.toString(), "\r\n"));
        }
        return builder.toString();
    }
}

