/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.h264;

import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.IntegerHolder;
import fm.icelink.RtpPacketHeader;
import fm.icelink.VideoFragment;
import fm.icelink.h264.Nalu;
import fm.icelink.h264.Packet;

public class Fragment
extends VideoFragment {
    @Override
    public void destroy() {
        super.getBuffer().free();
    }

    public Fragment(RtpPacketHeader header, DataBuffer dataBuffer) {
        Packet packet = Packet.wrap(dataBuffer);
        if (packet == null) {
            throw new RuntimeException(new Exception("Could not parse H.264 packet."));
        }
        if (packet.getNaluType() == 28) {
            super.setFirst(packet.getFragmentStart());
            super.setLast(packet.getFragmentEnd());
        } else {
            super.setFirst(true);
            super.setLast(true);
        }
        int size = 0;
        for (Nalu nalu : packet.getNalus()) {
            if (super.getFirst()) {
                size += Nalu.getStartCode().getLength();
                size += nalu.getBuffer().getLength();
                continue;
            }
            size += nalu.getBuffer().getLength() - 1;
        }
        super.setBuffer(DataBufferPool.getInstance().take(size));
        int offset = 0;
        for (Nalu nalu : packet.getNalus()) {
            if (super.getFirst()) {
                IntegerHolder _var0 = new IntegerHolder(offset);
                super.getBuffer().write(Nalu.getStartCode(), offset, _var0);
                offset = _var0.getValue();
                IntegerHolder _var1 = new IntegerHolder(offset);
                super.getBuffer().write(nalu.getBuffer(), offset, _var1);
                offset = _var1.getValue();
                continue;
            }
            IntegerHolder _var2 = new IntegerHolder(offset);
            super.getBuffer().write(nalu.getBuffer().subset(1), offset, _var2);
            offset = _var2.getValue();
        }
    }
}

