/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.dtmf;

import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.MathAssistant;
import fm.icelink.NullableInteger;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.dtmf.Packet;
import java.util.ArrayList;
import java.util.HashMap;

public class Tone {
    private int _duration;
    private int _remainingDuration;
    private long _timestamp;
    private String _value;

    public Tone clone() {
        return new Tone(this.getValue(), this.getDuration());
    }

    private static int eventCodeFromValue(String eventString) {
        String _var0 = eventString;
        if (_var0.equals("0")) {
            return 0;
        }
        if (_var0.equals("1")) {
            return 1;
        }
        if (_var0.equals("2")) {
            return 2;
        }
        if (_var0.equals("3")) {
            return 3;
        }
        if (_var0.equals("4")) {
            return 4;
        }
        if (_var0.equals("5")) {
            return 5;
        }
        if (_var0.equals("6")) {
            return 6;
        }
        if (_var0.equals("7")) {
            return 7;
        }
        if (_var0.equals("8")) {
            return 8;
        }
        if (_var0.equals("9")) {
            return 9;
        }
        if (_var0.equals("*")) {
            return 10;
        }
        if (_var0.equals("#")) {
            return 11;
        }
        if (_var0.equals("A")) {
            return 12;
        }
        if (_var0.equals("B")) {
            return 13;
        }
        if (_var0.equals("C")) {
            return 14;
        }
        if (_var0.equals("D")) {
            return 15;
        }
        if (_var0.equals(",")) {
            return 99;
        }
        return -1;
    }

    public static Tone fromJson(String toneJson) {
        return JsonSerializer.deserializeObject(toneJson, new IFunction0<Tone>(){

            @Override
            public Tone invoke() {
                return new Tone();
            }
        }, new IAction3<Tone, String, String>(){

            @Override
            public void invoke(Tone tone, String key, String valueJson) {
                String str = key;
                if (str != null) {
                    if (!Global.equals(str, "value")) {
                        if (Global.equals(str, "duration")) {
                            tone.setDuration(JsonSerializer.deserializeInteger(valueJson).getValue());
                        }
                    } else {
                        tone.setValue(JsonSerializer.deserializeString(valueJson));
                    }
                }
            }
        });
    }

    public static Tone[] fromJsonArray(String tonesJson) {
        ArrayList<Tone> list = JsonSerializer.deserializeObjectArray(tonesJson, new IFunctionDelegate1<String, Tone>(){

            @Override
            public String getId() {
                return "fm.icelink.dtmf.Tone.fromJson";
            }

            @Override
            public Tone invoke(String toneJson) {
                return Tone.fromJson(toneJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new Tone[0]);
    }

    public static Tone fromPacket(Packet packet, int clockRate) {
        return new Tone(Tone.valueFromEventCode(packet.getEventCode()), packet.getDuration() * 1000 / clockRate);
    }

    public static Tone[] fromToneString(String toneString, int duration) {
        return Tone.fromToneString(toneString, duration, 100);
    }

    public static Tone[] fromToneString(String toneString, int duration, int interToneGap) {
        duration = MathAssistant.max(40, MathAssistant.min(2000, duration));
        interToneGap = MathAssistant.max(40, interToneGap);
        ArrayList<Tone> list = new ArrayList<Tone>();
        for (int i = 0; i < StringExtensions.getLength(toneString); ++i) {
            if (i > 0) {
                list.add(new Tone(Tone.getEmptyValue(), interToneGap));
            }
            if (Global.equals(StringExtensions.substring(toneString, i, 1), Tone.getPauseValue())) {
                list.add(new Tone(StringExtensions.substring(toneString, i, 1), 2000));
                continue;
            }
            list.add(new Tone(StringExtensions.substring(toneString, i, 1), duration));
        }
        return list.toArray(new Tone[0]);
    }

    public static Tone[] fromToneString(String toneString) {
        return Tone.fromToneString(toneString, 100, 100);
    }

    public static Tone getA() {
        return new Tone(Tone.getAValue(), 100);
    }

    public static String getAValue() {
        return "A";
    }

    public static Tone getB() {
        return new Tone(Tone.getBValue(), 100);
    }

    public static String getBValue() {
        return "B";
    }

    public static Tone getC() {
        return new Tone(Tone.getCValue(), 100);
    }

    public static String getCValue() {
        return "C";
    }

    public static Tone getD() {
        return new Tone(Tone.getDValue(), 100);
    }

    public int getDuration() {
        return this._duration;
    }

    public static String getDValue() {
        return "D";
    }

    public static Tone getEight() {
        return new Tone(Tone.getEightValue(), 100);
    }

    public static String getEightValue() {
        return "8";
    }

    public static Tone getEmpty() {
        return new Tone(Tone.getEmptyValue(), 0);
    }

    public static String getEmptyValue() {
        return "";
    }

    public static Tone getFive() {
        return new Tone(Tone.getFiveValue(), 100);
    }

    public static String getFiveValue() {
        return "5";
    }

    public static Tone getFour() {
        return new Tone(Tone.getFourValue(), 100);
    }

    public static String getFourValue() {
        return "4";
    }

    public static Tone getHash() {
        return new Tone(Tone.getHashValue(), 100);
    }

    public static String getHashValue() {
        return "#";
    }

    public static Tone getNine() {
        return new Tone(Tone.getNineValue(), 100);
    }

    public static String getNineValue() {
        return "9";
    }

    public static Tone getOne() {
        return new Tone(Tone.getOneValue(), 100);
    }

    public static String getOneValue() {
        return "1";
    }

    public static Tone getPause() {
        return new Tone(Tone.getPauseValue(), 2000);
    }

    public static int getPauseDuration() {
        return 2000;
    }

    public static String getPauseValue() {
        return ",";
    }

    int getRemainingDuration() {
        return this._remainingDuration;
    }

    public static Tone getSeven() {
        return new Tone(Tone.getSevenValue(), 100);
    }

    public static String getSevenValue() {
        return "7";
    }

    public static Tone getSix() {
        return new Tone(Tone.getSixValue(), 100);
    }

    public static String getSixValue() {
        return "6";
    }

    public static Tone getStar() {
        return new Tone(Tone.getStarValue(), 100);
    }

    public static String getStarValue() {
        return "*";
    }

    public static Tone getThree() {
        return new Tone(Tone.getThreeValue(), 100);
    }

    public static String getThreeValue() {
        return "3";
    }

    long getTimestamp() {
        return this._timestamp;
    }

    public static Tone getTwo() {
        return new Tone(Tone.getTwoValue(), 100);
    }

    public static String getTwoValue() {
        return "2";
    }

    public String getValue() {
        return this._value;
    }

    public static Tone getZero() {
        return new Tone(Tone.getZeroValue(), 100);
    }

    public static String getZeroValue() {
        return "0";
    }

    void setDuration(int value) {
        this._duration = value;
    }

    void setRemainingDuration(int value) {
        this._remainingDuration = value;
    }

    void setTimestamp(long value) {
        this._timestamp = value;
    }

    private void setValue(String value) {
        this._value = value;
    }

    public static String toJson(Tone tone) {
        return JsonSerializer.serializeObject(tone, new IAction2<Tone, HashMap<String, String>>(){

            @Override
            public void invoke(Tone obj, HashMap<String, String> jsonObj) {
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "value", JsonSerializer.serializeString(obj.getValue()));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObj), "duration", JsonSerializer.serializeInteger(new NullableInteger(obj.getDuration())));
            }
        });
    }

    public String toJson() {
        return Tone.toJson(this);
    }

    public static String toJsonArray(Tone[] tones) {
        return JsonSerializer.serializeObjectArray(tones, new IFunctionDelegate1<Tone, String>(){

            @Override
            public String getId() {
                return "fm.icelink.dtmf.Tone.toJson";
            }

            @Override
            public String invoke(Tone tone) {
                return Tone.toJson(tone);
            }
        });
    }

    public Tone(String value, int duration) {
        this.setValue(value);
        this.setDuration(duration);
        this.setRemainingDuration(duration);
    }

    private Tone() {
    }

    public Tone(String value) {
        this(value, 100);
    }

    public Packet toPacket(int clockRate) {
        Packet packet = new Packet();
        packet.setEventCode(Tone.eventCodeFromValue(this.getValue()));
        packet.setDuration(this.getDuration() * clockRate / 1000);
        return packet;
    }

    public String toString() {
        if (Global.equals(this.getValue(), Tone.getEmptyValue())) {
            return StringExtensions.format("[empty] ({0}ms)", IntegerExtensions.toString(this.getDuration()));
        }
        if (Global.equals(this.getValue(), Tone.getPauseValue())) {
            return StringExtensions.format("[pause] ({0}ms)", IntegerExtensions.toString(this.getDuration()));
        }
        return StringExtensions.format("{0} ({1}ms)", this.getValue(), IntegerExtensions.toString(this.getDuration()));
    }

    public static String toToneString(Tone[] tones) {
        StringBuilder builder = new StringBuilder();
        for (Tone tone : tones) {
            StringBuilderExtensions.append(builder, tone.getValue());
        }
        return builder.toString();
    }

    private static String valueFromEventCode(int eventCode) {
        int _var0 = eventCode;
        if (_var0 == 0) {
            return "0";
        }
        if (_var0 == 1) {
            return "1";
        }
        if (_var0 == 2) {
            return "2";
        }
        if (_var0 == 3) {
            return "3";
        }
        if (_var0 == 4) {
            return "4";
        }
        if (_var0 == 5) {
            return "5";
        }
        if (_var0 == 6) {
            return "6";
        }
        if (_var0 == 7) {
            return "7";
        }
        if (_var0 == 8) {
            return "8";
        }
        if (_var0 == 9) {
            return "9";
        }
        if (_var0 == 10) {
            return "*";
        }
        if (_var0 == 11) {
            return "#";
        }
        if (_var0 == 12) {
            return "A";
        }
        if (_var0 == 13) {
            return "B";
        }
        if (_var0 == 14) {
            return "C";
        }
        if (_var0 == 15) {
            return "D";
        }
        if (_var0 == 99) {
            return ",";
        }
        return "";
    }
}

