/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.dtmf;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioDepacketizer;
import fm.icelink.AudioFrame;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.Log;
import fm.icelink.dtmf.Format;
import fm.icelink.dtmf.Packet;
import fm.icelink.dtmf.Tone;
import java.util.ArrayList;
import java.util.List;

public class Receiver
extends AudioDepacketizer {
    private List<IAction1<Tone>> __onTone = new ArrayList<IAction1<Tone>>();
    private List<IAction1<Tone>> __onToneChange = new ArrayList<IAction1<Tone>>();
    private long _lastDuration;
    private long _lastTimestamp;
    private IAction1<Tone> _onTone = null;
    private IAction1<Tone> _onToneChange = null;
    private Tone _tone;

    public void addOnTone(IAction1<Tone> value) {
        if (value != null) {
            if (this._onTone == null) {
                this._onTone = new IAction1<Tone>(){

                    @Override
                    public void invoke(Tone p0) {
                        for (IAction1 action : new ArrayList(Receiver.this.__onTone)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onTone.add(value);
        }
    }

    public void addOnToneChange(IAction1<Tone> value) {
        if (value != null) {
            if (this._onToneChange == null) {
                this._onToneChange = new IAction1<Tone>(){

                    @Override
                    public void invoke(Tone p0) {
                        for (IAction1 action : new ArrayList(Receiver.this.__onToneChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onToneChange.add(value);
        }
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        Packet packet = Packet.readFrom(inputBuffer.getDataBuffer());
        if (packet == null) {
            Log.error("Malformed telephone-event packet.");
        } else if (frame.getTimestamp() != this._lastTimestamp || frame.getTimestamp() == this._lastTimestamp && (long)packet.getDuration() > this._lastDuration) {
            this._lastTimestamp = frame.getTimestamp();
            this._lastDuration = packet.getDuration();
            this.processPacket(packet);
            if (packet.getEnd()) {
                Packet packet2 = new Packet();
                packet2.setEventCode(-1);
                packet2.setEnd(true);
                packet2.setDuration(0);
                packet2.setVolume(0);
                this.processPacket(packet2);
            }
        }
    }

    @Override
    public boolean getDisabled() {
        return false;
    }

    @Override
    public String getLabel() {
        return "DTMF Receiver";
    }

    public Tone getTone() {
        return this._tone;
    }

    private void processPacket(Packet packet) {
        Tone tone = this.getTone();
        this.setTone(Tone.fromPacket(packet, super.getConfig().getClockRate()));
        if (!Global.equals(this.getTone().getValue(), tone.getValue())) {
            this.raiseToneChange(this.getTone());
        }
        this.raiseTone(this.getTone());
    }

    private void raiseTone(Tone tone) {
        IAction1<Tone> onTone = this._onTone;
        if (onTone != null) {
            onTone.invoke(tone);
        }
    }

    private void raiseToneChange(Tone tone) {
        IAction1<Tone> onToneChange = this._onToneChange;
        if (onToneChange != null) {
            onToneChange.invoke(tone);
        }
    }

    public Receiver() {
        this(new Format().getClockRate());
    }

    public Receiver(int clockRate) {
        super(new Format(clockRate));
        this.setTone(Tone.getEmpty());
    }

    public void removeOnTone(IAction1<Tone> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onTone, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onTone.remove(value);
        if (this.__onTone.size() == 0) {
            this._onTone = null;
        }
    }

    public void removeOnToneChange(IAction1<Tone> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onToneChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onToneChange.remove(value);
        if (this.__onToneChange.size() == 0) {
            this._onToneChange = null;
        }
    }

    private void setTone(Tone value) {
        this._tone = value;
    }
}

