/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.diagnostics;

import fm.icelink.DoubleExtensions;
import fm.icelink.LinkedList;
import fm.icelink.MathAssistant;
import fm.icelink.StringExtensions;
import fm.icelink.Unit;
import fm.icelink.diagnostics.Timer;
import fm.icelink.diagnostics.Timers;

public class DurationTimer
extends Timer {
    private int __averageCount = 0;
    private double __avg = 0.0;
    private LinkedList<Unit<Long>> __beginSamples = new LinkedList();
    private LinkedList<Unit<Long>> __endSamples = new LinkedList();
    private double __max = -1.0;
    private double __min = -1.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginSample() {
        if (Timers.getEnabled()) {
            LinkedList<Unit<Long>> linkedList = this.__beginSamples;
            synchronized (linkedList) {
                this.__beginSamples.addLast(new Unit<Long>(super.getWatch().getElapsedMilliseconds()));
            }
        }
    }

    DurationTimer(String tag) {
        super(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSample() {
        if (Timers.getEnabled()) {
            LinkedList<Unit<Long>> linkedList = this.__endSamples;
            synchronized (linkedList) {
                this.__endSamples.addLast(new Unit<Long>(super.getWatch().getElapsedMilliseconds()));
            }
        }
    }

    @Override
    public boolean getHasData() {
        return this.__min != -1.0 || this.__beginSamples.getCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStats() {
        int count = this.__endSamples.getCount();
        double num2 = 0.0;
        if (count > 0) {
            LinkedList<Unit<Long>> linkedList = this.__endSamples;
            synchronized (linkedList) {
                LinkedList<Unit<Long>> linkedList2 = this.__beginSamples;
                synchronized (linkedList2) {
                    for (int i = 0; i < count; ++i) {
                        long item = 0L;
                        long num5 = 0L;
                        item = this.__beginSamples.getFirst().getValue().getItem();
                        this.__beginSamples.removeFirst();
                        num5 = this.__endSamples.getFirst().getValue().getItem();
                        this.__endSamples.removeFirst();
                        long num6 = num5 - item;
                        this.__min = this.__min == -1.0 ? (double)num6 : MathAssistant.min(this.__min, (double)num6);
                        this.__max = this.__max == -1.0 ? (double)num6 : MathAssistant.max(this.__max, (double)num6);
                        num2 += ((double)num6 - num2) / (double)(i + 1);
                        this.__avg += (num2 - this.__avg) / (double)(++this.__averageCount);
                    }
                }
            }
        }
        String str = count == 0 ? "No Samples" : DoubleExtensions.toString(num2);
        return StringExtensions.format("{0}:\n\tInstant Avg: {1}ms\n\tMin: {2}ms\n\tMax: {3}ms\n\tAvg: {4}ms", new Object[]{super.getTag(), str, DoubleExtensions.toString(this.__min), DoubleExtensions.toString(this.__max), DoubleExtensions.toString(this.__avg)});
    }
}

