/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import fm.icelink.X509Time;

class X509Validity {
    private X509Time _notAfter;
    private X509Time _notBefore;

    public static X509Validity fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 2) {
            return null;
        }
        X509Validity validity = new X509Validity();
        validity.setNotBefore(X509Time.fromAsn1(sequence.getValues()[0]));
        validity.setNotAfter(X509Time.fromAsn1(sequence.getValues()[1]));
        return validity;
    }

    public X509Time getNotAfter() {
        return this._notAfter;
    }

    public X509Time getNotBefore() {
        return this._notBefore;
    }

    public void setNotAfter(X509Time value) {
        this._notAfter = value;
    }

    public void setNotBefore(X509Time value) {
        this._notBefore = value;
    }

    public Asn1Sequence toAsn1() {
        return new Asn1Sequence(new Asn1Any[]{this.getNotBefore().toAsn1(), this.getNotAfter().toAsn1()});
    }

    public X509Validity(X509Time notBefore, X509Time notAfter) {
        this.setNotBefore(notBefore);
        this.setNotAfter(notAfter);
    }

    public X509Validity() {
    }
}

