/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Integer;
import fm.icelink.Asn1OctetString;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import fm.icelink.X509AlgorithmIdentifier;
import java.util.ArrayList;

class X509PrivateKeyInfo {
    private byte[] _privateKey;
    private X509AlgorithmIdentifier _privateKeyAlgorithm;
    private int _version;

    public static X509PrivateKeyInfo fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 3) {
            return null;
        }
        X509PrivateKeyInfo info = new X509PrivateKeyInfo();
        int num = 0;
        info.setVersion((int)((Asn1Integer)sequence.getValues()[num++]).getLongValue());
        info.setPrivateKeyAlgorithm(X509AlgorithmIdentifier.fromAsn1(sequence.getValues()[num++]));
        info.setPrivateKey(((Asn1OctetString)sequence.getValues()[num++]).getValueBytes());
        return info;
    }

    public byte[] getPrivateKey() {
        return this._privateKey;
    }

    public X509AlgorithmIdentifier getPrivateKeyAlgorithm() {
        return this._privateKeyAlgorithm;
    }

    public int getVersion() {
        return this._version;
    }

    public void setPrivateKey(byte[] value) {
        this._privateKey = value;
    }

    public void setPrivateKeyAlgorithm(X509AlgorithmIdentifier value) {
        this._privateKeyAlgorithm = value;
    }

    public void setVersion(int value) {
        this._version = value;
    }

    public Asn1Sequence toAsn1() {
        ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
        list.add(new Asn1Integer(this.getVersion()));
        list.add(this.getPrivateKeyAlgorithm().toAsn1());
        list.add(new Asn1OctetString(this.getPrivateKey()));
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }

    public X509PrivateKeyInfo() {
        this.setVersion(0);
    }
}

