/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1BitString;
import fm.icelink.Asn1Explicit;
import fm.icelink.Asn1Integer;
import fm.icelink.Asn1OctetString;
import fm.icelink.Asn1Sequence;
import fm.icelink.Asn1Unknown;
import fm.icelink.Global;
import fm.icelink.IntegerHolder;
import fm.icelink.X509ECParameters;
import fm.icelink.X509ECPoint;
import java.util.ArrayList;

class X509ECPrivateKey {
    private X509ECParameters _parameters;
    private byte[] _privateKey;
    private byte[] _publicKey;
    private int _version;

    public static X509ECPrivateKey fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 2) {
            return null;
        }
        X509ECPrivateKey key = new X509ECPrivateKey();
        int num = 0;
        key.setVersion((int)((Asn1Integer)sequence.getValues()[num++]).getLongValue());
        key.setPrivateKey(((Asn1OctetString)sequence.getValues()[num++]).getValueBytes());
        while (ArrayExtensions.getLength(sequence.getValues()) > num) {
            int tag = -1;
            IntegerHolder _var0 = new IntegerHolder(tag);
            Asn1Any _var1 = Asn1Unknown.unwrap(sequence.getValues()[num++], _var0);
            tag = _var0.getValue();
            Asn1Any any2 = _var1;
            int _var2 = tag;
            if (_var2 == 0) {
                key.setParameters(X509ECParameters.fromAsn1(any2));
                continue;
            }
            if (_var2 != 1) continue;
            key.setPublicKey(X509ECPoint.fromAsn1(new Asn1OctetString(((Asn1BitString)any2).getValueBytes())).getValue());
        }
        return key;
    }

    public X509ECParameters getParameters() {
        return this._parameters;
    }

    public byte[] getPrivateKey() {
        return this._privateKey;
    }

    public byte[] getPublicKey() {
        return this._publicKey;
    }

    public int getVersion() {
        return this._version;
    }

    public void setParameters(X509ECParameters value) {
        this._parameters = value;
    }

    public void setPrivateKey(byte[] value) {
        this._privateKey = value;
    }

    public void setPublicKey(byte[] value) {
        this._publicKey = value;
    }

    public void setVersion(int value) {
        this._version = value;
    }

    public Asn1Sequence toAsn1() {
        ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
        list.add(new Asn1Integer(this.getVersion()));
        list.add(new Asn1OctetString(this.getPrivateKey()));
        if (this.getParameters() != null) {
            list.add(Asn1Explicit.wrap(0, this.getParameters().toAsn1()));
        }
        if (this.getPublicKey() != null) {
            list.add(Asn1Explicit.wrap(1, new Asn1BitString(new X509ECPoint(this.getPublicKey()).toAsn1().getValueBytes())));
        }
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }

    public X509ECPrivateKey() {
        this.setVersion(1);
    }

    public X509ECPrivateKey(byte[] privateKey, X509ECParameters parameters, byte[] publicKey) {
        this();
        this.setPrivateKey(privateKey);
        this.setParameters(parameters);
        this.setPublicKey(publicKey);
    }
}

