/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1Integer;
import fm.icelink.Asn1Null;
import fm.icelink.Asn1ObjectIdentifier;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import fm.icelink.NullableLong;
import fm.icelink.X509ECCurve;
import fm.icelink.X509ECFieldId;
import fm.icelink.X509ECPoint;
import java.util.ArrayList;

class X509ECParameters {
    private X509ECPoint _basePoint;
    private NullableLong _cofactor = new NullableLong();
    private X509ECCurve _curve;
    private X509ECFieldId _fieldId;
    private long[] _namedCurve;
    private long _order;

    public static X509ECParameters fromAsn1(Asn1Any any) {
        Asn1ObjectIdentifier identifier = Global.tryCast(any, Asn1ObjectIdentifier.class);
        if (identifier != null) {
            return new X509ECParameters(identifier.getValues());
        }
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence != null) {
            if (ArrayExtensions.getLength(sequence.getValues()) < 5) {
                return null;
            }
            int num = 0;
            Asn1Integer integer = (Asn1Integer)sequence.getValues()[num++];
            if (integer.getLongValue() != 1L) {
                return null;
            }
            X509ECFieldId fieldId = X509ECFieldId.fromAsn1(sequence.getValues()[num++]);
            X509ECCurve curve = X509ECCurve.fromAsn1(sequence.getValues()[num++]);
            X509ECPoint basePoint = X509ECPoint.fromAsn1(sequence.getValues()[num++]);
            long longValue = ((Asn1Integer)sequence.getValues()[num++]).getLongValue();
            X509ECParameters parameters = new X509ECParameters(fieldId, curve, basePoint, longValue);
            if (ArrayExtensions.getLength(sequence.getValues()) > num) {
                parameters.setCofactor(new NullableLong(((Asn1Integer)sequence.getValues()[num++]).getLongValue()));
            }
            return parameters;
        }
        return new X509ECParameters();
    }

    public X509ECPoint getBasePoint() {
        return this._basePoint;
    }

    public NullableLong getCofactor() {
        return this._cofactor;
    }

    public X509ECCurve getCurve() {
        return this._curve;
    }

    public X509ECFieldId getFieldId() {
        return this._fieldId;
    }

    public long[] getNamedCurve() {
        return this._namedCurve;
    }

    public long getOrder() {
        return this._order;
    }

    public void setBasePoint(X509ECPoint value) {
        this._basePoint = value;
    }

    public void setCofactor(NullableLong value) {
        this._cofactor = value;
    }

    public void setCurve(X509ECCurve value) {
        this._curve = value;
    }

    public void setFieldId(X509ECFieldId value) {
        this._fieldId = value;
    }

    public void setNamedCurve(long[] value) {
        this._namedCurve = value;
    }

    public void setOrder(long value) {
        this._order = value;
    }

    public Asn1Any toAsn1() {
        if (this.getNamedCurve() != null) {
            return new Asn1ObjectIdentifier(this.getNamedCurve());
        }
        if (this.getCurve() != null) {
            ArrayList<Asn1Any> list = new ArrayList<Asn1Any>();
            list.add(new Asn1Integer(1L));
            list.add(this.getFieldId().toAsn1());
            list.add(this.getCurve().toAsn1());
            list.add(this.getBasePoint().toAsn1());
            list.add(new Asn1Integer(this.getOrder()));
            if (this.getCofactor().getHasValue()) {
                list.add(new Asn1Integer(this.getCofactor().getValue()));
            }
            return new Asn1Sequence(list.toArray(new Asn1Any[0]));
        }
        return new Asn1Null();
    }

    public X509ECParameters() {
    }

    public X509ECParameters(long[] namedCurve) {
        this.setNamedCurve(namedCurve);
    }

    public X509ECParameters(X509ECFieldId fieldId, X509ECCurve curve, X509ECPoint basePoint, long order) {
        this.setFieldId(fieldId);
        this.setCurve(curve);
        this.setBasePoint(basePoint);
        this.setOrder(order);
    }
}

