/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1ObjectIdentifier;
import fm.icelink.EcdsaNamedCurve;
import fm.icelink.Global;

class X509ECNamedCurve {
    public static long[] fromEnum(EcdsaNamedCurve namedCurve) {
        if (Global.equals((Object)namedCurve, (Object)EcdsaNamedCurve.P256)) {
            return X509ECNamedCurve.getSecP256R1();
        }
        if (Global.equals((Object)namedCurve, (Object)EcdsaNamedCurve.P384)) {
            return X509ECNamedCurve.getSecP384R1();
        }
        if (!Global.equals((Object)namedCurve, (Object)EcdsaNamedCurve.P521)) {
            throw new RuntimeException(new Exception("Unsupported named curve."));
        }
        return X509ECNamedCurve.getSecP521R1();
    }

    public static long[] getSecP192R1() {
        return new long[]{1L, 2L, 840L, 10045L, 3L, 1L, 1L};
    }

    public static long[] getSecP224R1() {
        return new long[]{1L, 3L, 132L, 0L, 33L};
    }

    public static long[] getSecP256R1() {
        return new long[]{1L, 2L, 840L, 10045L, 3L, 1L, 7L};
    }

    public static long[] getSecP384R1() {
        return new long[]{1L, 3L, 132L, 0L, 34L};
    }

    public static long[] getSecP521R1() {
        return new long[]{1L, 3L, 132L, 0L, 35L};
    }

    public static long[] getSecT163K1() {
        return new long[]{1L, 3L, 132L, 0L, 1L};
    }

    public static long[] getSecT163R2() {
        return new long[]{1L, 3L, 132L, 0L, 15L};
    }

    public static long[] getSecT233K1() {
        return new long[]{1L, 3L, 132L, 0L, 26L};
    }

    public static long[] getSecT233R1() {
        return new long[]{1L, 3L, 132L, 0L, 27L};
    }

    public static long[] getSecT283K1() {
        return new long[]{1L, 3L, 132L, 0L, 16L};
    }

    public static long[] getSecT283R1() {
        return new long[]{1L, 3L, 132L, 0L, 17L};
    }

    public static long[] getSecT409K1() {
        return new long[]{1L, 3L, 132L, 0L, 36L};
    }

    public static long[] getSecT409R1() {
        return new long[]{1L, 3L, 132L, 0L, 37L};
    }

    public static long[] getSecT571K1() {
        return new long[]{1L, 3L, 132L, 0L, 38L};
    }

    public static long[] getSecT571R1() {
        return new long[]{1L, 3L, 132L, 0L, 39L};
    }

    public static EcdsaNamedCurve toEnum(long[] namedCurveIdentifier) {
        if (Asn1ObjectIdentifier.areEqual(namedCurveIdentifier, X509ECNamedCurve.getSecP256R1())) {
            return EcdsaNamedCurve.P256;
        }
        if (Asn1ObjectIdentifier.areEqual(namedCurveIdentifier, X509ECNamedCurve.getSecP384R1())) {
            return EcdsaNamedCurve.P384;
        }
        if (!Asn1ObjectIdentifier.areEqual(namedCurveIdentifier, X509ECNamedCurve.getSecP521R1())) {
            throw new RuntimeException(new Exception("Unsupported named curve."));
        }
        return EcdsaNamedCurve.P521;
    }
}

