/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Asn1Any;
import fm.icelink.Asn1ObjectIdentifier;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import java.util.ArrayList;

class X509ECFieldId {
    private long[] _fieldType;
    private Object _parameters;

    public static X509ECFieldId fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        if (ArrayExtensions.getLength(sequence.getValues()) < 2) {
            return null;
        }
        X509ECFieldId id = new X509ECFieldId();
        int num = 0;
        id.setFieldType(((Asn1ObjectIdentifier)sequence.getValues()[num++]).getValues());
        return id;
    }

    public long[] getFieldType() {
        return this._fieldType;
    }

    public Object getParameters() {
        return this._parameters;
    }

    public void setFieldType(long[] value) {
        this._fieldType = value;
    }

    public void setParameters(Object value) {
        this._parameters = value;
    }

    public Asn1Any toAsn1() {
        ArrayList<Asn1ObjectIdentifier> list = new ArrayList<Asn1ObjectIdentifier>();
        list.add(new Asn1ObjectIdentifier(this.getFieldType()));
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }
}

