/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.AtomicLong;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Error;
import fm.icelink.FirControlFrame;
import fm.icelink.ILog;
import fm.icelink.IVideoOutput;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.MediaTrackStats;
import fm.icelink.PliControlFrame;
import fm.icelink.RtpPacketHeader;
import fm.icelink.StringExtensions;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFragment;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.sdp.MediaDescription;
import java.util.ArrayList;

public abstract class VideoDepacketizer<TFragment extends VideoFragment>
extends VideoPipe {
    private boolean __delayDepacketizeOnPendingKeyFrame = true;
    private AtomicLong __framesCorrupted;
    private AtomicLong __framesDropped;
    private AtomicLong __framesReceived;
    private static ILog __log = Log.getLogger(VideoDepacketizer.class);
    private volatile boolean _keyFrameEverReceived = false;
    private volatile boolean _keyFrameReceived = false;
    private long _lastSequenceNumber = -1L;
    private ArrayList<TFragment> _pendingFragments = new ArrayList();

    private static VideoFormat cloneFormat(VideoFormat format, boolean isPacketized) {
        VideoFormat format2 = format.clone();
        format2.setIsPacketized(isPacketized);
        return format2;
    }

    protected abstract TFragment doCreateFragment(RtpPacketHeader var1, DataBuffer var2);

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        long sequenceNumber = inputBuffer.getSequenceNumber();
        if (this._lastSequenceNumber == -1L) {
            this._lastSequenceNumber = sequenceNumber - 1L;
        }
        if (sequenceNumber <= this._lastSequenceNumber) {
            throw new RuntimeException(new Exception("Video depacketizer cannot process unordered packets."));
        }
        TFragment item = this.doCreateFragment(inputBuffer.getRtpHeader(), inputBuffer.getDataBuffer());
        ((VideoFragment)item).getBuffer().keep();
        if (sequenceNumber - this._lastSequenceNumber > 1L) {
            this.sendKeyFrameRequest("Video depacketizer needs keyframe.");
            for (VideoFragment local2 : this._pendingFragments) {
                local2.getBuffer().free();
                local2.destroy();
            }
            this._pendingFragments.clear();
            this.__framesReceived.increment();
            this.__framesCorrupted.increment();
            this.__framesDropped.increment();
            if (!((VideoFragment)item).getFirst()) {
                return;
            }
        }
        this._lastSequenceNumber = sequenceNumber;
        if (ArrayListExtensions.getCount(this._pendingFragments) == 0 && !((VideoFragment)item).getFirst()) {
            this.__framesReceived.increment();
            this.__framesCorrupted.increment();
            if (__log.getIsDebugEnabled()) {
                __log.debug(StringExtensions.format("Video depacketizer is ignoring unrecognized video packet ({0} bytes).", IntegerExtensions.toString(((VideoFragment)item).getBuffer().getLength())));
            }
        } else {
            this._pendingFragments.add(item);
            VideoFragment local3 = (VideoFragment)ArrayListExtensions.getItem(this._pendingFragments).get(0);
            VideoFragment local4 = (VideoFragment)ArrayListExtensions.getItem(this._pendingFragments).get(ArrayListExtensions.getCount(this._pendingFragments) - 1);
            if (local3.getFirst() && local4.getLast()) {
                int size = 0;
                for (VideoFragment local2 : this._pendingFragments) {
                    size += local2.getBuffer().getLength();
                }
                int offset = 0;
                DataBuffer buffer = DataBufferPool.getInstance().take(size);
                for (VideoFragment local2 : this._pendingFragments) {
                    IntegerHolder _var0 = new IntegerHolder(offset);
                    buffer.write(local2.getBuffer(), offset, _var0);
                    offset = _var0.getValue();
                    local2.getBuffer().free();
                    local2.destroy();
                }
                this._pendingFragments.clear();
                if (this.getDelayDepacketize()) {
                    if (this.isKeyFrame(buffer)) {
                        this._keyFrameReceived = true;
                        if (!this._keyFrameEverReceived) {
                            this._keyFrameEverReceived = true;
                        } else {
                            IVideoOutput input = (IVideoOutput)super.getInput();
                            if (input != null) {
                                input.incrementFirSequenceNumber();
                            }
                        }
                    } else {
                        this.sendKeyFrameRequest("Video depacketizer needs keyframe.");
                    }
                }
                this.__framesReceived.increment();
                if (this.getDelayDepacketize()) {
                    this.__framesDropped.increment();
                } else {
                    frame.addBuffer(new VideoBuffer(inputBuffer.getWidth(), inputBuffer.getHeight(), buffer, (VideoFormat)super.getOutputFormat()));
                    this.raiseFrame(frame);
                }
                buffer.free();
            } else {
                VideoFragment local5 = (VideoFragment)ArrayListExtensions.getItem(this._pendingFragments).get(ArrayListExtensions.getCount(this._pendingFragments) - 1);
                if (local5.getLast()) {
                    for (VideoFragment local2 : this._pendingFragments) {
                        local2.getBuffer().free();
                        local2.destroy();
                    }
                    this._pendingFragments.clear();
                }
            }
        }
    }

    @Override
    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        if (isLocalDescription) {
            mediaDescription.insertCcmFirAttribute(((VideoFormat)super.getInputFormat()).getName(), ((VideoFormat)super.getInputFormat()).getClockRate(), ((VideoFormat)super.getInputFormat()).getParameters());
            mediaDescription.insertNackPliAttribute(((VideoFormat)super.getInputFormat()).getName(), ((VideoFormat)super.getInputFormat()).getClockRate(), ((VideoFormat)super.getInputFormat()).getParameters());
        }
        return null;
    }

    @Override
    protected void doProcessStatsFromInput(MediaTrackStats stats) {
        super.doProcessStatsFromInput(stats);
        stats.setFramesReceived(this.getFramesReceived());
        stats.setFramesDropped(this.getFramesDropped());
        stats.setFramesCorrupted(this.getFramesCorrupted());
    }

    @Override
    protected boolean getAllowDiagnosticTimer() {
        return false;
    }

    protected boolean getDelayDepacketize() {
        return this.getDelayDepacketizeOnPendingKeyFrame() && !this._keyFrameReceived;
    }

    public boolean getDelayDepacketizeOnPendingKeyFrame() {
        return this.__delayDepacketizeOnPendingKeyFrame;
    }

    public long getFramesCorrupted() {
        return this.__framesCorrupted.getValue();
    }

    public long getFramesDropped() {
        return this.__framesDropped.getValue();
    }

    public long getFramesReceived() {
        return this.__framesReceived.getValue();
    }

    protected abstract boolean isKeyFrame(DataBuffer var1);

    protected void sendKeyFrameRequest(String reason) {
        IVideoOutput input = (IVideoOutput)super.getInput();
        if (this._keyFrameEverReceived || input == null) {
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("Video decoder raising picture loss indication (PLI). {0}", reason));
            }
            super.raiseControlFrame(new PliControlFrame());
        } else {
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("Video decoder raising full intra request (FIR). {0}", reason));
            }
            super.raiseControlFrame(new FirControlFrame(input.getFirSequenceNumber()));
        }
        this._keyFrameReceived = false;
    }

    public void setDelayDepacketizeOnPendingKeyFrame(boolean value) {
        this.__delayDepacketizeOnPendingKeyFrame = value;
    }

    public VideoDepacketizer(VideoFormat format) {
        super(VideoDepacketizer.cloneFormat(format, true), VideoDepacketizer.cloneFormat(format, false));
        this.__framesReceived = new AtomicLong();
        this.__framesDropped = new AtomicLong();
        this.__framesCorrupted = new AtomicLong();
    }

    public VideoDepacketizer(IVideoOutput input) {
        this((VideoFormat)input.getOutputFormat());
        super.addInput(input);
    }
}

