/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.IFunctionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.JsonSerializer;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaFormat;
import fm.icelink.NullableBoolean;
import fm.icelink.NullableInteger;
import fm.icelink.StringComparison;
import fm.icelink.StringExtensions;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFragment;
import fm.icelink.h264.Fragment;
import fm.icelink.vp8.Utility;
import java.util.ArrayList;
import java.util.HashMap;

public class VideoBuffer
extends MediaBuffer<VideoFormat, VideoBuffer> {
    private int __height;
    private boolean __isMuted;
    private int __orientation = 0;
    private int __width;
    private int[] _strides;

    private static int calculateByteCount(VideoFormat format, int width, int height) {
        if (format.getIsYuvType()) {
            return (int)((double)(width * height) * 1.5);
        }
        if (format.getIsRgbType()) {
            return width * height * 3;
        }
        if (format.getIsRgbaType()) {
            return width * height * 4;
        }
        return -1;
    }

    @Override
    public VideoBuffer clone() {
        VideoBuffer buffer = (VideoBuffer)super.clone();
        buffer.setStrides(this.getStrides());
        buffer.setWidth(this.getWidth());
        buffer.setHeight(this.getHeight());
        buffer.setOrientation(this.getOrientation());
        buffer.__isMuted = this.__isMuted;
        return buffer;
    }

    public VideoBuffer convert(VideoFormat format) {
        if (format == null || ((VideoFormat)super.getFormat()).isEquivalent(format, false)) {
            return this.clone();
        }
        return this.convert(format, null);
    }

    public VideoBuffer convert(VideoFormat format, DataBuffer dataBuffer) {
        if (!((VideoFormat)super.getFormat()).getIsRaw() || !format.getIsRaw()) {
            throw new RuntimeException(new Exception("Cannot convert to or from encoded formats."));
        }
        if (dataBuffer == null) {
            dataBuffer = DataBuffer.allocate(VideoBuffer.calculateByteCount(format, this.getWidth(), this.getHeight()));
        }
        int[] rValues = null;
        int[] gValues = null;
        int[] bValues = null;
        int[] aValues = null;
        Holder<Object> _var0 = new Holder<Object>(rValues);
        Holder<Object> _var1 = new Holder<Object>(gValues);
        Holder<Object> _var2 = new Holder<Object>(bValues);
        Holder<Object> _var3 = new Holder<Object>(aValues);
        this.read(_var0, _var1, _var2, _var3);
        rValues = _var0.getValue();
        gValues = _var1.getValue();
        bValues = _var2.getValue();
        aValues = _var3.getValue();
        VideoBuffer buffer = new VideoBuffer(this.getWidth(), this.getHeight(), dataBuffer, format);
        buffer.write(rValues, gValues, bValues, aValues);
        return buffer;
    }

    public static VideoBuffer createBlack(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 0, 0, formatName);
    }

    public static VideoBuffer createBlue(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 0, 255, formatName);
    }

    public static VideoBuffer createCustom(int width, int height, int red, int green, int blue, String formatName, DataBuffer buffer) {
        int num = VideoBuffer.getMinimumBufferLength(width, height, formatName);
        if (num != -1) {
            if (buffer.getLength() < num) {
                throw new RuntimeException(new Exception(StringExtensions.format("Buffer too small. Minimum buffer length is {0} but buffer length is {1}.", IntegerExtensions.toString(num), IntegerExtensions.toString(buffer.getLength()))));
            }
            boolean flag = StringExtensions.isEqual(VideoFormat.getBgrName(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag2 = StringExtensions.isEqual(VideoFormat.getRgbName(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag3 = flag || flag2;
            boolean flag4 = StringExtensions.isEqual(VideoFormat.getBgraName(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag5 = StringExtensions.isEqual(VideoFormat.getRgbaName(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag6 = StringExtensions.isEqual(VideoFormat.getAbgrName(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag7 = StringExtensions.isEqual(VideoFormat.getArgbName(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag8 = flag4 || flag5 || flag6 || flag7;
            boolean flag9 = StringExtensions.isEqual(VideoFormat.getI420Name(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag10 = StringExtensions.isEqual(VideoFormat.getYv12Name(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag11 = StringExtensions.isEqual(VideoFormat.getNv12Name(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag12 = StringExtensions.isEqual(VideoFormat.getNv21Name(), formatName, StringComparison.OrdinalIgnoreCase);
            boolean flag13 = flag9 || flag10 || flag11 || flag12;
            int num2 = width * height;
            if (flag3) {
                if (red == green && red == blue) {
                    buffer.set(BitAssistant.castByte(red));
                } else {
                    int num3 = 0;
                    if (flag) {
                        for (int num4 = 0; num4 < num2; ++num4) {
                            buffer.write8(blue, num3++);
                            buffer.write8(green, num3++);
                            buffer.write8(red, num3++);
                        }
                    } else {
                        for (int num4 = 0; num4 < num2; ++num4) {
                            buffer.write8(red, num3++);
                            buffer.write8(green, num3++);
                            buffer.write8(blue, num3++);
                        }
                    }
                }
                return new VideoBuffer(width, height, buffer, new VideoFormat(formatName));
            }
            if (flag8) {
                int num3 = 0;
                int num5 = 255;
                if (flag4) {
                    for (int num4 = 0; num4 < num2; ++num4) {
                        buffer.write8(blue, num3++);
                        buffer.write8(green, num3++);
                        buffer.write8(red, num3++);
                        buffer.write8(num5, num3++);
                    }
                } else if (flag5) {
                    for (int num4 = 0; num4 < num2; ++num4) {
                        buffer.write8(red, num3++);
                        buffer.write8(green, num3++);
                        buffer.write8(blue, num3++);
                        buffer.write8(num5, num3++);
                    }
                } else if (flag6) {
                    for (int num4 = 0; num4 < num2; ++num4) {
                        buffer.write8(num5, num3++);
                        buffer.write8(blue, num3++);
                        buffer.write8(green, num3++);
                        buffer.write8(red, num3++);
                    }
                } else if (flag7) {
                    for (int num4 = 0; num4 < num2; ++num4) {
                        buffer.write8(num5, num3++);
                        buffer.write8(red, num3++);
                        buffer.write8(green, num3++);
                        buffer.write8(blue, num3++);
                    }
                }
                return new VideoBuffer(width, height, buffer, new VideoFormat(formatName));
            }
            if (flag13) {
                int num6 = (int)(0.299 * (double)red + 0.587 * (double)green + 0.110004 * (double)blue);
                int num7 = (int)(-0.168736 * (double)red - 0.331264 * (double)green + 0.5 * (double)blue) + 128;
                int num8 = (int)(0.5 * (double)red - 0.418688 * (double)green - 0.081312 * (double)blue) + 128;
                int length = num2;
                buffer.set(BitAssistant.castByte(num6), 0, length);
                if (flag9 || flag10) {
                    int num10 = num2 / 4;
                    int num11 = num2 / 4;
                    int offset = length;
                    int num13 = length + num10;
                    if (flag10) {
                        num13 = length;
                        offset = length + num11;
                    }
                    buffer.set(BitAssistant.castByte(num7), offset, num10);
                    buffer.set(BitAssistant.castByte(num8), num13, num11);
                } else {
                    int num14 = num2 / 2;
                    int num15 = length;
                    int num16 = 0;
                    int num17 = 1;
                    if (flag12) {
                        num16 = 1;
                        num17 = 0;
                    }
                    for (int num4 = num15; num4 < num15 + num14; num4 += 2) {
                        buffer.write8(num15 + num16, num7);
                        buffer.write8(num15 + num17, num8);
                    }
                }
                return new VideoBuffer(width, height, buffer, new VideoFormat(formatName));
            }
        }
        Log.error(StringExtensions.format("Could not create custom video buffer. Format '{0}' is not supported.", formatName));
        return null;
    }

    public static VideoBuffer createCustom(int width, int height, int red, int green, int blue, String formatName) {
        int count = VideoBuffer.getMinimumBufferLength(width, height, formatName);
        if (count != -1) {
            return VideoBuffer.createCustom(width, height, red, green, blue, formatName, DataBuffer.allocate(count));
        }
        Log.error(StringExtensions.format("Could not create custom video buffer. Format '{0}' is not supported.", formatName));
        return null;
    }

    public static VideoBuffer createCyan(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 255, 255, formatName);
    }

    public static VideoBuffer createDarkBlue(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 0, 128, formatName);
    }

    public static VideoBuffer createDarkGreen(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 128, 0, formatName);
    }

    public static VideoBuffer createDarkRed(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 0, 0, formatName);
    }

    public static VideoBuffer createGray(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 128, 128, formatName);
    }

    public static VideoBuffer createGreen(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 255, 0, formatName);
    }

    @Override
    protected VideoBuffer createInstance() {
        return new VideoBuffer();
    }

    public static VideoBuffer createMagenta(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 0, 255, formatName);
    }

    public static VideoBuffer createOlive(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 128, 0, formatName);
    }

    public static VideoBuffer createPurple(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 128, 0, 128, formatName);
    }

    public static VideoBuffer createRed(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 0, 0, formatName);
    }

    public static VideoBuffer createTeal(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 0, 128, 128, formatName);
    }

    public static VideoBuffer createWhite(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 255, 255, formatName);
    }

    public static VideoBuffer createYellow(int width, int height, String formatName) {
        return VideoBuffer.createCustom(width, height, 255, 255, 0, formatName);
    }

    public static VideoBuffer fromJson(String videoBufferJson) {
        return JsonSerializer.deserializeObject(videoBufferJson, new IFunction0<VideoBuffer>(){

            @Override
            public VideoBuffer invoke() {
                return new VideoBuffer();
            }
        }, new IAction3<VideoBuffer, String, String>(){

            @Override
            public void invoke(VideoBuffer videoBuffer, String name, String valueJson) {
                String _var0 = name;
                if (_var0.equals("width")) {
                    videoBuffer.setWidth(JsonSerializer.deserializeInteger(valueJson).getValue());
                } else if (_var0.equals("height")) {
                    videoBuffer.setHeight(JsonSerializer.deserializeInteger(valueJson).getValue());
                } else if (_var0.equals("strides")) {
                    videoBuffer.setStrides(JsonSerializer.deserializeIntegerArray(valueJson));
                } else if (_var0.equals("orientation")) {
                    videoBuffer.setOrientation(JsonSerializer.deserializeInteger(valueJson).getValue());
                } else if (_var0.equals("isMuted")) {
                    videoBuffer.setIsMuted(JsonSerializer.deserializeBoolean(valueJson).getValue());
                } else if (_var0.equals("dataBuffers")) {
                    videoBuffer.setDataBuffers(DataBuffer.fromJsonArray(valueJson));
                } else if (_var0.equals("format")) {
                    videoBuffer.setFormat(VideoFormat.fromJson(valueJson));
                }
            }
        });
    }

    public static VideoBuffer[] fromJsonArray(String videoBuffersJson) {
        ArrayList<VideoBuffer> list = JsonSerializer.deserializeObjectArray(videoBuffersJson, new IFunctionDelegate1<String, VideoBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.VideoBuffer.fromJson";
            }

            @Override
            public VideoBuffer invoke(String videoBufferJson) {
                return VideoBuffer.fromJson(videoBufferJson);
            }
        });
        if (list == null) {
            return null;
        }
        return list.toArray(new VideoBuffer[0]);
    }

    private int[] getDefaultStrides(int width, VideoFormat format) {
        if (format.getIsRgbType()) {
            return new int[]{width * 3};
        }
        if (format.getIsRgbaType()) {
            return new int[]{width * 4};
        }
        if (format.getIsI420() || format.getIsYv12()) {
            if (ArrayExtensions.getLength(super.getDataBuffers()) == 1) {
                return new int[]{width};
            }
            return new int[]{width, width / 2, width / 2};
        }
        if (format.getIsNv12() || format.getIsNv21()) {
            if (ArrayExtensions.getLength(super.getDataBuffers()) == 1) {
                return new int[]{width};
            }
            return new int[]{width, width};
        }
        if (!(Global.equals(format.getName(), VideoFormat.getVp8Name()) || Global.equals(format.getName(), VideoFormat.getVp9Name()) || Global.equals(format.getName(), VideoFormat.getH264Name()) || Global.equals(format.getName(), MediaFormat.getRedName()) || Global.equals(format.getName(), MediaFormat.getUlpFecName()))) {
            throw new RuntimeException(new Exception(StringExtensions.concat("Unsupported video format '", format.getName(), "'.")));
        }
        return new int[1];
    }

    public int getHeight() {
        return this.__height;
    }

    public boolean getIsAbgr() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsAbgr();
    }

    public boolean getIsArgb() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsArgb();
    }

    public boolean getIsBgr() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsBgr();
    }

    public boolean getIsBgra() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsBgra();
    }

    public boolean getIsH264() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsH264();
    }

    public boolean getIsI420() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsI420();
    }

    public boolean getIsKeyFrame() {
        if (((VideoFormat)super.getFormat()).getIsVp8() || ((VideoFormat)super.getFormat()).getIsVp9() || ((VideoFormat)super.getFormat()).getIsH264()) {
            DataBuffer dataBuffer = super.getDataBuffer();
            if (dataBuffer == null) {
                return false;
            }
            if (((VideoFormat)super.getFormat()).getIsPacketized()) {
                VideoFragment fragment = null;
                if (((VideoFormat)super.getFormat()).getIsVp8()) {
                    fragment = new fm.icelink.vp8.Fragment(super.getRtpHeader(), dataBuffer);
                } else if (((VideoFormat)super.getFormat()).getIsVp9()) {
                    fragment = new fm.icelink.vp9.Fragment(super.getRtpHeader(), dataBuffer);
                } else if (((VideoFormat)super.getFormat()).getIsH264()) {
                    fragment = new Fragment(super.getRtpHeader(), dataBuffer);
                }
                dataBuffer = fragment.getBuffer();
            }
            if (((VideoFormat)super.getFormat()).getIsVp8()) {
                return Utility.isKeyFrame(dataBuffer);
            }
            if (((VideoFormat)super.getFormat()).getIsVp9()) {
                return fm.icelink.vp9.Utility.isKeyFrame(dataBuffer);
            }
            if (((VideoFormat)super.getFormat()).getIsH264()) {
                return fm.icelink.h264.Utility.isKeyFrame(dataBuffer);
            }
        }
        return true;
    }

    @Override
    public boolean getIsMuted() {
        return this.__isMuted;
    }

    public boolean getIsNv12() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsNv12();
    }

    public boolean getIsNv21() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsNv21();
    }

    public boolean getIsRaw() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsRaw();
    }

    public boolean getIsRgb() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsRgb();
    }

    public boolean getIsRgba() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsRgba();
    }

    public boolean getIsRgbaType() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsRgbaType();
    }

    public boolean getIsRgbType() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsRgbType();
    }

    public boolean getIsVp8() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsVp8();
    }

    public boolean getIsVp9() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsVp9();
    }

    public boolean getIsYuvType() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsYuvType();
    }

    public boolean getIsYv12() {
        VideoFormat format = (VideoFormat)super.getFormat();
        return format != null && format.getIsYv12();
    }

    public static int getMinimumBufferLength(int width, int height, String formatName) {
        int num = width * height;
        if (Global.equals(formatName, VideoFormat.getBgrName()) || Global.equals(formatName, VideoFormat.getRgbName())) {
            return num * 3;
        }
        if (Global.equals(formatName, VideoFormat.getBgraName()) || Global.equals(formatName, VideoFormat.getRgbaName()) || Global.equals(formatName, VideoFormat.getAbgrName()) || Global.equals(formatName, VideoFormat.getArgbName())) {
            return num * 4;
        }
        if (Global.equals(formatName, VideoFormat.getNv12Name()) || Global.equals(formatName, VideoFormat.getNv21Name()) || Global.equals(formatName, VideoFormat.getI420Name()) || Global.equals(formatName, VideoFormat.getYv12Name())) {
            return (int)((double)num * 1.5);
        }
        Log.error(StringExtensions.format("Could not get minimum buffer length. Format '{0}' is not supported.", formatName));
        return -1;
    }

    public int getOrientation() {
        return this.__orientation;
    }

    public int getStride() {
        int[] strides = this.getStrides();
        if (strides == null) {
            return 0;
        }
        return strides[0];
    }

    public int[] getStrides() {
        return this._strides;
    }

    public int getWidth() {
        return this.__width;
    }

    @Override
    public boolean mute() {
        if (!this.__isMuted) {
            if (((VideoFormat)super.getFormat()).getIsRgbType()) {
                super.getDataBuffer().set((byte)0);
            } else if (((VideoFormat)super.getFormat()).getIsRgbaType()) {
                DataBuffer dataBuffer = super.getDataBuffer();
                int num = 1;
                int num2 = 0;
                if (((VideoFormat)super.getFormat()).getIsBgra() || ((VideoFormat)super.getFormat()).getIsRgba()) {
                    num = 0;
                    num2 = 3;
                }
                for (int num3 = 0; num3 < dataBuffer.getLength(); num3 += 4) {
                    dataBuffer.set((byte)0, num3 + num, 3);
                    dataBuffer.set(BitAssistant.castByte(255), num3 + num2, 1);
                }
            } else if (((VideoFormat)super.getFormat()).getIsYuvType()) {
                Object[] dataBuffers = super.getDataBuffers();
                if (ArrayExtensions.getLength(dataBuffers) == 1) {
                    int length = this.getWidth() * this.getHeight();
                    Object dataBuffer = dataBuffers[0];
                    ((DataBuffer)dataBuffer).set((byte)0, 0, length);
                    ((DataBuffer)dataBuffer).set(BitAssistant.castByte(128), length);
                } else {
                    ((DataBuffer)dataBuffers[0]).set((byte)0);
                    for (int num3 = 1; num3 < ArrayExtensions.getLength(dataBuffers); ++num3) {
                        ((DataBuffer)dataBuffers[num3]).set(BitAssistant.castByte(128));
                    }
                }
            } else {
                return false;
            }
            this.__isMuted = true;
        }
        return true;
    }

    private void read(Holder<int[]> rValues, Holder<int[]> gValues, Holder<int[]> bValues, Holder<int[]> aValues) {
        block45: {
            int num;
            block48: {
                int stride;
                DataBuffer dataBuffer;
                int num4;
                int num3;
                int num2;
                block49: {
                    block43: {
                        int stride2;
                        DataBuffer dataBuffer2;
                        int num42;
                        int num32;
                        int num22;
                        block47: {
                            block46: {
                                block44: {
                                    num = this.getWidth() * this.getHeight();
                                    rValues.setValue(new int[num]);
                                    gValues.setValue(new int[num]);
                                    bValues.setValue(new int[num]);
                                    aValues.setValue(new int[num]);
                                    if (!((VideoFormat)super.getFormat()).getIsRgbaType()) break block43;
                                    num22 = 0;
                                    num32 = this.getWidth() * 4;
                                    num42 = 0;
                                    dataBuffer2 = super.getDataBuffer();
                                    stride2 = this.getStride();
                                    if (stride2 == 0) {
                                        stride2 = num32;
                                    }
                                    if (!((VideoFormat)super.getFormat()).getIsRgba()) break block44;
                                    for (int num6 = 0; num6 < this.getHeight(); ++num6) {
                                        for (int num7 = 0; num7 < this.getWidth(); ++num7) {
                                            rValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                            gValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                            bValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                            aValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                            ++num22;
                                        }
                                        num42 += stride2 - num32;
                                    }
                                    break block45;
                                }
                                if (!((VideoFormat)super.getFormat()).getIsBgra()) break block46;
                                for (int num6 = 0; num6 < this.getHeight(); ++num6) {
                                    for (int num7 = 0; num7 < this.getWidth(); ++num7) {
                                        bValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                        gValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                        rValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                        aValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                        ++num22;
                                    }
                                    num42 += stride2 - num32;
                                }
                                break block45;
                            }
                            if (!((VideoFormat)super.getFormat()).getIsArgb()) break block47;
                            for (int num6 = 0; num6 < this.getHeight(); ++num6) {
                                for (int num7 = 0; num7 < this.getWidth(); ++num7) {
                                    aValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                    rValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                    gValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                    bValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                    ++num22;
                                }
                                num42 += stride2 - num32;
                            }
                            break block45;
                        }
                        if (!((VideoFormat)super.getFormat()).getIsAbgr()) break block45;
                        for (int num6 = 0; num6 < this.getHeight(); ++num6) {
                            for (int num7 = 0; num7 < this.getWidth(); ++num7) {
                                aValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                bValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                gValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                rValues.getValue()[num22] = dataBuffer2.read8(num42++);
                                ++num22;
                            }
                            num42 += stride2 - num32;
                        }
                        break block45;
                    }
                    if (!((VideoFormat)super.getFormat()).getIsRgbType()) break block48;
                    num2 = 0;
                    num3 = this.getWidth() * 3;
                    num4 = 0;
                    dataBuffer = super.getDataBuffer();
                    stride = this.getStride();
                    if (stride == 0) {
                        stride = num3;
                    }
                    if (!((VideoFormat)super.getFormat()).getIsRgb()) break block49;
                    for (int num6 = 0; num6 < this.getHeight(); ++num6) {
                        for (int num7 = 0; num7 < this.getWidth(); ++num7) {
                            rValues.getValue()[num2] = dataBuffer.read8(num4++);
                            gValues.getValue()[num2] = dataBuffer.read8(num4++);
                            bValues.getValue()[num2] = dataBuffer.read8(num4++);
                            aValues.getValue()[num2] = 255;
                            ++num2;
                        }
                        num4 += stride - num3;
                    }
                    break block45;
                }
                if (!((VideoFormat)super.getFormat()).getIsBgr()) break block45;
                for (int num6 = 0; num6 < this.getHeight(); ++num6) {
                    for (int num7 = 0; num7 < this.getWidth(); ++num7) {
                        bValues.getValue()[num2] = dataBuffer.read8(num4++);
                        gValues.getValue()[num2] = dataBuffer.read8(num4++);
                        rValues.getValue()[num2] = dataBuffer.read8(num4++);
                        aValues.getValue()[num2] = 255;
                        ++num2;
                    }
                    num4 += stride - num3;
                }
                break block45;
            }
            if (((VideoFormat)super.getFormat()).getIsYuvType()) {
                boolean flag;
                int num7;
                int num6;
                int[] numArray = new int[num];
                int[] numArray2 = new int[num / 4];
                int[] numArray3 = new int[num / 4];
                int num8 = 0;
                int num9 = 0;
                int num10 = 0;
                int width = this.getWidth();
                int num12 = 0;
                DataBuffer buffer2 = super.getDataBuffers()[0];
                int num13 = this.getStrides()[0];
                if (num13 == 0) {
                    num13 = width;
                }
                for (num6 = 0; num6 < this.getHeight(); ++num6) {
                    for (num7 = 0; num7 < this.getWidth(); ++num7) {
                        numArray[num8++] = buffer2.read8(num12++);
                    }
                    num12 += num13 - width;
                }
                boolean bl = flag = ArrayExtensions.getLength(super.getDataBuffers()) == 1;
                if (((VideoFormat)super.getFormat()).getIsI420() || ((VideoFormat)super.getFormat()).getIsYv12()) {
                    int num19;
                    int num18;
                    DataBuffer buffer4;
                    DataBuffer buffer3;
                    int num14 = this.getWidth() / 2;
                    int num15 = this.getWidth() / 2;
                    int num16 = 0;
                    int num17 = 0;
                    if (flag) {
                        buffer3 = super.getDataBuffers()[0];
                        buffer4 = super.getDataBuffers()[0];
                        num18 = this.getStrides()[0] / 2;
                        num19 = this.getStrides()[0] / 2;
                    } else {
                        buffer3 = super.getDataBuffers()[1];
                        buffer4 = super.getDataBuffers()[2];
                        num18 = this.getStrides()[1];
                        num19 = this.getStrides()[2];
                    }
                    if (num18 == 0) {
                        num18 = num14;
                    }
                    if (num19 == 0) {
                        num19 = num15;
                    }
                    if (flag) {
                        if (((VideoFormat)super.getFormat()).getIsI420()) {
                            num16 = num13 * this.getHeight();
                            num17 = num16 + num18 * this.getHeight() / 2;
                        } else {
                            num17 = num13 * this.getHeight();
                            num16 = num17 + num19 * this.getHeight() / 2;
                        }
                    }
                    for (num6 = 0; num6 < this.getHeight() / 2; ++num6) {
                        for (num7 = 0; num7 < this.getWidth() / 2; ++num7) {
                            numArray2[num9++] = buffer3.read8(num16++);
                            numArray3[num10++] = buffer4.read8(num17++);
                        }
                        num16 += num18 - num14;
                        num17 += num19 - num15;
                    }
                } else if (((VideoFormat)super.getFormat()).getIsNv12() || ((VideoFormat)super.getFormat()).getIsNv21()) {
                    int num22;
                    DataBuffer buffer5;
                    int num20 = this.getWidth();
                    int num21 = 0;
                    if (flag) {
                        buffer5 = super.getDataBuffers()[0];
                        num22 = this.getStrides()[0];
                    } else {
                        buffer5 = super.getDataBuffers()[1];
                        num22 = this.getStrides()[1];
                    }
                    if (num22 == 0) {
                        num22 = num20;
                    }
                    if (flag) {
                        num21 = num13 * this.getHeight();
                    }
                    if (((VideoFormat)super.getFormat()).getIsNv12()) {
                        for (num6 = 0; num6 < this.getHeight() / 2; ++num6) {
                            for (num7 = 0; num7 < this.getWidth() / 2; ++num7) {
                                numArray2[num9++] = buffer5.read8(num21++);
                                numArray3[num10++] = buffer5.read8(num21++);
                            }
                            num21 += num22 - num20;
                        }
                    } else {
                        for (num6 = 0; num6 < this.getHeight() / 2; ++num6) {
                            for (num7 = 0; num7 < this.getWidth() / 2; ++num7) {
                                numArray3[num10++] = buffer5.read8(num21++);
                                numArray2[num9++] = buffer5.read8(num21++);
                            }
                            num21 += num22 - num20;
                        }
                    }
                }
                int num23 = 0;
                int index = 0;
                int num25 = 0;
                int num2 = 0;
                for (num6 = 0; num6 < this.getHeight(); ++num6) {
                    for (num7 = 0; num7 < this.getWidth(); ++num7) {
                        int num26 = numArray[num23++];
                        int num27 = numArray2[index];
                        int num28 = numArray3[num25];
                        if (num7 % 2 == 1) {
                            ++index;
                            ++num25;
                        }
                        int num29 = MathAssistant.min(255, MathAssistant.max(0, (int)(1.164 * (double)(num26 - 16) + 2.018 * (double)(num27 - 128))));
                        int num30 = MathAssistant.min(255, MathAssistant.max(0, (int)(1.164 * (double)(num26 - 16) - 0.813 * (double)(num28 - 128) - 0.391 * (double)(num27 - 128))));
                        int num31 = MathAssistant.min(255, MathAssistant.max(0, (int)(1.164 * (double)(num26 - 16) + 1.596 * (double)(num28 - 128))));
                        rValues.getValue()[num2] = BitAssistant.castInteger(BitAssistant.castByte(num31));
                        gValues.getValue()[num2] = BitAssistant.castInteger(BitAssistant.castByte(num30));
                        bValues.getValue()[num2] = BitAssistant.castInteger(BitAssistant.castByte(num29));
                        aValues.getValue()[num2] = 255;
                        ++num2;
                    }
                    if (num6 % 2 != 0) continue;
                    index -= this.getWidth() / 2;
                    num25 -= this.getWidth() / 2;
                }
            }
        }
    }

    public void setHeight(int value) {
        if (value != -1 && value % 2 > 0) {
            --value;
        }
        this.__height = value;
    }

    void setIsMuted(boolean value) {
        this.__isMuted = value;
    }

    public void setOrientation(int value) {
        if (value != 0 && value != 90 && value != 180 && value != 270) {
            throw new RuntimeException(new Exception("Video orientation can only be 0, 90, 180 or 270."));
        }
        this.__orientation = value;
    }

    public void setStride(int value) {
        this.setStrides(new int[]{value});
    }

    public void setStrides(int[] value) {
        this._strides = value;
    }

    public void setWidth(int value) {
        if (value != -1 && value % 2 > 0) {
            --value;
        }
        this.__width = value;
    }

    public String toJson() {
        return VideoBuffer.toJson(this);
    }

    public static String toJson(final VideoBuffer videoBuffer) {
        return JsonSerializer.serializeObject(videoBuffer, new IAction2<VideoBuffer, HashMap<String, String>>(){

            @Override
            public void invoke(VideoBuffer obj, HashMap<String, String> jsonObject) {
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "width", JsonSerializer.serializeInteger(new NullableInteger(videoBuffer.getWidth())));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "height", JsonSerializer.serializeInteger(new NullableInteger(videoBuffer.getHeight())));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "strides", JsonSerializer.serializeIntegerArray(videoBuffer.getStrides()));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "orientation", JsonSerializer.serializeInteger(new NullableInteger(videoBuffer.getOrientation())));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "isMuted", JsonSerializer.serializeBoolean(new NullableBoolean(videoBuffer.getIsMuted())));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "dataBuffers", DataBuffer.toJsonArray(videoBuffer.getDataBuffers()));
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "format", VideoFormat.toJson((VideoFormat)videoBuffer.getFormat()));
            }
        });
    }

    public static String toJsonArray(VideoBuffer[] videoBuffers) {
        return JsonSerializer.serializeObjectArray(videoBuffers, new IFunctionDelegate1<VideoBuffer, String>(){

            @Override
            public String getId() {
                return "fm.icelink.VideoBuffer.toJson";
            }

            @Override
            public String invoke(VideoBuffer videoBuffer) {
                return VideoBuffer.toJson(videoBuffer);
            }
        });
    }

    public VideoBuffer toPlanar() {
        if (!this.getIsYuvType() || ArrayExtensions.getLength(super.getDataBuffers()) > 1) {
            return this;
        }
        VideoBuffer buffer = this.clone();
        DataBuffer dataBuffer = buffer.getDataBuffer();
        int stride = buffer.getStride();
        if (buffer.getIsI420() || buffer.getIsYv12()) {
            int num2 = stride;
            int num3 = stride / 2;
            int num4 = stride / 2;
            int num5 = stride * buffer.getHeight();
            int num6 = num5 / 4;
            int num7 = num5 / 4;
            int num8 = 0;
            if (buffer.getIsI420()) {
                int num9 = num5;
                int num10 = num5 + num6;
                buffer.setDataBuffers(new DataBuffer[]{dataBuffer.subset(num8, num5), dataBuffer.subset(num9, num6), dataBuffer.subset(num10, num7)});
                buffer.setStrides(new int[]{num2, num3, num4});
            } else {
                int num10 = num5;
                int num9 = num5 + num7;
                buffer.setDataBuffers(new DataBuffer[]{dataBuffer.subset(num8, num5), dataBuffer.subset(num10, num7), dataBuffer.subset(num9, num6)});
                buffer.setStrides(new int[]{num2, num4, num3});
            }
            return buffer;
        }
        int num2 = stride;
        int num11 = stride;
        int num5 = stride * buffer.getHeight();
        int length = num5 / 2;
        int num8 = 0;
        int offset = num5;
        buffer.setDataBuffers(new DataBuffer[]{dataBuffer.subset(num8, num5), dataBuffer.subset(offset, length)});
        buffer.setStrides(new int[]{num2, num11});
        return buffer;
    }

    public VideoBuffer(int width, int height, DataBuffer dataBuffer, VideoFormat format) {
        super(dataBuffer, format);
        this.setWidth(width);
        this.setHeight(height);
        this.setStrides(this.getDefaultStrides(width, format));
    }

    protected VideoBuffer() {
    }

    public VideoBuffer(int width, int height, DataBuffer[] dataBuffers, VideoFormat format) {
        super(dataBuffers, format);
        this.setWidth(width);
        this.setHeight(height);
        this.setStrides(this.getDefaultStrides(width, format));
    }

    private void write(int[] rValues, int[] gValues, int[] bValues, int[] aValues) {
        block19: {
            int num;
            block22: {
                int num2;
                block23: {
                    block17: {
                        int num22;
                        block21: {
                            block20: {
                                block18: {
                                    num = this.getWidth() * this.getHeight();
                                    if (!((VideoFormat)super.getFormat()).getIsRgbaType()) break block17;
                                    num22 = 0;
                                    if (!((VideoFormat)super.getFormat()).getIsRgba()) break block18;
                                    for (int num3 = 0; num3 < num; ++num3) {
                                        super.getDataBuffer().write8(rValues[num3], num22++);
                                        super.getDataBuffer().write8(gValues[num3], num22++);
                                        super.getDataBuffer().write8(bValues[num3], num22++);
                                        super.getDataBuffer().write8(aValues[num3], num22++);
                                    }
                                    break block19;
                                }
                                if (!((VideoFormat)super.getFormat()).getIsBgra()) break block20;
                                for (int num3 = 0; num3 < num; ++num3) {
                                    super.getDataBuffer().write8(bValues[num3], num22++);
                                    super.getDataBuffer().write8(gValues[num3], num22++);
                                    super.getDataBuffer().write8(rValues[num3], num22++);
                                    super.getDataBuffer().write8(aValues[num3], num22++);
                                }
                                break block19;
                            }
                            if (!((VideoFormat)super.getFormat()).getIsArgb()) break block21;
                            for (int num3 = 0; num3 < num; ++num3) {
                                super.getDataBuffer().write8(aValues[num3], num22++);
                                super.getDataBuffer().write8(rValues[num3], num22++);
                                super.getDataBuffer().write8(gValues[num3], num22++);
                                super.getDataBuffer().write8(bValues[num3], num22++);
                            }
                            break block19;
                        }
                        if (!((VideoFormat)super.getFormat()).getIsAbgr()) break block19;
                        for (int num3 = 0; num3 < num; ++num3) {
                            super.getDataBuffer().write8(aValues[num3], num22++);
                            super.getDataBuffer().write8(bValues[num3], num22++);
                            super.getDataBuffer().write8(gValues[num3], num22++);
                            super.getDataBuffer().write8(rValues[num3], num22++);
                        }
                        break block19;
                    }
                    if (!((VideoFormat)super.getFormat()).getIsRgbType()) break block22;
                    num2 = 0;
                    if (!((VideoFormat)super.getFormat()).getIsRgb()) break block23;
                    for (int num3 = 0; num3 < num; ++num3) {
                        super.getDataBuffer().write8(rValues[num3], num2++);
                        super.getDataBuffer().write8(gValues[num3], num2++);
                        super.getDataBuffer().write8(bValues[num3], num2++);
                    }
                    break block19;
                }
                if (!((VideoFormat)super.getFormat()).getIsBgr()) break block19;
                for (int num3 = 0; num3 < num; ++num3) {
                    super.getDataBuffer().write8(bValues[num3], num2++);
                    super.getDataBuffer().write8(gValues[num3], num2++);
                    super.getDataBuffer().write8(rValues[num3], num2++);
                }
                break block19;
            }
            if (((VideoFormat)super.getFormat()).getIsYuvType()) {
                int num4 = 0;
                int offset = 0;
                int num6 = 0;
                int num7 = 0;
                int num8 = 0;
                if (((VideoFormat)super.getFormat()).getIsI420()) {
                    offset = num;
                    num6 = num + num / 4;
                    num7 = 1;
                    num8 = 1;
                } else if (((VideoFormat)super.getFormat()).getIsYv12()) {
                    offset = num + num / 4;
                    num6 = num;
                    num7 = 1;
                    num8 = 1;
                } else if (((VideoFormat)super.getFormat()).getIsNv12()) {
                    offset = num;
                    num6 = num + 1;
                    num7 = 2;
                    num8 = 2;
                } else if (((VideoFormat)super.getFormat()).getIsNv21()) {
                    offset = num + 1;
                    num6 = num;
                    num7 = 2;
                    num8 = 2;
                }
                int num3 = 0;
                for (int i = 0; i < this.getHeight(); ++i) {
                    boolean flag = i % 2 == 0;
                    for (int j = 0; j < this.getWidth(); ++j) {
                        boolean flag2 = j % 2 == 0;
                        byte num11 = BitAssistant.castByte((int)(0.2569 * (double)rValues[num3] + 0.5044 * (double)gValues[num3] + 0.0979 * (double)bValues[num3] + 16.0));
                        super.getDataBuffer().write8(num11, num4++);
                        if (flag && flag2) {
                            byte num12 = BitAssistant.castByte((int)(-0.1483 * (double)rValues[num3] - 0.2911 * (double)gValues[num3] + 0.4394 * (double)bValues[num3] + 128.0));
                            byte num13 = BitAssistant.castByte((int)(0.4394 * (double)rValues[num3] - 0.3679 * (double)gValues[num3] - 0.0715 * (double)bValues[num3] + 128.0));
                            super.getDataBuffer().write8(num12, offset);
                            super.getDataBuffer().write8(num13, num6);
                            offset += num7;
                            num6 += num8;
                        }
                        ++num3;
                    }
                }
            }
        }
    }
}

