/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.Binary;
import fm.icelink.DoubleExtensions;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IFunction1;
import fm.icelink.LockedRandomizer;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

public class Utility {
    public static <T> ArrayList<T> clone(ArrayList<T> list) {
        ArrayList list2 = new ArrayList();
        ArrayListExtensions.addRange(list2, list);
        return list2;
    }

    public static <T> T firstOrDefault(ArrayList<T> list) {
        if (list == null || ArrayListExtensions.getCount(list) == 0) {
            return null;
        }
        return ArrayListExtensions.getItem(list).get(0);
    }

    public static <T> T firstOrDefault(T[] array) {
        if (array == null || ArrayExtensions.getLength(array) == 0) {
            return null;
        }
        return array[0];
    }

    public static String formatDoubleAsPercent(double value, int decimalPlaces) {
        Object str3;
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        String str = DoubleExtensions.toString(value * 100.0);
        Object[] strArray = StringExtensions.split(str, new char[]{'.'});
        if (ArrayExtensions.getLength(strArray) == 1) {
            str = StringExtensions.concat(str, ".");
            for (int num = 0; num < decimalPlaces; ++num) {
                str = StringExtensions.concat(str, "0");
            }
            return str;
        }
        Object str2 = strArray[0];
        if (StringExtensions.getLength((String)str2) == 0) {
            str2 = "0";
        }
        if (StringExtensions.getLength((String)(str3 = strArray[1])) > decimalPlaces) {
            str3 = StringExtensions.substring((String)str3, 0, decimalPlaces);
        } else if (StringExtensions.getLength((String)str3) < decimalPlaces) {
            int num2 = decimalPlaces - StringExtensions.getLength((String)str3);
            for (int num = 0; num < num2; ++num) {
                str3 = StringExtensions.concat((String)str3, "0");
            }
        }
        return StringExtensions.concat((String)str2, ".", (String)str3);
    }

    public static long generateSynchronizationSource() {
        byte[] buffer = new byte[4];
        LockedRandomizer.nextBytes(buffer);
        return Binary.fromBytes32(buffer, 0, false);
    }

    public static String generateTieBreaker() {
        return Guid.newGuid().toString().replace("-", "");
    }

    public static <T> T lastOrDefault(ArrayList<T> list) {
        if (list == null || ArrayListExtensions.getCount(list) == 0) {
            return null;
        }
        return ArrayListExtensions.getItem(list).get(ArrayListExtensions.getCount(list) - 1);
    }

    public static <T> T lastOrDefault(T[] array) {
        if (array == null || ArrayExtensions.getLength(array) == 0) {
            return null;
        }
        return array[ArrayExtensions.getLength(array) - 1];
    }

    public static <T> ArrayList<T> toList(T[] array) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public static <T> void treeFindLeaves(T root, IFunction1<T, T[]> childrenCallback, IAction1<T> nodeCallback) {
        T[] localArray = childrenCallback.invoke(root);
        if (localArray != null) {
            for (T local : localArray) {
                Utility.treeSearch(local, childrenCallback, nodeCallback);
            }
        } else {
            nodeCallback.invoke(root);
        }
    }

    public static <T> void treeSearch(T root, IFunction1<T, T[]> childrenCallback, IAction1<T> nodeCallback) {
        nodeCallback.invoke(root);
        T[] localArray = childrenCallback.invoke(root);
        if (localArray != null) {
            for (T local : localArray) {
                Utility.treeSearch(local, childrenCallback, nodeCallback);
            }
        }
    }
}

