/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.CircularDataBuffer;
import fm.icelink.DataBuffer;
import fm.icelink.Dynamic;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.Log;
import fm.icelink.ServerAddress;
import fm.icelink.StreamSocket;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;

class TurnTcpConnection
extends Dynamic {
    private Object __lock;
    private CircularDataBuffer __receiveBuffer;
    private TransportAddress _clientAddress;
    private Object _closeLock;
    private String _id;
    private boolean _listening = false;
    private Object _listeningLock = new Object();
    private IAction1<TurnTcpConnection> _onClose;
    private IAction2<TurnTcpConnection, CircularDataBuffer> _onReceive;
    private boolean _raisedClose = false;
    private ServerAddress _serverAddress;
    private StreamSocket _socket;

    public void close() {
        this.getSocket().close();
        this.raiseClose();
    }

    private void doReceive() {
        if (this.getIsClosed()) {
            this.raiseClose();
        } else {
            this.receive();
        }
    }

    public TransportAddress getClientAddress() {
        return this._clientAddress;
    }

    public String getId() {
        return this._id;
    }

    public boolean getIsClosed() {
        return this.getSocket().getIsClosed();
    }

    public IAction1<TurnTcpConnection> getOnClose() {
        return this._onClose;
    }

    public ServerAddress getServerAddress() {
        return this._serverAddress;
    }

    public StreamSocket getSocket() {
        return this._socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBuffer(DataBuffer buffer) {
        Object object = this.__lock;
        synchronized (object) {
            this.__receiveBuffer.appendDataBuffer(buffer);
            this._onReceive.invoke(this, this.__receiveBuffer);
        }
        if (this.getIsClosed()) {
            this.raiseClose();
        }
    }

    void processReceiveFailure(Exception exception, boolean timedOut) {
        if (this.getIsClosed()) {
            this.raiseClose();
        } else {
            this.doReceive();
        }
    }

    void processReceiveSuccess(DataBuffer buffer) {
        try {
            this.processBuffer(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getIsClosed()) {
            this.raiseClose();
        } else {
            this.doReceive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean raiseClose() {
        Object object = this._closeLock;
        synchronized (object) {
            if (this._raisedClose) {
                return false;
            }
            this._raisedClose = true;
        }
        IAction1<TurnTcpConnection> onClose = this.getOnClose();
        if (onClose != null) {
            onClose.invoke(this);
        }
        return true;
    }

    private void receive() {
        try {
            this.getSocket().receiveAsync(0);
        }
        catch (Exception exception) {
            if (Log.getIsDebugEnabled()) {
                Log.debug(StringExtensions.format("Could not receive on server TCP socket. {0}", exception.getMessage()));
            }
            this.getSocket().close();
            this.raiseClose();
        }
    }

    private void setClientAddress(TransportAddress value) {
        this._clientAddress = value;
    }

    private void setId(String value) {
        this._id = value;
    }

    public void setOnClose(IAction1<TurnTcpConnection> value) {
        this._onClose = value;
    }

    private void setServerAddress(ServerAddress value) {
        this._serverAddress = value;
    }

    private void setSocket(StreamSocket value) {
        this._socket = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        Object object = this._listeningLock;
        synchronized (object) {
            if (this._listening) {
                return;
            }
            this._listening = true;
        }
        this.doReceive();
    }

    public TurnTcpConnection(StreamSocket socket, IAction2<TurnTcpConnection, CircularDataBuffer> onReceive) {
        this.__receiveBuffer = CircularDataBuffer.create(2048);
        this.__lock = new Object();
        this._closeLock = new Object();
        this.setSocket(socket);
        this.getSocket().setOnReceiveSuccess((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.TurnTcpConnection.processReceiveSuccess";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                TurnTcpConnection.this.processReceiveSuccess(buffer);
            }
        });
        this.getSocket().setOnReceiveFailure((IAction2<Exception, Boolean>)new IActionDelegate2<Exception, Boolean>(){

            @Override
            public String getId() {
                return "fm.icelink.TurnTcpConnection.processReceiveFailure";
            }

            @Override
            public void invoke(Exception exception, Boolean timedOut) {
                TurnTcpConnection.this.processReceiveFailure(exception, timedOut);
            }
        });
        this._onReceive = onReceive;
        this.setClientAddress(new TransportAddress(socket.getRemoteIPAddress(), socket.getRemotePort()));
        this.setServerAddress(new ServerAddress(socket.getLocalIPAddress(), socket.getLocalPort(), socket.getPublicIPAddress()));
        this.setId(StringExtensions.concat(this.getClientAddress().toString(), "|", this.getServerAddress().toString()));
    }
}

