/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AddressType;
import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.LocalNetwork;
import fm.icelink.Log;
import fm.icelink.StringExtensions;

public class TransportAddress {
    private String _ipAddress;
    private static String[] _masks = new String[]{"0.0.0.0", "128.0.0.0", "192.0.0.0", "224.0.0.0", "240.0.0.0", "248.0.0.0", "252.0.0.0", "254.0.0.0", "255.0.0.0", "255.128.0.0", "255.192.0.0", "255.224.0.0", "255.240.0.0", "255.248.0.0", "255.252.0.0", "255.254.0.0", "255.255.0.0", "255.255.128.0", "255.255.192.0", "255.255.224.0", "255.255.240.0", "255.255.248.0", "255.255.252.0", "255.255.254.0", "255.255.255.0", "255.255.255.128", "255.255.255.192", "255.255.255.224", "255.255.255.240", "255.255.255.248", "255.255.255.252", "255.255.255.254", "255.255.255.255"};
    private int _port;

    public static boolean checkMask(String address1, String address2, String mask) {
        try {
            if (address1 == null || address2 == null || mask == null) {
                return false;
            }
            byte[] addressBytes = LocalNetwork.getAddressBytes(address1);
            byte[] buffer2 = LocalNetwork.getAddressBytes(address2);
            byte[] buffer3 = LocalNetwork.getAddressBytes(mask);
            if (addressBytes == null || buffer2 == null || buffer3 == null || ArrayExtensions.getLength(addressBytes) != ArrayExtensions.getLength(buffer3) || ArrayExtensions.getLength(buffer2) != ArrayExtensions.getLength(buffer3)) {
                return false;
            }
            for (int i = 0; i < ArrayExtensions.getLength(buffer3); ++i) {
                byte num2 = buffer3[i];
                int num3 = addressBytes[i] & num2;
                int num4 = buffer2[i] & num2;
                if (num3 == num4) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception1) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        TransportAddress address = Global.tryCast(obj, TransportAddress.class);
        if (address == null) {
            return false;
        }
        if (this.getIPAddress() == null) {
            return address.getIPAddress() == null && address.getPort() == this.getPort();
        }
        return Global.equals(address.getIPAddress(), this.getIPAddress()) && address.getPort() == this.getPort();
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }

    public int hashCode() {
        int num = 17;
        if (this.getIPAddress() != null) {
            num = num * 23 + this.getIPAddress().hashCode();
        }
        return num * 23 + new Integer(this.getPort()).hashCode();
    }

    public static boolean isAny(String ipAddress) {
        boolean flag = true;
        try {
            byte[] addressBytes = LocalNetwork.getAddressBytes(ipAddress);
            for (int i = 0; i < ArrayExtensions.getLength(addressBytes); ++i) {
                if (BitAssistant.castInteger(addressBytes[i]) == 0) continue;
                return false;
            }
        }
        catch (Exception exception1) {
            flag = false;
        }
        return flag;
    }

    public static boolean isIPAddress(String address) {
        AddressType addressType = LocalNetwork.getAddressType(address);
        return Global.equals((Object)addressType, (Object)AddressType.IPv4) || Global.equals((Object)addressType, (Object)AddressType.IPv6);
    }

    public static boolean isLinkLocal(String ipAddress) {
        try {
            byte[] addressBytes = LocalNetwork.getAddressBytes(ipAddress);
            if (ArrayExtensions.getLength(addressBytes) == 16) {
                boolean flag = BitAssistant.castInteger(addressBytes[0]) == 254 && BitAssistant.castInteger(addressBytes[1]) == 128;
                for (int i = 2; i < 8; ++i) {
                    flag = flag && BitAssistant.castInteger(addressBytes[i]) == 0;
                }
                return flag;
            }
            return BitAssistant.castInteger(addressBytes[0]) == 169 && BitAssistant.castInteger(addressBytes[1]) == 254;
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("Error parsing IP address '{0}'; could not determine if it is a link-local address.", ipAddress), exception);
            return false;
        }
    }

    public static boolean isLoopback(String ipAddress) {
        try {
            byte[] addressBytes = LocalNetwork.getAddressBytes(ipAddress);
            if (ArrayExtensions.getLength(addressBytes) == 16) {
                boolean flag = BitAssistant.castInteger(addressBytes[15]) == 1;
                for (int i = 0; i < 15; ++i) {
                    flag = flag && BitAssistant.castInteger(addressBytes[i]) == 0;
                }
                return flag;
            }
            return BitAssistant.castInteger(addressBytes[0]) == 127;
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("Error parsing IP address '{0}'; could not determine if it is a loopback address.", ipAddress), exception);
            return false;
        }
    }

    public static boolean isPrivate(String ipAddress) {
        try {
            byte[] addressBytes = LocalNetwork.getAddressBytes(ipAddress);
            if (ArrayExtensions.getLength(addressBytes) == 16) {
                return (BitAssistant.castInteger(addressBytes[0]) & 0xFC) == 252 && (BitAssistant.castInteger(addressBytes[0]) & 0xFD) == 253;
            }
            return BitAssistant.castInteger(addressBytes[0]) == 10 || BitAssistant.castInteger(addressBytes[0]) == 172 && BitAssistant.castInteger(addressBytes[1]) >= 16 && BitAssistant.castInteger(addressBytes[1]) <= 31 || BitAssistant.castInteger(addressBytes[0]) == 192 && BitAssistant.castInteger(addressBytes[1]) == 168;
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("Error parsing IP address '{0}'; could not determine if it is a private address.", ipAddress), exception);
            return false;
        }
    }

    public static boolean isReserved(String ipAddress) {
        try {
            byte[] addressBytes = LocalNetwork.getAddressBytes(ipAddress);
            if (ArrayExtensions.getLength(addressBytes) == 16) {
                int num = BitAssistant.castInteger(addressBytes[3]);
                return BitAssistant.castInteger(addressBytes[0]) == 32 && BitAssistant.castInteger(addressBytes[1]) == 1 && (BitAssistant.castInteger(addressBytes[2]) == 0 || num == 1 && num <= 248);
            }
            return false;
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("Error parsing IP address '{0}'; could not determine if it is a reserved address.", ipAddress), exception);
            return false;
        }
    }

    public static String maskFromPrefixLength(int prefixLength) {
        if (prefixLength >= ArrayExtensions.getLength(_masks) || prefixLength < 0) {
            return null;
        }
        return _masks[prefixLength];
    }

    public static String sanitizeIPAddress(String ipAddress) {
        if (!StringExtensions.isNullOrEmpty(ipAddress)) {
            int length;
            while (ipAddress.startsWith("/")) {
                ipAddress = ipAddress.substring(1);
            }
            int index = StringExtensions.indexOf(ipAddress, "/");
            if (index >= 0) {
                ipAddress = StringExtensions.substring(ipAddress, 0, index);
            }
            if ((length = StringExtensions.indexOf(ipAddress, "%")) >= 0) {
                ipAddress = StringExtensions.substring(ipAddress, 0, length);
            }
        }
        return ipAddress;
    }

    private void setIPAddress(String value) {
        this._ipAddress = value;
    }

    private void setPort(int value) {
        this._port = value;
    }

    public String toString() {
        if (Global.equals((Object)LocalNetwork.getAddressType(this.getIPAddress()), (Object)AddressType.IPv4)) {
            return StringExtensions.format("{0}:{1}", this.getIPAddress(), IntegerExtensions.toString(this.getPort()));
        }
        return StringExtensions.format("[{0}]:{1}", this.getIPAddress(), IntegerExtensions.toString(this.getPort()));
    }

    public TransportAddress(String ipAddress, int port) {
        this.setIPAddress(TransportAddress.sanitizeIPAddress(ipAddress));
        this.setPort(port);
    }
}

