/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AsymmetricKey;
import fm.icelink.AsymmetricKeyType;
import fm.icelink.Certificate;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.TlsFingerprint;
import java.util.Date;

public class TlsCertificate
extends Certificate<TlsCertificate, TlsFingerprint> {
    private static AsymmetricKeyType __defaultKeyType = AsymmetricKeyType.Rsa;

    @Override
    protected TlsCertificate createCertificate() {
        return new TlsCertificate();
    }

    @Override
    protected TlsFingerprint createFingerprint(String algorithm, String value) {
        if (Log.getIsDebugEnabled()) {
            Log.debug(StringExtensions.format("Calculated TLS certificate fingerprint {0} for algorithm {1}.", value.toString(), algorithm));
        }
        return new TlsFingerprint(algorithm, value.toString());
    }

    public static TlsCertificate generateCertificate(String name, AsymmetricKeyType keyType) {
        return TlsCertificate.generateCertificate(name, AsymmetricKey.createKey(keyType));
    }

    public static TlsCertificate generateCertificate(String issuerName, String subjectName, Date expirationDate) {
        return TlsCertificate.generateCertificate(issuerName, subjectName, expirationDate, TlsCertificate.getDefaultKeyType());
    }

    public static TlsCertificate generateCertificate(AsymmetricKey key) {
        return Certificate.generateCertificate(key, new TlsCertificate());
    }

    public static TlsCertificate generateCertificate(String name, AsymmetricKey key) {
        return Certificate.generateCertificate(name, key, new TlsCertificate());
    }

    public static TlsCertificate generateCertificate(String issuerName, String subjectName, AsymmetricKey key) {
        return Certificate.generateCertificate(issuerName, subjectName, key, new TlsCertificate());
    }

    public static TlsCertificate generateCertificate(String issuerName, String subjectName, AsymmetricKeyType keyType) {
        return TlsCertificate.generateCertificate(issuerName, subjectName, AsymmetricKey.createKey(keyType));
    }

    public static TlsCertificate generateCertificate(String issuerName, String subjectName) {
        return TlsCertificate.generateCertificate(issuerName, subjectName, TlsCertificate.getDefaultKeyType());
    }

    public static TlsCertificate generateCertificate(String name) {
        return TlsCertificate.generateCertificate(name, TlsCertificate.getDefaultKeyType());
    }

    public static TlsCertificate generateCertificate(String issuerName, String subjectName, Date expirationDate, AsymmetricKeyType keyType) {
        return TlsCertificate.generateCertificate(issuerName, subjectName, expirationDate, AsymmetricKey.createKey(keyType));
    }

    public static TlsCertificate generateCertificate(String issuerName, String subjectName, Date expirationDate, AsymmetricKey key) {
        return Certificate.generateCertificate(issuerName, subjectName, expirationDate, key, new TlsCertificate());
    }

    public static TlsCertificate generateCertificate(AsymmetricKeyType keyType) {
        return TlsCertificate.generateCertificate(AsymmetricKey.createKey(keyType));
    }

    public static TlsCertificate generateCertificate() {
        return TlsCertificate.generateCertificate(TlsCertificate.getDefaultKeyType());
    }

    public static TlsCertificate generateCertificateFromOldCertificate(TlsCertificate oldCertificate) {
        return Certificate.generateCertificateFromOldCertificate(oldCertificate, new TlsCertificate());
    }

    public static TlsCertificate generateCertificateFromOldCertificate(TlsCertificate oldCertificate, Date expirationDate) {
        return Certificate.generateCertificateFromOldCertificate(oldCertificate, expirationDate, new TlsCertificate());
    }

    public static AsymmetricKeyType getDefaultKeyType() {
        return __defaultKeyType;
    }

    public static TlsCertificate parseBytes(byte[] bytes) {
        return Certificate.parseBytes(bytes, new TlsCertificate());
    }

    public static void setDefaultKeyType(AsymmetricKeyType value) {
        __defaultKeyType = value;
    }
}

