/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.StreamDirection;

public class StreamDirectionHelper {
    public static StreamDirection directionFromString(String directionString) {
        String _var0 = directionString;
        if (_var0.equals("sendrecv")) {
            return StreamDirection.SendReceive;
        }
        if (_var0.equals("sendonly")) {
            return StreamDirection.SendOnly;
        }
        if (_var0.equals("recvonly")) {
            return StreamDirection.ReceiveOnly;
        }
        if (_var0.equals("inactive")) {
            return StreamDirection.Inactive;
        }
        return StreamDirection.Unset;
    }

    public static String directionToString(StreamDirection direction) {
        StreamDirection _var0 = direction;
        if (_var0 == StreamDirection.SendReceive) {
            return "sendrecv";
        }
        if (_var0 == StreamDirection.SendOnly) {
            return "sendonly";
        }
        if (_var0 == StreamDirection.ReceiveOnly) {
            return "recvonly";
        }
        if (_var0 == StreamDirection.Inactive) {
            return "inactive";
        }
        return "unset";
    }

    static boolean isReceiveDisabled(StreamDirection direction) {
        return Global.equals((Object)direction, (Object)StreamDirection.Inactive) || Global.equals((Object)direction, (Object)StreamDirection.SendOnly);
    }

    static boolean isReceiveDisabled(String stringDirection) {
        return Global.equals(stringDirection, "inactive") || Global.equals(stringDirection, "sendonly");
    }

    static boolean isSendDisabled(StreamDirection direction) {
        return Global.equals((Object)direction, (Object)StreamDirection.Inactive) || Global.equals((Object)direction, (Object)StreamDirection.ReceiveOnly);
    }

    static boolean isSendDisabled(String stringDirection) {
        return Global.equals(stringDirection, "inactive") || Global.equals(stringDirection, "recvonly");
    }

    static String setReceiveDisable(String stringDirection, boolean disabled) {
        StreamDirection direction = StreamDirectionHelper.directionFromString(stringDirection);
        if (disabled) {
            return StreamDirectionHelper.isReceiveDisabled(direction) ? stringDirection : StreamDirectionHelper.directionToString(StreamDirectionHelper.toggleReceive(direction));
        }
        return StreamDirectionHelper.isReceiveDisabled(direction) ? StreamDirectionHelper.directionToString(StreamDirectionHelper.toggleReceive(direction)) : stringDirection;
    }

    static String setSendDisable(String stringDirection, boolean disabled) {
        StreamDirection direction = StreamDirectionHelper.directionFromString(stringDirection);
        if (disabled) {
            return StreamDirectionHelper.isSendDisabled(direction) ? stringDirection : StreamDirectionHelper.directionToString(StreamDirectionHelper.toggleSend(direction));
        }
        return StreamDirectionHelper.isSendDisabled(direction) ? StreamDirectionHelper.directionToString(StreamDirectionHelper.toggleSend(direction)) : stringDirection;
    }

    static StreamDirection toggleReceive(StreamDirection direction) {
        if (Global.equals((Object)direction, (Object)StreamDirection.Inactive)) {
            return StreamDirection.ReceiveOnly;
        }
        if (Global.equals((Object)direction, (Object)StreamDirection.ReceiveOnly)) {
            return StreamDirection.Inactive;
        }
        if (Global.equals((Object)direction, (Object)StreamDirection.SendReceive)) {
            return StreamDirection.SendOnly;
        }
        if (Global.equals((Object)direction, (Object)StreamDirection.SendOnly)) {
            return StreamDirection.SendReceive;
        }
        return StreamDirection.Unset;
    }

    static StreamDirection toggleSend(StreamDirection direction) {
        if (Global.equals((Object)direction, (Object)StreamDirection.Inactive)) {
            return StreamDirection.SendOnly;
        }
        if (Global.equals((Object)direction, (Object)StreamDirection.SendOnly)) {
            return StreamDirection.Inactive;
        }
        if (Global.equals((Object)direction, (Object)StreamDirection.SendReceive)) {
            return StreamDirection.ReceiveOnly;
        }
        if (Global.equals((Object)direction, (Object)StreamDirection.ReceiveOnly)) {
            return StreamDirection.SendReceive;
        }
        return StreamDirection.Unset;
    }
}

