/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.Candidate;
import fm.icelink.CandidateType;
import fm.icelink.CoreTransport;
import fm.icelink.DtlsFingerprint;
import fm.icelink.DtlsParameters;
import fm.icelink.DtlsRole;
import fm.icelink.DtlsTransport;
import fm.icelink.EncryptionMode;
import fm.icelink.EncryptionPolicy;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.HashContextBase;
import fm.icelink.HashType;
import fm.icelink.IAction0;
import fm.icelink.IActionDelegate0;
import fm.icelink.IceCandidate;
import fm.icelink.IceGatherer;
import fm.icelink.IceParameters;
import fm.icelink.IcePolicy;
import fm.icelink.IceRole;
import fm.icelink.Log;
import fm.icelink.ProtocolType;
import fm.icelink.SdesPolicy;
import fm.icelink.StreamBase;
import fm.icelink.StreamDirection;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import fm.icelink.TransportAddress;
import fm.icelink.sdp.ConnectionData;
import fm.icelink.sdp.CryptoAttribute;
import fm.icelink.sdp.CryptoSuite;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.Message;
import fm.icelink.sdp.Setup;
import fm.icelink.sdp.SetupAttribute;
import fm.icelink.sdp.ice.FingerprintAttribute;
import fm.icelink.sdp.ice.PasswordAttribute;
import fm.icelink.sdp.ice.UfragAttribute;
import fm.icelink.sdp.rtp.Media;
import java.util.ArrayList;
import java.util.List;

public abstract class Stream
extends StreamBase {
    private boolean __disabled = false;
    private EncryptionMode[] __encryptionModes;
    private EncryptionPolicy __encryptionPolicy;
    private ArrayList<Candidate> __localCandidates;
    private CryptoAttribute[] __localCryptoAttributes;
    private IceParameters __localIceParameters;
    private Object __localIceParametersLock;
    private List<IAction0> __onDisabledChange = new ArrayList<IAction0>();
    private CryptoAttribute[] __remoteCryptoAttributes;
    private SdesPolicy __sdesPolicy;
    private String _canonicalName;
    private CoreTransport _coreTransportRtcp;
    private CoreTransport _coreTransportRtp;
    private String _defaultIp = "0.0.0.0";
    private IceRole _iceRole;
    private int _index;
    private DtlsParameters _localDtlsParameters;
    private IAction0 _onDisabledChange = null;
    private DtlsParameters _remoteDtlsParameters;
    private IceParameters _remoteIceParameters;
    private boolean _useDtls;
    private boolean _useSdes;

    void addLocalCandidate(Candidate candidate) {
        this.get_LocalCandidates().add(candidate);
    }

    public void addOnDisabledChange(IAction0 value) {
        if (value != null) {
            if (this._onDisabledChange == null) {
                this._onDisabledChange = new IAction0(){

                    @Override
                    public void invoke() {
                        for (IAction0 action : new ArrayList(Stream.this.__onDisabledChange)) {
                            action.invoke();
                        }
                    }
                };
            }
            this.__onDisabledChange.add(value);
        }
    }

    void assignLocalParametersToCoreTransports() {
        for (CoreTransport transport : new CoreTransport[]{this.getCoreTransportRtp(), this.getCoreTransportRtcp()}) {
            if (transport == null) continue;
            IceGatherer gatherer = transport.getGatherer();
            DtlsTransport dtlsTransport = transport.getDtlsTransport();
            if (gatherer != null) {
                gatherer.setLocalParameters(this.getLocalIceParameters());
            }
            if (dtlsTransport == null) continue;
            dtlsTransport.setLocalParameters(this.getLocalDtlsParameters());
        }
    }

    void copyLocalParameters(Stream otherStream) {
        this.setLocalIceParameters(otherStream.getLocalIceParameters());
        this.setLocalDtlsParameters(otherStream.getLocalDtlsParameters());
        this.setRemoteIceParameters(otherStream.getRemoteIceParameters());
        this.setRemoteDtlsParameters(otherStream.getRemoteDtlsParameters());
    }

    public MediaDescription createSdpMediaDescription(Message sdpMessage, boolean supportSdes, boolean isOffer, boolean renegotiation) {
        DtlsFingerprint fingerprint;
        Candidate[] localCandidates;
        fm.icelink.sdp.Media media = new fm.icelink.sdp.Media();
        MediaDescription description = new MediaDescription(media);
        String defaultIp = this._defaultIp;
        int port = 9;
        if (this.getCoreTransportRtp() != null) {
            TransportAddress address = this.obtainLikelyTransportAddress(this.getCoreTransportRtp());
            defaultIp = address.getIPAddress();
            port = address.getPort();
        } else {
            port = 0;
        }
        description.setConnectionData(new ConnectionData(defaultIp));
        boolean useIce = this.getCoreTransportRtp().getIceTransport().getUseIce();
        if (useIce) {
            description.addMediaAttribute(new UfragAttribute(this.getLocalIceParameters().getUsernameFragment()));
            description.addMediaAttribute(new PasswordAttribute(this.getLocalIceParameters().getPassword()));
        }
        description.getMedia().setTransportPort(this.getDisabled() ? 0 : port);
        for (Candidate candidate : localCandidates = this.getLocalCandidates()) {
            candidate.setDispatched(true);
            if (!useIce) continue;
            description.addMediaAttribute(candidate.getSdpCandidateAttribute());
        }
        DtlsFingerprint dtlsFingerprint = fingerprint = this.getLocalDtlsParameters() == null ? null : this.getLocalDtlsParameters().getFingerprint();
        if (this.getUseDtls()) {
            if (fingerprint == null) {
                throw new RuntimeException(new Exception(StringExtensions.format("Cannot create SDP media description for local stream {0}: stream is setup to use DTLS but the DTLS fingerprint has not been set in local DTLS parameters.", super.getId())));
            }
            FingerprintAttribute attribute = new FingerprintAttribute(fingerprint.getAlgorithm(), fingerprint.getValue());
            description.addMediaAttribute(attribute);
            if (Global.equals((Object)this.getLocalDtlsParameters().getRole(), (Object)DtlsRole.Auto) || isOffer && renegotiation) {
                description.addMediaAttribute(new SetupAttribute(Setup.getActPass()));
            } else if (Global.equals((Object)this.getLocalDtlsParameters().getRole(), (Object)DtlsRole.Client)) {
                description.addMediaAttribute(new SetupAttribute(Setup.getActive()));
            } else if (Global.equals((Object)this.getLocalDtlsParameters().getRole(), (Object)DtlsRole.Server)) {
                description.addMediaAttribute(new SetupAttribute(Setup.getPassive()));
            }
        }
        if (supportSdes) {
            this.generateCryptoAttributes();
            for (CryptoAttribute attribute2 : this.getLocalCryptoAttributes()) {
                description.addMediaAttribute(attribute2);
            }
        }
        return description;
    }

    private void enableIceForInternalTransports(boolean enable) {
        this.getCoreTransportRtp().getIceTransport().setUseIce(enable);
        if (this.getCoreTransportRtcp() != null) {
            this.getCoreTransportRtcp().getIceTransport().setUseIce(enable);
        }
    }

    void eraseLocalCandidatesForSecondaryComponent() {
        Candidate[] candidateArray;
        for (Candidate candidate : candidateArray = this.get_LocalCandidates().toArray(new Candidate[0])) {
            if (candidate.getSdpCandidateAttribute().getComponentId() != 2) continue;
            this.get_LocalCandidates().remove(candidate);
        }
    }

    private void generateCryptoAttributes() {
        ArrayList<CryptoAttribute> list = new ArrayList<CryptoAttribute>();
        for (EncryptionMode mode : this.getEncryptionModes()) {
            EncryptionMode _var0 = mode;
            if (_var0 != EncryptionMode.Aes128Strong && _var0 != EncryptionMode.Aes128Weak && _var0 != EncryptionMode.NullStrong && _var0 != EncryptionMode.NullWeak) continue;
            byte[] hexBytes = BitAssistant.getHexBytes(Guid.newGuid().toString().replace("-", ""));
            byte[] salt = BitAssistant.subArray(BitAssistant.getHexBytes(Guid.newGuid().toString().replace("-", "")), 0, 14);
            String cryptoSuite = CryptoSuite.getCryptoSuite(mode);
            list.add(new CryptoAttribute(1, cryptoSuite).setKeySalt(hexBytes, salt));
        }
        this.__localCryptoAttributes = list.toArray(new CryptoAttribute[0]);
    }

    private ArrayList<Candidate> get_LocalCandidates() {
        return this.__localCandidates;
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    CoreTransport getCoreTransportRtcp() {
        return this._coreTransportRtcp;
    }

    CoreTransport getCoreTransportRtp() {
        return this._coreTransportRtp;
    }

    public boolean getDisabled() {
        return this.__disabled;
    }

    public EncryptionMode getEncryptionMode() {
        return this.getEncryptionModes()[0];
    }

    public EncryptionMode[] getEncryptionModes() {
        return this.__encryptionModes;
    }

    public EncryptionPolicy getEncryptionPolicy() {
        return this.__encryptionPolicy;
    }

    IceRole getIceRole() {
        return this._iceRole;
    }

    public int getIndex() {
        return this._index;
    }

    Candidate[] getLocalCandidates() {
        return this.get_LocalCandidates().toArray(new Candidate[0]);
    }

    CryptoAttribute[] getLocalCryptoAttributes() {
        return this.__localCryptoAttributes;
    }

    DtlsParameters getLocalDtlsParameters() {
        return this._localDtlsParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceParameters getLocalIceParameters() {
        Object object = this.__localIceParametersLock;
        synchronized (object) {
            if (this.__localIceParameters == null) {
                String inputString = StringExtensions.substring(Guid.newGuid().toString().replace("-", ""), 0, 8);
                String password = HashContextBase.compute(HashType.Md5, inputString).toHexString();
                this.__localIceParameters = new IceParameters(inputString, password);
            }
            return this.__localIceParameters;
        }
    }

    CryptoAttribute[] getRemoteCryptoAttributes() {
        return this.__remoteCryptoAttributes;
    }

    DtlsParameters getRemoteDtlsParameters() {
        return this._remoteDtlsParameters;
    }

    public IceParameters getRemoteIceParameters() {
        return this._remoteIceParameters;
    }

    public SdesPolicy getSdesPolicy() {
        return this.__sdesPolicy;
    }

    public boolean getUseDtls() {
        return this._useDtls;
    }

    public boolean getUseSdes() {
        return this._useSdes;
    }

    TransportAddress obtainLikelyTransportAddress(CoreTransport coreTransport) {
        IceCandidate defaultLocalCandidate;
        IceGatherer gatherer = coreTransport.getGatherer();
        String defaultIp = this._defaultIp;
        int port = 9;
        if (gatherer != null && (defaultLocalCandidate = gatherer.getDefaultLocalCandidate()) != null) {
            defaultIp = defaultLocalCandidate.getIPAddress();
            port = defaultLocalCandidate.getPort();
        }
        return new TransportAddress(defaultIp, port);
    }

    protected void processCachedSettings() {
    }

    @Override
    Error processSdpMediaDescription(Message sdpMessage, MediaDescription sdpMediaDescription, boolean isLocalDescription, boolean isOffer, boolean isRenegotiation) {
        CryptoAttribute[] cryptoAttributes;
        SetupAttribute setupAttribute;
        FingerprintAttribute fingerprintAttribute;
        PasswordAttribute icePasswordAttribute;
        if (sdpMediaDescription.getMedia().getTransportPort() == 0 || this.getDisabled()) {
            StreamDirection sessionLevelDirection = sdpMessage.getSessionLevelDirection();
            StreamDirection streamDirection = sdpMediaDescription.getStreamDirection();
            if (this.getDisabled() || !Global.equals((Object)sessionLevelDirection, (Object)StreamDirection.Inactive) && !Global.equals((Object)streamDirection, (Object)StreamDirection.Inactive)) {
                this.setDisabled(true);
                return new Error(ErrorCode.StreamDisabled, new Exception(StringExtensions.format("{0} peer rejected session offer.", isLocalDescription ? "Local" : "Remote")));
            }
        }
        super.processSdpMediaDescription(sdpMessage, sdpMediaDescription, isLocalDescription, isOffer, isRenegotiation);
        UfragAttribute iceUfragAttribute = sdpMediaDescription.getIceUfragAttribute();
        if (iceUfragAttribute == null) {
            iceUfragAttribute = sdpMessage.getSessionLevelIceUfragAttribute();
        }
        if ((icePasswordAttribute = sdpMediaDescription.getIcePasswordAttribute()) == null) {
            icePasswordAttribute = sdpMessage.getSessionLevelIcePasswordAttribute();
        }
        if (!isLocalDescription) {
            IcePolicy icePolicy = this.getCoreTransportRtp().getIceTransport().getIcePolicy();
            boolean flag = icePasswordAttribute != null && iceUfragAttribute != null;
            boolean enable = false;
            IcePolicy _var0 = icePolicy;
            if (_var0 == IcePolicy.Required) {
                if (!flag) {
                    return new Error(ErrorCode.IncompatibleIceSetup, new Exception(StringExtensions.format("Local IcePolicy is set to Required, but the remote client does not support ICE for stream {0} of type {1}.", super.getId(), super.getType().toString())));
                }
                enable = true;
                this.enableIceForInternalTransports(enable);
            } else if (_var0 == IcePolicy.Negotiated) {
                if (!flag) {
                    Log.debug(StringExtensions.format("Remote client does not support ICE for stream {0} of type {1}. Ice will be disabled for this stream.", super.getId(), super.getType().toString()));
                    enable = false;
                    this.enableIceForInternalTransports(enable);
                } else {
                    Log.debug(StringExtensions.format("Remote client supports ICE for stream {0} of type {1}. Ice will be enabled for this stream.", super.getId(), super.getType().toString()));
                    enable = true;
                    this.enableIceForInternalTransports(enable);
                }
            } else {
                enable = false;
                this.enableIceForInternalTransports(enable);
            }
            if (!enable) {
                CoreTransport coreTransportRtcp;
                int transportPort = sdpMediaDescription.getMedia().getTransportPort();
                String mappedIPAddress = null;
                if (sdpMediaDescription.getConnectionData() != null) {
                    mappedIPAddress = sdpMediaDescription.getConnectionData().getConnectionAddress();
                } else if (sdpMessage.getConnectionData() != null) {
                    mappedIPAddress = sdpMessage.getConnectionData().getConnectionAddress();
                }
                if (mappedIPAddress != null) {
                    String foundation = IceCandidate.generateLocalCandidateFoundation(CandidateType.Unknown, mappedIPAddress, null, ProtocolType.Unknown);
                    this.getCoreTransportRtp().getIceTransport().setRemoteCandidateFromMLine(new IceCandidate(null, foundation, ProtocolType.Unknown, mappedIPAddress, transportPort, CandidateType.Unknown));
                }
                if (sdpMediaDescription.getRtcpAttribute() != null && (coreTransportRtcp = this.getCoreTransportRtcp()) != null) {
                    CryptoAttribute[] connectionAddress = sdpMediaDescription.getRtcpAttribute().getConnectionAddress();
                    int port = sdpMediaDescription.getRtcpAttribute().getPort();
                    if (!Global.equals(mappedIPAddress, connectionAddress) || transportPort != port) {
                        String str4 = IceCandidate.generateLocalCandidateFoundation(CandidateType.Unknown, (String)connectionAddress, null, ProtocolType.Unknown);
                        coreTransportRtcp.getIceTransport().setRemoteCandidateFromMLine(new IceCandidate(null, str4, ProtocolType.Unknown, (String)connectionAddress, port, CandidateType.Unknown));
                    }
                }
            }
        }
        if ((fingerprintAttribute = sdpMediaDescription.getFingerprintAttribute()) == null) {
            fingerprintAttribute = sdpMessage.getSessionLevelFingerprintAttribute();
        }
        if ((setupAttribute = sdpMediaDescription.getSetupAttribute()) == null) {
            setupAttribute = sdpMessage.getSessionLevelSetupAttribute();
        }
        if ((cryptoAttributes = sdpMediaDescription.getCryptoAttributes()) == null) {
            cryptoAttributes = sdpMessage.getSessionLevelCryptoAttributes();
        }
        if (!isRenegotiation) {
            boolean flag3;
            String transportProtocol = sdpMediaDescription.getMedia().getTransportProtocol();
            boolean bl = flag3 = Global.equals((Object)super.getType(), (Object)StreamType.Application) ? fm.icelink.sdp.sctp.Media.supportsEncryption(transportProtocol) : Media.supportsEncryption(transportProtocol);
            if (!isLocalDescription && !Global.equals((Object)this.getEncryptionPolicy(), (Object)EncryptionPolicy.Disabled)) {
                if (Global.equals((Object)this.getEncryptionPolicy(), (Object)EncryptionPolicy.Negotiated)) {
                    if (!flag3) {
                        Log.debug(StringExtensions.format("Remote peer does not support encryption for stream {0}. Disabling encryption support locally.", super.getId()));
                        this.setUseDtls(false);
                        this.setEncryptionMode(EncryptionMode.Null);
                    }
                } else if (Global.equals((Object)this.getEncryptionPolicy(), (Object)EncryptionPolicy.Required) && !flag3) {
                    Log.debug(StringExtensions.format("Remote peer does not support encryption for stream {0}. Local policy is set to Require. Cannot proceed.", super.getId()));
                    return new Error(ErrorCode.StreamEncryptionMismatch, new Exception(StringExtensions.format("Remote peer does not support encryption for stream {0}. Local policy is set to Require.Cannot proceed.", super.getId())));
                }
            }
            boolean useDtls = this.getUseDtls();
            this.setUseDtls(fingerprintAttribute != null && this.getUseDtls());
            if (!Global.equals(this.getUseDtls(), useDtls) && !isOffer && isLocalDescription) {
                return new Error(ErrorCode.LocalDescriptionError, new Exception("The endpoint in answering mode attempted to modify encryption algorithm in the local session description."));
            }
            if (isLocalDescription) {
                this.__localCryptoAttributes = cryptoAttributes;
                if (setupAttribute != null) {
                    if (isOffer && !Global.equals(setupAttribute.getSetup(), Setup.getActPass())) {
                        return new Error(ErrorCode.LocalDescriptionError, new Exception("The endpoint that is the offerer MUST use the setup attribute value of setup:actpass"));
                    }
                    if (!isOffer && Global.equals(setupAttribute.getSetup(), Setup.getActPass())) {
                        return new Error(ErrorCode.LocalDescriptionError, new Exception("The endpoint that is the answerer MUST use either a setup attribute value of setup:active or setup:passive"));
                    }
                    if (!isOffer && (Global.equals(setupAttribute.getSetup(), Setup.getPassive()) && Global.equals((Object)this.getRemoteDtlsParameters().getRole(), (Object)DtlsRole.Server) || Global.equals(setupAttribute.getSetup(), Setup.getActive()) && Global.equals((Object)this.getRemoteDtlsParameters().getRole(), (Object)DtlsRole.Client))) {
                        return new Error(ErrorCode.LocalDescriptionError, new Exception("The endpoint that is the answerer attempted to modify local Dtls role that has already been negotiated with the offerer"));
                    }
                    if (Global.equals(setupAttribute.getSetup(), Setup.getActPass()) || Global.equals(setupAttribute.getSetup(), Setup.getPassive())) {
                        this.setIceRole(IceRole.Controlling);
                    } else {
                        this.setIceRole(IceRole.Controlled);
                    }
                }
            } else {
                EncryptionMode[] encryptionModeArray;
                if (setupAttribute != null) {
                    if (Global.equals(setupAttribute.getSetup(), Setup.getActPass()) || Global.equals(setupAttribute.getSetup(), Setup.getPassive())) {
                        this.setIceRole(IceRole.Controlled);
                    } else {
                        this.setIceRole(IceRole.Controlling);
                    }
                }
                this.__remoteCryptoAttributes = cryptoAttributes;
                if (this.__remoteCryptoAttributes == null) {
                    this.__remoteCryptoAttributes = new CryptoAttribute[0];
                }
                if (this.__localCryptoAttributes == null) {
                    this.generateCryptoAttributes();
                }
                ArrayList<EncryptionMode> list = new ArrayList<EncryptionMode>();
                for (CryptoAttribute attribute5 : this.__remoteCryptoAttributes) {
                    if (Global.equals(attribute5.getCryptoSuite(), CryptoSuite.getAesCM128HmacSha180())) {
                        list.add(EncryptionMode.Aes128Strong);
                    } else if (Global.equals(attribute5.getCryptoSuite(), CryptoSuite.getAesCm128HmacSha132())) {
                        list.add(EncryptionMode.Aes128Weak);
                    } else if (Global.equals(attribute5.getCryptoSuite(), CryptoSuite.getNullHmacSha180())) {
                        list.add(EncryptionMode.NullStrong);
                    } else if (Global.equals(attribute5.getCryptoSuite(), CryptoSuite.getNullHmacSha132())) {
                        list.add(EncryptionMode.NullWeak);
                    }
                    for (CryptoAttribute cryptoAttribute : this.__localCryptoAttributes) {
                        if (!Global.equals(attribute5, cryptoAttribute)) continue;
                        cryptoAttribute.setTag(attribute5.getTag());
                    }
                }
                DtlsRole server = DtlsRole.Server;
                if (setupAttribute != null && Global.equals(setupAttribute.getSetup(), Setup.getActive())) {
                    server = DtlsRole.Client;
                }
                ArrayList<EncryptionMode> list2 = new ArrayList<EncryptionMode>();
                if (!Global.equals((Object)this.getEncryptionPolicy(), (Object)EncryptionPolicy.Disabled)) {
                    this.getLocalDtlsParameters().setRole(Global.equals((Object)server, (Object)DtlsRole.Server) ? DtlsRole.Client : DtlsRole.Server);
                    if (this.getUseDtls()) {
                        DtlsFingerprint[] fingerprints = new DtlsFingerprint[]{new DtlsFingerprint(fingerprintAttribute.getHashFunction(), fingerprintAttribute.getFingerprint())};
                        this.setRemoteDtlsParameters(new DtlsParameters(Global.equals((Object)this.getLocalDtlsParameters().getRole(), (Object)DtlsRole.Server) ? DtlsRole.Client : DtlsRole.Server, fingerprints));
                    } else if (ArrayListExtensions.getCount(list) == 0) {
                        list.add(EncryptionMode.Null);
                    }
                    block2: for (EncryptionMode mode : list) {
                        for (EncryptionMode encryptionMode : this.getEncryptionModes()) {
                            if (!Global.equals((Object)mode, (Object)encryptionMode)) continue;
                            list2.add(mode);
                            continue block2;
                        }
                    }
                }
                if (ArrayListExtensions.getCount(list2) == 0) {
                    list2.add(EncryptionMode.Null);
                }
                if (this.getUseDtls()) {
                    EncryptionMode[] encryptionModeArray2 = new EncryptionMode[1];
                    encryptionModeArray = encryptionModeArray2;
                    encryptionModeArray2[0] = EncryptionMode.Aes128Strong;
                } else {
                    EncryptionMode[] encryptionModeArray3 = new EncryptionMode[1];
                    encryptionModeArray = encryptionModeArray3;
                    encryptionModeArray3[0] = (EncryptionMode)((Object)ArrayListExtensions.getItem(list2).get(0));
                }
                this.setEncryptionModes(encryptionModeArray);
            }
            String usernameFragment = StringExtensions.empty;
            String password = null;
            if (iceUfragAttribute != null) {
                usernameFragment = iceUfragAttribute.getUfrag();
            }
            if (icePasswordAttribute != null) {
                password = icePasswordAttribute.getPassword();
            }
            if (isLocalDescription) {
                this.setLocalIceParameters(new IceParameters(usernameFragment, password));
            } else {
                this.setRemoteIceParameters(new IceParameters(usernameFragment, password));
            }
        }
        if (isRenegotiation && isOffer) {
            this.processCachedSettings();
        }
        return null;
    }

    void raiseDisabledChange() {
        IAction0 onDisabledChange = this._onDisabledChange;
        if (onDisabledChange != null) {
            onDisabledChange.invoke();
        }
    }

    public void removeOnDisabledChange(IAction0 value) {
        IAction0 match;
        if (value instanceof IActionDelegate0 && (match = Global.findIActionDelegate0WithId(this.__onDisabledChange, ((IActionDelegate0)value).getId())) != null) {
            value = match;
        }
        this.__onDisabledChange.remove(value);
        if (this.__onDisabledChange.size() == 0) {
            this._onDisabledChange = null;
        }
    }

    void reset() {
        this.setCoreTransportRtcp(null);
        this.setCoreTransportRtp(null);
        this.setLocalIceParameters(null);
        this.setLocalDtlsParameters(null);
    }

    private void set_LocalCandidates(ArrayList<Candidate> value) {
        this.__localCandidates = value;
    }

    public void setCanonicalName(String value) {
        this._canonicalName = value;
    }

    void setCoreTransportRtcp(CoreTransport value) {
        this._coreTransportRtcp = value;
    }

    void setCoreTransportRtp(CoreTransport value) {
        this._coreTransportRtp = value;
    }

    public void setDisabled(boolean value) {
        if (!Global.equals(this.__disabled, value)) {
            this.__disabled = value;
            this.raiseDisabledChange();
        }
    }

    public void setEncryptionMode(EncryptionMode value) {
        this.setEncryptionModes(new EncryptionMode[]{value});
    }

    public void setEncryptionModes(EncryptionMode[] value) {
        if (value == null || ArrayExtensions.getLength((Object[])value) == 0) {
            throw new RuntimeException(new Exception("At least one encryption mode must be specified."));
        }
        if (ArrayExtensions.getLength((Object[])value) == 1 && Global.equals((Object)value[0], (Object)EncryptionMode.Null)) {
            this.setUseDtls(false);
        }
        this.__encryptionModes = value;
    }

    public void setEncryptionPolicy(EncryptionPolicy value) {
        if (!Global.equals((Object)super.getType(), (Object)StreamType.Application)) {
            this.__encryptionPolicy = value;
        } else {
            if (!Global.equals((Object)value, (Object)EncryptionPolicy.Required)) {
                throw new RuntimeException(new Exception("Data streams require encryption."));
            }
            this.__encryptionPolicy = value;
        }
        if (Global.equals((Object)value, (Object)EncryptionPolicy.Disabled)) {
            this.setEncryptionMode(EncryptionMode.Null);
            this.setUseDtls(false);
            this.setUseSdes(false);
        }
    }

    void setIceRole(IceRole value) {
        this._iceRole = value;
    }

    void setIndex(int value) {
        this._index = value;
    }

    void setLocalDtlsParameters(DtlsParameters value) {
        this._localDtlsParameters = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalIceParameters(IceParameters value) {
        Object object = this.__localIceParametersLock;
        synchronized (object) {
            this.__localIceParameters = value;
        }
    }

    void setRemoteDtlsParameters(DtlsParameters value) {
        this._remoteDtlsParameters = value;
    }

    void setRemoteIceParameters(IceParameters value) {
        this._remoteIceParameters = value;
    }

    public void setSdesPolicy(SdesPolicy value) {
        this.__sdesPolicy = value;
    }

    public void setUseDtls(boolean value) {
        this._useDtls = value;
    }

    public void setUseSdes(boolean value) {
        this._useSdes = value;
    }

    public Stream(StreamType type) {
        super(type);
        this.__localIceParametersLock = new Object();
        this.__encryptionPolicy = EncryptionPolicy.Required;
        this.__sdesPolicy = SdesPolicy.Negotiated;
        this.set_LocalCandidates(new ArrayList<Candidate>());
        this.setEncryptionMode(EncryptionMode.Aes128Strong);
        if (Global.equals((Object)type, (Object)StreamType.Application)) {
            this.setUseSdes(false);
        } else {
            this.setUseSdes(true);
        }
        this.setUseDtls(true);
        this.setDisabled(false);
    }
}

