/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.ILog;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaBufferCollection;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFormat;
import fm.icelink.MediaFormatCollection;
import fm.icelink.MediaFrame;
import fm.icelink.MediaTransport;
import fm.icelink.MediaTransportState;
import fm.icelink.RtcpPacket;
import fm.icelink.RtpPacketHeader;
import fm.icelink.RtpPacketPair;
import fm.icelink.SrtpContext;
import fm.icelink.SrtpListener;
import fm.icelink.SrtpProtectionParameters;
import fm.icelink.StringExtensions;
import fm.icelink.Transport;
import fm.icelink.diagnostics.DurationTimer;
import fm.icelink.diagnostics.Timers;
import java.util.ArrayList;

abstract class SrtpTransport<TFrame extends MediaFrame<TBuffer, TBufferCollection, TFormat, TFrame>, TBuffer extends MediaBuffer<TFormat, TBuffer>, TBufferCollection extends MediaBufferCollection<TBuffer, TBufferCollection, TFormat>, TFormat extends MediaFormat<TFormat>, TFormatCollection extends MediaFormatCollection<TFormat, TFormatCollection>>
extends MediaTransport<TFrame, TBuffer, TBufferCollection, TFormat, TFormatCollection> {
    private SrtpContext __context = null;
    private Object __encryptRtpLock;
    private SrtpListener __listener = null;
    private SrtpProtectionParameters __localParameters;
    private static ILog __log = Log.getLogger("FM.IceLink.Srtp.Transport");
    private ArrayList<DataBuffer> __receiveQueue;
    private SrtpProtectionParameters __remoteParameters;
    private Transport __rtcpTransport;
    private Transport __rtpTransport;
    private ArrayList<DataBuffer> __sendQueue = new ArrayList();
    private DurationTimer __timer;
    private Object _encryptRtcpLock;
    private long _highestTimestamp = -1L;
    private long _timestampRolloverCounter = 0L;

    public abstract TFrame doCreateFrame(RtpPacketHeader var1, DataBuffer var2, TFormat var3);

    @Override
    public void doReceiveControlFrames(MediaControlFrame[] controlFrames) {
        this.raiseReceiveControlFrames(controlFrames);
    }

    @Override
    public void doReceiveFrame(TFrame frame) {
        this.raiseReceiveFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doResendPacket(RtpPacketPair packet) {
        SrtpContext context = this.__context;
        if (context == null) {
            Log.error("Cannot send frame. No context set. Did you SetParameters and Start?");
            return false;
        }
        DataBuffer encryptedDataBuffer = null;
        try {
            Object object = this.__encryptRtpLock;
            synchronized (object) {
                encryptedDataBuffer = context.encryptRtp(packet.getHeader(), packet.getPayload());
            }
        }
        catch (Exception exception) {
            Log.error(StringExtensions.format("Encrypt failed. Srtp transport cannot send: {0}", exception.getMessage()));
            return false;
        }
        if (encryptedDataBuffer == null) {
            Log.error("Encrypt failed. Srtp transport cannot send.");
            return false;
        }
        this.sendEncryptedDataBuffer(encryptedDataBuffer);
        return true;
    }

    @Override
    public void doSendControlFrames(MediaControlFrame[] controlFrames) {
        Transport transport = this.__rtpTransport;
        if (transport != null) {
            RtcpPacket[] packets = new RtcpPacket[ArrayExtensions.getLength(controlFrames)];
            for (int i = 0; i < ArrayExtensions.getLength(controlFrames); ++i) {
                packets[i] = new RtcpPacket(controlFrames[i].getDataBuffer());
            }
            DataBuffer buffer = null;
            try {
                buffer = this.encryptRtcp(packets);
            }
            catch (Exception exception) {
                __log.error("Could not encrypt RTCP packet.", exception);
            }
            if (buffer != null) {
                transport.send(buffer);
            }
        }
    }

    @Override
    public boolean doSendFrame(TFrame frame) {
        if (this.__context == null) {
            __log.error("Cannot send frame. No context set. Did you SetParameters and Start?");
            return false;
        }
        Object local = ((MediaFrame)frame).getBuffer(true, true);
        if (local == null) {
            Object local2 = ((MediaFrame)frame).getBuffer(true);
            if (local2 == null) {
                __log.error("Frame has no packetized buffers to send.");
                return false;
            }
            local = this.encryptBuffer(local2);
            if (local == null) {
                return false;
            }
            ((MediaFrame)frame).addBuffer(local);
        }
        for (DataBuffer buffer : ((MediaBuffer)local).getDataBuffers()) {
            this.sendEncryptedDataBuffer(buffer);
        }
        return true;
    }

    @Override
    public boolean doStart() {
        if (this.__context == null) {
            __log.error("Parameters must be set prior to calling Start().");
            return false;
        }
        if (this.getRtpTransport().getIsClosed()) {
            __log.error("Cannot start SRTP transport. Inner RTP transport is closed.");
            return false;
        }
        if (this.getRtcpTransport().getIsClosed()) {
            __log.error("Cannot start SRTP transport. Inner RTCP transport is closed.");
            return false;
        }
        if (super.getParameters() == null) {
            __log.error("Cannot start SRTP transport. Parameters must be set.");
            return false;
        }
        if (this.getListener() == null) {
            __log.error("Cannot start SRTP transport. A Listener must be set.");
            return false;
        }
        this.__timer = Timers.getDurationTimer("SRTP Encrypt");
        this.__listener.removeOnReceiveRtp((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.SrtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processReceiveRtp";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                SrtpTransport.this.processReceiveRtp(buffer);
            }
        });
        this.__listener.addOnReceiveRtp((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.SrtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processReceiveRtp";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                SrtpTransport.this.processReceiveRtp(buffer);
            }
        });
        this.__listener.removeOnReceiveRtcp((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.SrtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processReceiveRtcp";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                SrtpTransport.this.processReceiveRtcp(buffer);
            }
        });
        this.__listener.addOnReceiveRtcp((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.SrtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processReceiveRtcp";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                SrtpTransport.this.processReceiveRtcp(buffer);
            }
        });
        return true;
    }

    @Override
    public boolean doStop() {
        this.__listener.removeOnReceiveRtp((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.SrtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processReceiveRtp";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                SrtpTransport.this.processReceiveRtp(buffer);
            }
        });
        this.__listener.removeOnReceiveRtcp((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

            @Override
            public String getId() {
                return "fm.icelink.SrtpTransport<TFrame,TBuffer,TBufferCollection,TFormat,TFormatCollection>.processReceiveRtcp";
            }

            @Override
            public void invoke(DataBuffer buffer) {
                SrtpTransport.this.processReceiveRtcp(buffer);
            }
        });
        this.__context.destroy();
        this.__context = null;
        this.__localParameters = null;
        this.__remoteParameters = null;
        this.__timer.destroy();
        this.__timer = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TBuffer encryptBuffer(TBuffer buffer) {
        SrtpContext context = this.__context;
        if (context == null) {
            return null;
        }
        Object[] dataBuffers = ((MediaBuffer)buffer).getDataBuffers();
        RtpPacketHeader[] rtpHeaders = ((MediaBuffer)buffer).getRtpHeaders();
        DataBuffer[] bufferArray2 = new DataBuffer[ArrayExtensions.getLength(dataBuffers)];
        for (int i = 0; i < ArrayExtensions.getLength(dataBuffers); ++i) {
            RtpPacketHeader header = rtpHeaders[i];
            if (header == null) {
                __log.error("Malformed RTP packet in frame. Transport cannot send.");
                return null;
            }
            DataBuffer buffer2 = null;
            try {
                Object object = this.__encryptRtpLock;
                synchronized (object) {
                    try {
                        this.__timer.beginSample();
                        buffer2 = context.encryptRtp(rtpHeaders[i], (DataBuffer)dataBuffers[i]);
                    }
                    finally {
                        this.__timer.endSample();
                    }
                }
            }
            catch (Exception exception) {
                __log.error(StringExtensions.format("Encrypt failed. Srtp transport cannot send: {0}", exception.getMessage()));
                return null;
            }
            if (buffer2 == null) {
                __log.error("Encrypt failed. Srtp transport cannot send.");
                return null;
            }
            bufferArray2[i] = buffer2;
        }
        Object local = ((MediaBuffer)buffer).clone();
        ((MediaFormat)((MediaBuffer)local).getFormat()).setIsEncrypted(true);
        ((MediaBuffer)local).setDataBuffers(bufferArray2);
        return (TBuffer)local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBuffer encryptRtcp(RtcpPacket[] packets) {
        SrtpContext context = this.__context;
        if (context != null) {
            Object object = this._encryptRtcpLock;
            synchronized (object) {
                return context.encryptRtcp(packets);
            }
        }
        return null;
    }

    public TFrame generateFrame(RtpPacketHeader header, DataBuffer payload, TFormat packetFormat) {
        SrtpContext context = this.__context;
        if (context == null) {
            return null;
        }
        TFrame local = this.doCreateFrame(header, payload, packetFormat);
        ((MediaFrame)local).setRtpTimestamp(header.getTimestamp());
        ((MediaFrame)local).setTimestamp(this.getMediaFrameTimestamp(header.getTimestamp()));
        ((MediaFrame)local).setRtpSequenceNumber(header.getSequenceNumber());
        ((MediaFrame)local).setSequenceNumber(context.getRtpDecryptionPacketIndex(header.getSequenceNumber()));
        ((MediaBuffer)((MediaFrame)local).getBuffer()).setSequenceNumber(((MediaFrame)local).getSequenceNumber());
        ((MediaFrame)local).setSynchronizationSource(header.getSynchronizationSource());
        ((MediaFrame)local).setContributingSources(header.getContributingSources());
        return local;
    }

    public SrtpListener getListener() {
        return this.__listener;
    }

    public SrtpProtectionParameters getLocalParameters() {
        return this.__localParameters;
    }

    public long getMediaFrameTimestamp(long timestamp) {
        long timestampRolloverCounter;
        if (this._highestTimestamp == -1L) {
            this._highestTimestamp = timestamp;
            return timestamp;
        }
        if (this._highestTimestamp < 0x80000000L) {
            if (timestamp - this._highestTimestamp > 0x80000000L) {
                timestampRolloverCounter = (this._timestampRolloverCounter - 1L) % 0x100000000L;
            } else {
                timestampRolloverCounter = this._timestampRolloverCounter;
                this._highestTimestamp = MathAssistant.max(this._highestTimestamp, timestamp);
            }
        } else if (this._highestTimestamp - 0x80000000L > timestamp) {
            timestampRolloverCounter = (this._timestampRolloverCounter + 1L) % 0x100000000L;
            this._highestTimestamp = timestamp;
            this._timestampRolloverCounter = timestampRolloverCounter;
        } else {
            timestampRolloverCounter = this._timestampRolloverCounter;
            this._highestTimestamp = MathAssistant.max(this._highestTimestamp, timestamp);
        }
        return 0x100000000L * timestampRolloverCounter + timestamp;
    }

    public SrtpProtectionParameters getRemoteParameters() {
        return this.__remoteParameters;
    }

    public Transport getRtcpTransport() {
        return this.__rtcpTransport;
    }

    public Transport getRtpTransport() {
        return this.__rtpTransport;
    }

    private void processReceiveRtcp(DataBuffer buffer) {
        SrtpContext context = this.__context;
        if (context != null) {
            RtcpPacket[] packets = context.decryptRtcp(buffer);
            if (packets == null) {
                __log.warn("Could not decrypt SRTCP packet.");
            } else {
                this.receiveRtcp(packets);
            }
        }
    }

    private void processReceiveRtp(DataBuffer buffer) {
        SrtpContext context = this.__context;
        if (context != null) {
            RtpPacketPair pair = context.decryptRtp(buffer);
            if (pair == null) {
                __log.warn("Could not decrypt SRTP packet.");
            } else if (pair.getPayload() == null) {
                __log.debug(StringExtensions.format("Discarding RTP packet of length {0} and padding {1} due to payload length of 0.", IntegerExtensions.toString(pair.getCombinedSize()), IntegerExtensions.toString(pair.getHeader().getPaddingLength())));
            } else {
                this.receiveDecryptedRtp(pair.getHeader(), pair.getPayload());
            }
        }
    }

    private void receiveDecryptedRtp(RtpPacketHeader header, DataBuffer payload) {
        if (header != null && payload != null) {
            Object negotiatedFormat = super.getNegotiatedFormat(header.getPayloadType());
            if (negotiatedFormat != null) {
                Object packetFormat = ((MediaFormat)negotiatedFormat).clone();
                ((MediaFormat)packetFormat).setIsEncrypted(false);
                TFrame frame = this.generateFrame(header, payload, packetFormat);
                if (frame != null) {
                    super.receiveFrame(frame);
                }
            }
        } else {
            __log.error("Null packet raised to SRTP transport.");
        }
    }

    private void receiveRtcp(RtcpPacket[] packets) {
        MediaControlFrame[] controlFrames = new MediaControlFrame[ArrayExtensions.getLength(packets)];
        for (int i = 0; i < ArrayExtensions.getLength(packets); ++i) {
            RtcpPacket packet = packets[i];
            controlFrames[i] = MediaControlFrame.parse(packet);
        }
        super.receiveControlFrames(controlFrames);
    }

    private void sendEncryptedDataBuffer(DataBuffer encryptedDataBuffer) {
        if (this.__rtpTransport != null) {
            this.__rtpTransport.send(encryptedDataBuffer);
        }
    }

    public void setListener(SrtpListener value) {
        if (this.__listener != null && Global.equals((Object)this.__state, (Object)MediaTransportState.Started)) {
            throw new RuntimeException(new Exception("Cannot set new Listener when one has already been set and the transport has already been started."));
        }
        this.__listener = value;
    }

    public boolean setProtectionParameters(SrtpProtectionParameters localParameters, SrtpProtectionParameters remoteParameters) {
        if (!Global.equals(localParameters.getProtectionProfileString(), remoteParameters.getProtectionProfileString())) {
            __log.error("SRTP protection profiles do not match.");
            return false;
        }
        this.__localParameters = localParameters;
        this.__remoteParameters = remoteParameters;
        this.__context = new SrtpContext(localParameters.getProtectionProfileString(), this.__localParameters.getKey(), this.__localParameters.getSalt(), this.__remoteParameters.getKey(), this.__remoteParameters.getSalt());
        return true;
    }

    void setRtcpTransport(Transport value) {
        this.__rtcpTransport = value;
    }

    public SrtpTransport(Object lockObject, Transport rtpTransport, Transport rtcpTransport) {
        super(lockObject);
        this.__receiveQueue = new ArrayList();
        this.__encryptRtpLock = new Object();
        this._encryptRtcpLock = new Object();
        if (rtpTransport == null) {
            __log.error("Null RTP transport argument.");
        }
        if (rtcpTransport == null) {
            __log.error("Null RTCP transport argument.");
        }
        this.__rtpTransport = rtpTransport;
        this.__rtcpTransport = rtcpTransport;
    }
}

