/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.IAudioOutput;
import fm.icelink.IMediaOutput;
import fm.icelink.IntegerExtensions;
import fm.icelink.Resampler;
import fm.icelink.SoundUtility;
import fm.icelink.StringExtensions;
import fm.icelink.pcm.Format;

public class SoundConverter
extends AudioPipe {
    private long __baseResampleTimestamp = -1L;
    private Resampler __resampler;

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        DataBuffer dataBuffer = inputBuffer.getDataBuffer();
        AudioFormat format = (AudioFormat)inputBuffer.getFormat();
        boolean flag = false;
        if (!format.isEquivalent(super.getOutputFormat())) {
            boolean flag2 = false;
            int clockRate = ((AudioFormat)inputBuffer.getFormat()).getClockRate();
            int channelCount = ((AudioFormat)inputBuffer.getFormat()).getChannelCount();
            int targetClockRate = ((AudioFormat)super.getOutputFormat()).getClockRate();
            int num4 = ((AudioFormat)super.getOutputFormat()).getChannelCount();
            if (channelCount != num4 && channelCount == 2 && num4 == 1) {
                DataBuffer mono = DataBufferPool.getInstance().take(dataBuffer.getLength() / 2, dataBuffer.getLittleEndian());
                SoundUtility.stereoToMono(dataBuffer, mono);
                if (flag) {
                    dataBuffer.free();
                }
                dataBuffer = mono;
                flag = true;
                format = format.clone();
                format.setChannelCount(num4);
                flag2 = true;
            }
            if (channelCount != num4 && channelCount == 1 && num4 == 2) {
                DataBuffer stereo = DataBufferPool.getInstance().take(dataBuffer.getLength() * 2, dataBuffer.getLittleEndian());
                SoundUtility.monoToStereo(dataBuffer, stereo);
                if (flag) {
                    dataBuffer.free();
                }
                dataBuffer = stereo;
                flag = true;
                format = format.clone();
                format.setChannelCount(num4);
                flag2 = true;
            }
            if (clockRate != targetClockRate) {
                DataBuffer output;
                if (this.__resampler == null) {
                    this.__resampler = new Resampler(clockRate, targetClockRate);
                }
                if (!this.__resampler.resample(dataBuffer, output = DataBufferPool.getInstance().take(this.__resampler.getOutputLength(dataBuffer), dataBuffer.getLittleEndian()))) {
                    output.free();
                    throw new RuntimeException(new Exception(StringExtensions.format("Could not convert audio buffer clock rate from {0} to {1}.", IntegerExtensions.toString(clockRate), IntegerExtensions.toString(targetClockRate))));
                }
                if (this.__baseResampleTimestamp == -1L) {
                    this.__baseResampleTimestamp = frame.getTimestamp();
                }
                long num5 = frame.getTimestamp() - this.__baseResampleTimestamp;
                frame.setTimestamp(this.__baseResampleTimestamp + num5 * (long)targetClockRate / (long)clockRate);
                if (frame.getRtpTimestamp() != -1L) {
                    frame.setRtpTimestamp(frame.getTimestamp() % 65536L);
                }
                if (flag) {
                    dataBuffer.free();
                }
                dataBuffer = output;
                flag = true;
                format = format.clone();
                format.setClockRate(targetClockRate);
                flag2 = true;
            }
            if (flag2) {
                frame.addBuffer(new AudioBuffer(dataBuffer, format));
            }
        }
        this.raiseFrame(frame);
        if (flag) {
            dataBuffer.free();
        }
    }

    @Override
    public String getLabel() {
        return "Sound Converter";
    }

    public SoundConverter(AudioConfig outputConfig) {
        super(new Format(outputConfig));
    }

    public SoundConverter(IAudioOutput input, AudioConfig outputConfig) {
        this(input.getConfig(), outputConfig);
        super.addInput(input);
    }

    public SoundConverter(AudioConfig inputConfig, AudioConfig outputConfig) {
        super(new Format(inputConfig), new Format(outputConfig));
    }

    public SoundConverter(IAudioOutput[] inputs, AudioConfig outputConfig) {
        this(inputs[0].getConfig(), outputConfig);
        super.addInputs((IMediaOutput[])inputs);
    }
}

