/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpTlvParameter;
import java.util.ArrayList;

class SctpUnrecognizedParameterChunkParameter
extends SctpTlvParameter {
    private SctpTlvParameter[] _unrecognizedParameters;

    @Override
    public byte[] getBytes() {
        return SctpUnrecognizedParameterChunkParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpUnrecognizedParameterChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(8, false));
        for (SctpTlvParameter parameter2 : parameter.getUnrecognizedParameters()) {
            bytes.addRange(parameter2.getBytes());
        }
        bytes.insertRange(2, Binary.toBytes16(2 + bytes.getCount(), false));
        return bytes.toArray();
    }

    public SctpTlvParameter[] getUnrecognizedParameters() {
        return this._unrecognizedParameters;
    }

    public static SctpUnrecognizedParameterChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        int startIndex = 4;
        boolean flag = true;
        ArrayList<SctpTlvParameter> list = new ArrayList<SctpTlvParameter>();
        try {
            int num = Binary.fromBytes16(bytes, 2, false);
            if (num <= 4) {
                Log.debug("SCTP Unrecognized Parameter Chunk must contain at least one parameter");
                offsetPlus.setValue(num);
                return null;
            }
            while (flag) {
                SctpTlvParameter _var0 = SctpTlvParameter.parseBytes(bytes, startIndex, offsetPlus);
                SctpTlvParameter item = _var0;
                if (item == null) {
                    offsetPlus.setValue(0);
                    return null;
                }
                list.add(item);
                startIndex = offsetPlus.getValue() + startIndex;
                if (startIndex < num) continue;
                flag = false;
            }
        }
        catch (Exception exception1) {
            Log.debug("Could not parse SCTP Unrecognized Parameter Chunk Parameter");
            offsetPlus.setValue(0);
            return null;
        }
        offsetPlus.setValue(startIndex);
        return new SctpUnrecognizedParameterChunkParameter(list.toArray(new SctpTlvParameter[0]));
    }

    public SctpUnrecognizedParameterChunkParameter(SctpTlvParameter[] chunkParameter) {
        super.setType(8);
        this.setUnrecognizedParameters(chunkParameter);
    }

    public void setUnrecognizedParameters(SctpTlvParameter[] value) {
        this._unrecognizedParameters = value;
    }
}

