/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.ILog;
import fm.icelink.LinkedListNode;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.Scheduler;
import fm.icelink.SctpDataChunk;
import fm.icelink.SctpDataQueue;
import fm.icelink.SctpGapAckBlock;
import fm.icelink.SctpSackChunk;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class SctpSendDataQueue
extends SctpDataQueue {
    private long __cwnd = -1L;
    private volatile boolean __dirty = true;
    private long __greatestTsnAdded = -1L;
    private static ILog __log = Log.getLogger("FM.IceLink.Sctp.SendDataQueue");
    private SctpSackChunk __oldSackChunk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(SctpDataChunk dataChunk) {
        Object object = this.__lock;
        synchronized (object) {
            this.__dirty = true;
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("SCTP SendDataQueue: adding data chunk with TSN {0}.", LongExtensions.toString(dataChunk.getTsn())));
            }
            this.__greatestTsnAdded = SctpDataChunk.maxTsns(this.__greatestTsnAdded, dataChunk.getTsn());
            super.add(dataChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateCWND() {
        long num = 0L;
        SctpDataChunk chunk = null;
        Object object = this.__lock;
        synchronized (object) {
            if (this.__oldSackChunk == null) {
                for (LinkedListNode<SctpDataChunk> node = this.__tsnDataLinkedList.getFirst(); node != null && node.getValue().getTransmissionTime() > 0L; node = node.getNext()) {
                    ++num;
                }
            } else {
                long cumulativeTsnAck = this.__oldSackChunk.getCumulativeTsnAck();
                for (SctpGapAckBlock block : this.__oldSackChunk.getGapAckBlocks()) {
                    long absoluteGapAckBlockStart = block.getAbsoluteGapAckBlockStart();
                    long i = SctpDataChunk.incrementTSN(cumulativeTsnAck);
                    while (SctpDataChunk.compareTsns(i, absoluteGapAckBlockStart) == 2) {
                        chunk = super.getChunk(i);
                        if (chunk != null && chunk.getTransmissionTime() > 0L) {
                            ++num;
                        }
                        i = SctpDataChunk.incrementTSN(i);
                    }
                    cumulativeTsnAck = block.getAbsoluteGapAckBlockEnd();
                }
                chunk = super.getChunk(SctpDataChunk.incrementTSN(cumulativeTsnAck));
                while (chunk != null && chunk.getTransmissionTime() > 0L) {
                    ++num;
                    chunk = super.getNextChunk(chunk.getTsn());
                }
            }
            this.__cwnd = num;
            this.__dirty = false;
        }
    }

    public long getAllAckedUpTo() {
        if (this.__oldSackChunk != null) {
            return this.__oldSackChunk.getCumulativeTsnAck();
        }
        return -1L;
    }

    public boolean getAllSentAcked() {
        return this.getCwnd() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCwnd() {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__dirty) {
                this.calculateCWND();
            }
            return this.__cwnd;
        }
    }

    public SctpDataChunk getFirstUnAcked() {
        return super.getNextChunk(this.getAllAckedUpTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNonsentDataAvailable() {
        boolean flag = false;
        Object object = this.__lock;
        synchronized (object) {
            if (this.__oldSackChunk == null) {
                return this.__tsnDataLinkedList.getCount() != 0;
            }
            long cumulativeTsnAck = this.__oldSackChunk.getCumulativeTsnAck();
            if (ArrayExtensions.getLength(this.__oldSackChunk.getGapAckBlocks()) > 0) {
                cumulativeTsnAck = this.__oldSackChunk.getGapAckBlocks()[ArrayExtensions.getLength(this.__oldSackChunk.getGapAckBlocks()) - 1].getAbsoluteGapAckBlockEnd();
            }
            SctpDataChunk nextChunk = super.getNextChunk(cumulativeTsnAck);
            while (nextChunk != null && !flag) {
                if (nextChunk.getTransmissionTime() <= 0L) {
                    flag = true;
                    continue;
                }
                nextChunk = super.getNextChunk(nextChunk.getTsn());
            }
        }
        return flag;
    }

    public long getNotAckedPast() {
        if (this.__oldSackChunk != null) {
            int numberOfGapAckBlocks = this.__oldSackChunk.getNumberOfGapAckBlocks();
            if (numberOfGapAckBlocks == 0) {
                return this.__oldSackChunk.getCumulativeTsnAck();
            }
            return this.__oldSackChunk.getGapAckBlocks()[numberOfGapAckBlocks - 1].getAbsoluteGapAckBlockEnd();
        }
        return -1L;
    }

    private void markAs(boolean acked, long startTsn, long endTsn) {
        if (SctpDataChunk.compareTsns(startTsn, endTsn) != 1) {
            long i = startTsn;
            while (SctpDataChunk.compareTsns(i, endTsn) != 1) {
                SctpDataChunk chunk = super.getChunk(i);
                if (chunk != null) {
                    chunk.setAcked(acked);
                }
                i = SctpDataChunk.incrementTSN(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markChunkTransmitted(SctpDataChunk chunk) {
        Object object = this.__lock;
        synchronized (object) {
            this.__dirty = true;
            chunk.setTransmissionTime(Scheduler.getCurrentTime());
        }
    }

    SctpDataChunk[] processFullyAckedMessages(long startValue, long endValue, boolean onlyUnordered) {
        ArrayList<SctpDataChunk> list = new ArrayList<SctpDataChunk>();
        long tsn = startValue;
        SctpDataChunk nextChunk = null;
        nextChunk = super.getChunk(startValue);
        if (nextChunk == null) {
            tsn = SctpDataChunk.incrementTSN(tsn);
            while (nextChunk == null && SctpDataChunk.compareTsns(tsn, endValue) != 1) {
                nextChunk = super.getChunk(tsn);
                tsn = SctpDataChunk.incrementTSN(tsn);
            }
            long l = tsn = nextChunk != null ? nextChunk.getTsn() : tsn;
        }
        if (nextChunk == null) {
            return new SctpDataChunk[0];
        }
        while (nextChunk != null && SctpDataChunk.compareTsns(nextChunk.getTsn(), endValue) != 1) {
            boolean beginning = false;
            boolean flag2 = false;
            SctpDataChunk chunk2 = null;
            nextChunk.setAcked(true);
            if (nextChunk.getUnordered() || !onlyUnordered) {
                flag2 = false;
                beginning = nextChunk.getBeginning();
                if (beginning) {
                    chunk2 = nextChunk;
                } else {
                    while (!beginning && !flag2) {
                        SctpDataChunk previousChunk = super.getPreviousChunk(tsn);
                        if (previousChunk != null && previousChunk.getAcked()) {
                            if (previousChunk.getBeginning()) {
                                beginning = true;
                                chunk2 = previousChunk;
                            }
                            tsn = previousChunk.getTsn();
                            continue;
                        }
                        flag2 = true;
                    }
                }
                if (!beginning) {
                    boolean flag3 = true;
                    while (flag3) {
                        if ((nextChunk = super.getNextChunk(nextChunk.getTsn())) == null) {
                            flag3 = false;
                            continue;
                        }
                        tsn = nextChunk.getTsn();
                        if (SctpDataChunk.compareTsns(tsn, endValue) != 1) {
                            nextChunk.setAcked(true);
                            if (!nextChunk.getBeginning()) continue;
                            beginning = true;
                            flag3 = false;
                            chunk2 = nextChunk;
                            continue;
                        }
                        flag3 = false;
                    }
                }
                if (!beginning) continue;
                flag2 = false;
                boolean flag4 = false;
                SctpDataChunk item = null;
                nextChunk = chunk2;
                if (chunk2.getEnding()) {
                    flag4 = true;
                    item = chunk2;
                    tsn = item.getTsn();
                    if (item.getUnordered() || !onlyUnordered) {
                        list.add(item);
                        this.remove(tsn);
                    }
                    if ((nextChunk = super.getNextChunk(nextChunk.getTsn())) != null) {
                        tsn = nextChunk.getTsn();
                    }
                }
                while (!flag4 && !flag2) {
                    SctpDataChunk chunk5 = super.getNextChunk(nextChunk.getTsn());
                    if (chunk5 != null) {
                        tsn = chunk5.getTsn();
                    }
                    if (chunk5 == null || SctpDataChunk.compareTsns(tsn, endValue) == 1) {
                        flag2 = true;
                        nextChunk = null;
                        continue;
                    }
                    chunk5.setAcked(true);
                    if (chunk5.getEnding()) {
                        flag4 = true;
                        item = chunk5;
                        if (item.getUnordered() || !onlyUnordered) {
                            list.add(item);
                            this.removeFromQueue(chunk2.getTsn(), item.getTsn());
                        }
                        if ((nextChunk = super.getNextChunk(item.getTsn())) == null) continue;
                        tsn = nextChunk.getTsn();
                        continue;
                    }
                    nextChunk = chunk5;
                    if (nextChunk == null) continue;
                    tsn = nextChunk.getTsn();
                }
                continue;
            }
            if ((nextChunk = super.getNextChunk(nextChunk.getTsn())) == null) continue;
            tsn = nextChunk.getTsn();
        }
        return list.toArray(new SctpDataChunk[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpDataChunk[] processSackChunk(SctpSackChunk sack) {
        long cumulativeTsnAck = sack.getCumulativeTsnAck();
        Object[] gapAckBlocks = sack.getGapAckBlocks();
        int numberOfGapAckBlocks = sack.getNumberOfGapAckBlocks();
        ArrayList list = new ArrayList();
        if (__log.getIsVerboseEnabled()) {
            if (this.__oldSackChunk != null) {
                __log.verbose(StringExtensions.format("SCTP SendDataQueue: current SACK state {0}", this.__oldSackChunk.toString()));
            } else {
                __log.verbose("SCTP SendDataQueue: current SACK state: nothing has been acknowledged yet.");
            }
            __log.verbose(StringExtensions.format("SCTP SendDataQueue: received {0}.", sack.toString()));
        }
        Object object = this.__lock;
        synchronized (object) {
            if (this.__oldSackChunk == null) {
                this.__dirty = true;
                if (SctpDataChunk.compareTsns(super.getEarliestTSN(), cumulativeTsnAck) != 1) {
                    ArrayListExtensions.addRange(list, this.processFullyAckedMessages(super.getEarliestTSN(), cumulativeTsnAck, false));
                }
                SctpDataChunk nextChunk = super.getNextChunk(cumulativeTsnAck);
                int index = 0;
                while (nextChunk != null && index < numberOfGapAckBlocks) {
                    if (SctpDataChunk.compareTsns(gapAckBlocks[index].getAbsoluteGapAckBlockStart(), nextChunk.getTsn()) == 1) {
                        nextChunk = super.getNextChunk(nextChunk.getTsn());
                        continue;
                    }
                    if (SctpDataChunk.compareTsns(gapAckBlocks[index].getAbsoluteGapAckBlockStart(), nextChunk.getTsn()) != 1 && SctpDataChunk.compareTsns(((SctpGapAckBlock)gapAckBlocks[index]).getAbsoluteGapAckBlockEnd(), nextChunk.getTsn()) != 2) {
                        nextChunk.setAcked(true);
                        nextChunk = super.getNextChunk(nextChunk.getTsn());
                        continue;
                    }
                    ArrayListExtensions.addRange(list, this.processFullyAckedMessages(((SctpGapAckBlock)gapAckBlocks[index]).getAbsoluteGapAckBlockStart(), ((SctpGapAckBlock)gapAckBlocks[index]).getAbsoluteGapAckBlockEnd(), true));
                    ++index;
                }
            } else {
                long num10;
                long num9;
                int num8;
                boolean flag;
                this.__dirty = true;
                long tsnA = this.__oldSackChunk.getCumulativeTsnAck();
                SctpGapAckBlock[] blockArray2 = this.__oldSackChunk.getGapAckBlocks();
                int num5 = this.__oldSackChunk.getNumberOfGapAckBlocks();
                long tsn = cumulativeTsnAck;
                int num7 = 0;
                if (SctpDataChunk.compareTsns(tsnA, cumulativeTsnAck) == 2) {
                    ArrayListExtensions.addRange(list, this.processFullyAckedMessages(SctpDataChunk.incrementTSN(tsnA), cumulativeTsnAck, false));
                    flag = false;
                    for (num8 = 0; num8 < num5 && !flag; ++num8) {
                        if (SctpDataChunk.compareTsns(blockArray2[num8].getAbsoluteGapAckBlockEnd(), cumulativeTsnAck) == 1) {
                            flag = true;
                            num7 = num8;
                            continue;
                        }
                        if (num8 + 1 < num5) continue;
                        num7 = num8 + 1;
                    }
                } else if (SctpDataChunk.compareTsns(tsnA, cumulativeTsnAck) == 1) {
                    num9 = tsnA;
                    if (ArrayExtensions.getLength(gapAckBlocks) > 0) {
                        num9 = SctpDataChunk.minTsns(SctpDataChunk.decrementTSN(((SctpGapAckBlock)gapAckBlocks[0]).getAbsoluteGapAckBlockStart()), num9);
                    }
                    if (SctpDataChunk.compareTsns(num10 = SctpDataChunk.minTsns(super.getEarliestTSN(), SctpDataChunk.incrementTSN(cumulativeTsnAck)), num9) != 1) {
                        this.markAs(false, num10, num9);
                        tsn = num9;
                    } else {
                        tsn = num9;
                    }
                }
                for (int i = 0; i < numberOfGapAckBlocks; ++i) {
                    long absoluteGapAckBlockStart = ((SctpGapAckBlock)gapAckBlocks[i]).getAbsoluteGapAckBlockStart();
                    long absoluteGapAckBlockEnd = ((SctpGapAckBlock)gapAckBlocks[i]).getAbsoluteGapAckBlockEnd();
                    num10 = SctpDataChunk.incrementTSN(tsn);
                    num9 = SctpDataChunk.decrementTSN(absoluteGapAckBlockStart);
                    if (SctpDataChunk.compareTsns(num10, tsnA) == 2) {
                        if (SctpDataChunk.compareTsns(num9, tsnA) != 1) {
                            this.markAs(false, num10, num9);
                            tsn = num9;
                        } else {
                            this.markAs(false, num10, tsnA);
                            tsn = tsnA;
                        }
                    }
                    flag = false;
                    for (num8 = num7; num8 < num5 && !flag; ++num8) {
                        long tsnB = SctpDataChunk.maxTsns(blockArray2[num8].getAbsoluteGapAckBlockStart(), SctpDataChunk.incrementTSN(tsn));
                        if (SctpDataChunk.compareTsns(num9, tsnB) != 2) {
                            num10 = tsnB;
                            long endTsn = SctpDataChunk.minTsns(num9, blockArray2[num8].getAbsoluteGapAckBlockEnd());
                            this.markAs(false, num10, endTsn);
                            tsn = endTsn;
                        }
                        if (SctpDataChunk.compareTsns(blockArray2[num8].getAbsoluteGapAckBlockEnd(), num9) != 2) {
                            flag = true;
                            num7 = num8;
                            continue;
                        }
                        if (num8 + 1 < num5) continue;
                        num7 = num8 + 1;
                    }
                    long num16 = absoluteGapAckBlockStart;
                    flag = false;
                    for (num8 = num7; num8 < num5 && !flag; ++num8) {
                        boolean flag2;
                        long num17;
                        if (SctpDataChunk.compareTsns(num16, blockArray2[num8].getAbsoluteGapAckBlockStart()) == 2 && SctpDataChunk.compareTsns(num17 = SctpDataChunk.decrementTSN(blockArray2[num8].getAbsoluteGapAckBlockStart()), tsn) == 1) {
                            this.markAs(true, num16, num17);
                            tsn = num17;
                        }
                        if (SctpDataChunk.compareTsns(absoluteGapAckBlockEnd, blockArray2[num8].getAbsoluteGapAckBlockEnd()) == 1) {
                            num16 = SctpDataChunk.incrementTSN(blockArray2[num8].getAbsoluteGapAckBlockEnd());
                            tsn = blockArray2[num8].getAbsoluteGapAckBlockEnd();
                            if (num8 + 1 < num5 && SctpDataChunk.compareTsns(absoluteGapAckBlockEnd, blockArray2[num8 + 1].getAbsoluteGapAckBlockEnd()) == 1) {
                                tsn = SctpDataChunk.decrementTSN(blockArray2[num8 + 1].getAbsoluteGapAckBlockStart());
                                this.markAs(true, num16, tsn);
                            }
                        } else {
                            num16 = SctpDataChunk.incrementTSN(absoluteGapAckBlockEnd);
                        }
                        boolean bl = flag2 = num8 + 1 < num5;
                        if (SctpDataChunk.compareTsns(blockArray2[num8].getAbsoluteGapAckBlockEnd(), absoluteGapAckBlockEnd) != 2 || flag2 && SctpDataChunk.compareTsns(blockArray2[num8 + 1].getAbsoluteGapAckBlockStart(), absoluteGapAckBlockEnd) == 1) {
                            flag = true;
                            num7 = num8 + 1;
                            continue;
                        }
                        if (num8 + 1 < num5) continue;
                        num7 = num8 + 1;
                    }
                    this.markAs(true, num16, absoluteGapAckBlockEnd);
                    tsn = absoluteGapAckBlockEnd;
                    ArrayListExtensions.addRange(list, this.processFullyAckedMessages(absoluteGapAckBlockStart, absoluteGapAckBlockEnd, true));
                }
                for (int j = num7; j < num5; ++j) {
                    long startTsn = SctpDataChunk.maxTsns(SctpDataChunk.incrementTSN(tsn), blockArray2[j].getAbsoluteGapAckBlockStart());
                    this.markAs(false, startTsn, blockArray2[j].getAbsoluteGapAckBlockEnd());
                    tsn = SctpDataChunk.maxTsns(blockArray2[j].getAbsoluteGapAckBlockEnd(), SctpDataChunk.maxTsns(tsn, blockArray2[j].getAbsoluteGapAckBlockStart()));
                }
            }
            this.__oldSackChunk = sack;
        }
        return list.toArray(new SctpDataChunk[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("SCTP SendDataQueue: purging data chunks with TSN prior to and including {0}", LongExtensions.toString(tsn)));
            }
            super.purge(tsn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(long tsn) {
        Object object = this.__lock;
        synchronized (object) {
            this.__dirty = true;
            if (__log.getIsVerboseEnabled()) {
                __log.verbose(StringExtensions.format("SCTP SendDataQueue: removing data chunk with TSN {0}.", LongExtensions.toString(tsn)));
            }
            return super.remove(tsn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.__lock;
        synchronized (object) {
            super.removeAll();
        }
    }

    private void removeFromQueue(long start, long end) {
        long i = start;
        while (SctpDataChunk.compareTsns(i, end) != 1) {
            this.remove(i);
            i = SctpDataChunk.incrementTSN(i);
        }
    }

    public SctpSendDataQueue(Object lockObject) {
        this.__lock = lockObject;
    }
}

