/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.Scheduler;
import fm.icelink.SctpChunkType;
import fm.icelink.SctpInnerSctpTransportMode;
import fm.icelink.SctpPacket;
import fm.icelink.Transport;
import java.util.ArrayList;
import java.util.List;

class SctpInnerSctpTransport
extends Transport {
    private boolean __active;
    private Object __lock;
    private List<IAction1<DataBuffer>> __onReceive = new ArrayList<IAction1<DataBuffer>>();
    private Scheduler __scheduler;
    private SctpInnerSctpTransportMode _mode;
    private IAction1<DataBuffer> _onReceive = null;

    @Override
    public void addOnReceive(IAction1<DataBuffer> value) {
        if (value != null) {
            if (this._onReceive == null) {
                this._onReceive = new IAction1<DataBuffer>(){

                    @Override
                    public void invoke(DataBuffer p0) {
                        for (IAction1 action : new ArrayList(SctpInnerSctpTransport.this.__onReceive)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onReceive.add(value);
        }
    }

    @Override
    public boolean getIsClosed() {
        return !this.__active;
    }

    public SctpInnerSctpTransportMode getMode() {
        return this._mode;
    }

    @Override
    public void removeOnReceive(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceive, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceive.remove(value);
        if (this.__onReceive.size() == 0) {
            this._onReceive = null;
        }
    }

    public SctpInnerSctpTransport(Object lockObject, Scheduler scheduler, SctpInnerSctpTransportMode mode) {
        this.__lock = lockObject;
        this.__scheduler = scheduler;
        this.setMode(mode);
    }

    @Override
    public void send(DataBuffer buffer) {
        boolean flag = false;
        if (this.__active) {
            try {
                IAction1<DataBuffer> onReceive;
                SctpPacket packet;
                if (Global.equals((Object)this.getMode(), (Object)SctpInnerSctpTransportMode.DeliverAllPackets)) {
                    flag = true;
                } else if (Global.equals((Object)this.getMode(), (Object)SctpInnerSctpTransportMode.FilterOutINITChunks) && (packet = SctpPacket.parseBytes(buffer.toArray())) != null && packet.getChunks()[0].getType() != SctpChunkType.getInitiation()) {
                    flag = true;
                }
                if (flag && (onReceive = this._onReceive) != null) {
                    onReceive.invoke(buffer);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setMode(SctpInnerSctpTransportMode value) {
        this._mode = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.__lock;
        synchronized (object) {
            if (!this.__active) {
                this.__active = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.__lock;
        synchronized (object) {
            if (this.__active) {
                this.__active = false;
                return true;
            }
            return false;
        }
    }
}

