/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpChunk;
import fm.icelink.SctpTlvParameter;

class SctpHeartbeatInfoChunkParameter
extends SctpTlvParameter {
    private byte[] _senderSpecificHeartbeatInfo;

    @Override
    public byte[] getBytes() {
        return SctpHeartbeatInfoChunkParameter.getBytes(this);
    }

    public static byte[] getBytes(SctpHeartbeatInfoChunkParameter parameter) {
        ByteCollection bytes = new ByteCollection();
        try {
            bytes.addRange(Binary.toBytes16(parameter.getType(), false));
            byte[] senderSpecificHeartbeatInfo = parameter.getSenderSpecificHeartbeatInfo();
            bytes.addRange(Binary.toBytes16(4 + ArrayExtensions.getLength(senderSpecificHeartbeatInfo), false));
            bytes.addRange(senderSpecificHeartbeatInfo);
            SctpChunk.addPadding(bytes);
        }
        catch (Exception exception1) {
            Log.error("SCTP: could not generate IPv4ChunkParameter");
            return null;
        }
        return bytes.toArray();
    }

    public byte[] getSenderSpecificHeartbeatInfo() {
        return this._senderSpecificHeartbeatInfo;
    }

    public static SctpHeartbeatInfoChunkParameter parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int len = Binary.fromBytes16(bytes, 2, false);
            byte[] destination = new byte[len - 4];
            BitAssistant.copy(bytes, 4, destination, 0, len - 4);
            int num2 = SctpChunk.calculatePaddingBytes(len);
            offsetPlus.setValue(len + num2);
            return new SctpHeartbeatInfoChunkParameter(destination);
        }
        catch (Exception exception1) {
            Log.debug("Could not read HeartbeatInfoChunkParameter.");
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpHeartbeatInfoChunkParameter(byte[] senderSpecificHeartbeatInfo) {
        super.setType(1);
        this.setSenderSpecificHeartbeatInfo(senderSpecificHeartbeatInfo);
    }

    public void setSenderSpecificHeartbeatInfo(byte[] value) {
        this._senderSpecificHeartbeatInfo = value;
    }
}

