/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.BitAssistant;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.SctpDataChunk;

class SctpGapAckBlock {
    private long _absoluteGapAckBlockEnd;
    private long _absoluteGapAckBlockStart;

    public long getAbsoluteGapAckBlockEnd() {
        return this._absoluteGapAckBlockEnd;
    }

    public long getAbsoluteGapAckBlockStart() {
        return this._absoluteGapAckBlockStart;
    }

    public byte[] getBytes(long cumulativeTsn) {
        return SctpGapAckBlock.getBytes(this, cumulativeTsn);
    }

    public static byte[] getBytes(SctpGapAckBlock chunk, long cumulativeTsn) {
        ByteCollection bytes = new ByteCollection();
        long num = SctpDataChunk.subtractTSN(chunk.getAbsoluteGapAckBlockStart(), cumulativeTsn);
        long num2 = SctpDataChunk.subtractTSN(chunk.getAbsoluteGapAckBlockEnd(), cumulativeTsn);
        bytes.addRange(Binary.toBytes16((int)num, false));
        bytes.addRange(Binary.toBytes16((int)num2, false));
        return bytes.toArray();
    }

    public static SctpGapAckBlock parseBytes(byte[] value, int startIndex, long cumulativeTsn, IntegerHolder offsetPlus) {
        try {
            byte[] destination = new byte[ArrayExtensions.getLength(value) - startIndex];
            BitAssistant.copy(value, startIndex, destination, 0, ArrayExtensions.getLength(destination));
            long start = SctpDataChunk.addTSN(Binary.fromBytes16(destination, 0, false), cumulativeTsn);
            long end = SctpDataChunk.addTSN(Binary.fromBytes16(destination, 2, false), cumulativeTsn);
            offsetPlus.setValue(4);
            return new SctpGapAckBlock(start, end);
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpGapAckBlock(long start, long end) {
        this.setAbsoluteGapAckBlockStart(start);
        this.setAbsoluteGapAckBlockEnd(end);
    }

    public void setAbsoluteGapAckBlockEnd(long value) {
        this._absoluteGapAckBlockEnd = value;
    }

    public void setAbsoluteGapAckBlockStart(long value) {
        this._absoluteGapAckBlockStart = value;
    }
}

